/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.quest;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Bat;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.quest.DarkGold;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.Callback;
import com.watabou.utils.PathFinder;
import java.util.ArrayList;

public class Pickaxe
extends Weapon {
    public static final String AC_MINE = "MINE";
    public static final float TIME_TO_MINE = 2.0f;
    private static final ItemSprite.Glowing BLOODY = new ItemSprite.Glowing(0x550000);
    public boolean bloodStained;
    private static final String BLOODSTAINED = "bloodStained";

    public Pickaxe() {
        this.image = ItemSpriteSheet.PICKAXE;
        this.levelKnown = true;
        this.unique = true;
        this.bones = false;
        this.defaultAction = AC_MINE;
        this.bloodStained = false;
    }

    @Override
    public int min(int lvl) {
        return 2;
    }

    @Override
    public int max(int lvl) {
        return 15;
    }

    @Override
    public int STRReq(int lvl) {
        return Pickaxe.STRReq(3, lvl);
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        actions.add(AC_MINE);
        return actions;
    }

    @Override
    public void execute(final Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals(AC_MINE)) {
            if (Dungeon.depth < 11 || Dungeon.depth > 15) {
                GLog.w(Messages.get(this, "no_vein", new Object[0]), new Object[0]);
                return;
            }
            for (int i = 0; i < PathFinder.NEIGHBOURS8.length; ++i) {
                final int pos = hero.pos + PathFinder.NEIGHBOURS8[i];
                if (Dungeon.level.map[pos] != 12) continue;
                hero.spend(2.0f);
                hero.busy();
                hero.sprite.attack(pos, new Callback(){

                    public void call() {
                        CellEmitter.center(pos).burst(Speck.factory(1), 7);
                        Sample.INSTANCE.play((Object)"sounds/evoke.mp3");
                        Level.set(pos, 4);
                        GameScene.updateMap(pos);
                        DarkGold gold = new DarkGold();
                        if (gold.doPickUp(Dungeon.hero)) {
                            GLog.i(Messages.get(Dungeon.hero, "you_now_have", gold.name()), new Object[0]);
                        } else {
                            Dungeon.level.drop((Item)gold, (int)hero.pos).sprite.drop();
                        }
                        hero.onOperateComplete();
                    }
                });
                return;
            }
            GLog.w(Messages.get(this, "no_vein", new Object[0]), new Object[0]);
        }
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }

    @Override
    public boolean isIdentified() {
        return true;
    }

    @Override
    public int proc(Char attacker, final Char defender, int damage) {
        if (!this.bloodStained && defender instanceof Bat) {
            Actor.add(new Actor(){
                {
                    this.actPriority = 100;
                }

                @Override
                protected boolean act() {
                    if (!defender.isAlive()) {
                        Pickaxe.this.bloodStained = true;
                        Item.updateQuickslot();
                    }
                    Actor.remove(this);
                    return true;
                }
            });
        }
        return damage;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(BLOODSTAINED, this.bloodStained);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.bloodStained = bundle.getBoolean(BLOODSTAINED);
    }

    @Override
    public ItemSprite.Glowing glowing() {
        return this.bloodStained ? BLOODY : null;
    }
}

