/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.rings;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.Ring;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.utils.Random;

public class RingOfForce
extends Ring {
    public RingOfForce() {
        this.icon = ItemSpriteSheet.Icons.RING_FORCE;
    }

    @Override
    protected Ring.RingBuff buff() {
        return new Force();
    }

    public static int armedDamageBonus(Char ch) {
        return RingOfForce.getBuffedBonus(ch, Force.class);
    }

    private static float tier(int str) {
        float tier = Math.max(1.0f, (float)(str - 8) / 2.0f);
        if (tier > 5.0f) {
            tier = 5.0f + (tier - 5.0f) / 2.0f;
        }
        return tier;
    }

    public static int damageRoll(Hero hero) {
        if (hero.buff(Force.class) != null) {
            int level = RingOfForce.getBuffedBonus(hero, Force.class);
            float tier = RingOfForce.tier(hero.STR());
            return Random.NormalIntRange((int)RingOfForce.min(level, tier), (int)RingOfForce.max(level, tier));
        }
        return Random.NormalIntRange((int)1, (int)Math.max(hero.STR() - 8, 1));
    }

    private static int min(int lvl, float tier) {
        return Math.max(0, Math.round(tier + (float)lvl));
    }

    private static int max(int lvl, float tier) {
        return Math.max(0, Math.round(5.0f * (tier + 1.0f) + (float)lvl * (tier + 1.0f)));
    }

    @Override
    public String statsInfo() {
        float tier = RingOfForce.tier(Dungeon.hero.STR());
        if (this.isIdentified()) {
            int level = this.soloBuffedBonus();
            return Messages.get(this, "stats", RingOfForce.min(level, tier), RingOfForce.max(level, tier), level);
        }
        return Messages.get(this, "typical_stats", RingOfForce.min(1, tier), RingOfForce.max(1, tier), 1);
    }

    public class Force
    extends Ring.RingBuff {
    }
}

