/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.scrolls;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.MirrorImage;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.Scroll;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfTeleportation;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class ScrollOfMirrorImage
extends Scroll {
    private static final int NIMAGES = 2;

    public ScrollOfMirrorImage() {
        this.icon = ItemSpriteSheet.Icons.SCROLL_MIRRORIMG;
    }

    @Override
    public void doRead() {
        int spawnedImages = ScrollOfMirrorImage.spawnImages(curUser, 2);
        if (spawnedImages > 0) {
            this.identify();
        }
        Sample.INSTANCE.play((Object)"sounds/read.mp3");
        this.readAnimation();
    }

    public static int spawnImages(Hero hero, int nImages) {
        ArrayList<Integer> respawnPoints = new ArrayList<Integer>();
        for (int i = 0; i < PathFinder.NEIGHBOURS8.length; ++i) {
            int p = hero.pos + PathFinder.NEIGHBOURS8[i];
            if (Actor.findChar(p) != null || !Dungeon.level.passable[p]) continue;
            respawnPoints.add(p);
        }
        int spawned = 0;
        while (nImages > 0 && respawnPoints.size() > 0) {
            int index = Random.index(respawnPoints);
            MirrorImage mob = new MirrorImage();
            mob.duplicate(hero);
            GameScene.add(mob);
            ScrollOfTeleportation.appear(mob, (Integer)respawnPoints.get(index));
            respawnPoints.remove(index);
            --nImages;
            ++spawned;
        }
        return spawned;
    }

    @Override
    public int value() {
        return this.isKnown() ? 30 * this.quantity : super.value();
    }

    public static class DelayedImageSpawner
    extends Buff {
        private int totImages;
        private int imPerRound;
        private float delay;
        private static final String TOTAL = "images";
        private static final String PER_ROUND = "per_round";
        private static final String DELAY = "delay";

        public DelayedImageSpawner() {
            this(2, 2, 1.0f);
        }

        public DelayedImageSpawner(int total, int perRound, float delay) {
            this.totImages = total;
            this.imPerRound = perRound;
            this.delay = delay;
        }

        @Override
        public boolean attachTo(Char target) {
            if (super.attachTo(target)) {
                this.spend(this.delay);
                return true;
            }
            return false;
        }

        @Override
        public boolean act() {
            int spawned = ScrollOfMirrorImage.spawnImages((Hero)this.target, Math.min(this.totImages, this.imPerRound));
            this.totImages -= spawned;
            if (this.totImages < 0) {
                this.detach();
            } else {
                this.spend(this.delay);
            }
            return true;
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(TOTAL, this.totImages);
            bundle.put(PER_ROUND, this.imPerRound);
            bundle.put(DELAY, this.delay);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.totImages = bundle.getInt(TOTAL);
            this.imPerRound = bundle.getInt(PER_ROUND);
            this.delay = bundle.getFloat(DELAY);
        }
    }
}

