/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.spells;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Shopkeeper;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.ArcaneCatalyst;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.Spell;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.ui.RedButton;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndBag;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndEnergizeItem;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndInfoItem;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndTradeItem;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.Image;
import com.watabou.noosa.audio.Sample;

public class Alchemize
extends Spell {
    private static WndBag parentWnd;
    private static WndBag.ItemSelector itemSelector;

    public Alchemize() {
        this.image = ItemSpriteSheet.ALCHEMIZE;
    }

    @Override
    protected void onCast(Hero hero) {
        parentWnd = GameScene.selectItem(itemSelector);
    }

    @Override
    public int value() {
        return Math.round((float)this.quantity * 5.0f);
    }

    static {
        itemSelector = new WndBag.ItemSelector(){

            @Override
            public String textPrompt() {
                return Messages.get(Alchemize.class, "prompt", new Object[0]);
            }

            @Override
            public boolean itemSelectable(Item item) {
                return !(item instanceof Alchemize) && (Shopkeeper.canSell(item) || item.energyVal() > 0);
            }

            @Override
            public void onSelect(Item item) {
                if (item != null) {
                    if (parentWnd != null) {
                        parentWnd = GameScene.selectItem(itemSelector);
                    }
                    GameScene.show(new WndAlchemizeItem(item, parentWnd));
                }
            }
        };
    }

    public static class WndAlchemizeItem
    extends WndInfoItem {
        private static final float GAP = 2.0f;
        private static final int BTN_HEIGHT = 18;
        private WndBag owner;

        public WndAlchemizeItem(final Item item, WndBag owner) {
            super(item);
            this.owner = owner;
            float pos = this.height;
            if (Shopkeeper.canSell(item)) {
                if (item.quantity() == 1) {
                    RedButton btnSell = new RedButton(Messages.get((Object)this, "sell", item.value())){

                        @Override
                        protected void onClick() {
                            WndTradeItem.sell(item);
                            this.hide();
                            this.consumeAlchemize();
                        }
                    };
                    btnSell.setRect(0.0f, pos + 2.0f, this.width, 18.0f);
                    btnSell.icon((Image)new ItemSprite(ItemSpriteSheet.GOLD));
                    this.add((Gizmo)btnSell);
                    pos = btnSell.bottom();
                } else {
                    int priceAll = item.value();
                    RedButton btnSell1 = new RedButton(Messages.get((Object)this, "sell_1", priceAll / item.quantity())){

                        @Override
                        protected void onClick() {
                            WndTradeItem.sellOne(item);
                            this.hide();
                            this.consumeAlchemize();
                        }
                    };
                    btnSell1.setRect(0.0f, pos + 2.0f, this.width, 18.0f);
                    btnSell1.icon((Image)new ItemSprite(ItemSpriteSheet.GOLD));
                    this.add((Gizmo)btnSell1);
                    RedButton btnSellAll = new RedButton(Messages.get((Object)this, "sell_all", priceAll)){

                        @Override
                        protected void onClick() {
                            WndTradeItem.sell(item);
                            this.hide();
                            this.consumeAlchemize();
                        }
                    };
                    btnSellAll.setRect(0.0f, btnSell1.bottom() + 1.0f, this.width, 18.0f);
                    btnSellAll.icon((Image)new ItemSprite(ItemSpriteSheet.GOLD));
                    this.add((Gizmo)btnSellAll);
                    pos = btnSellAll.bottom();
                }
            }
            if (item.energyVal() > 0) {
                if (item.quantity() == 1) {
                    RedButton btnEnergize = new RedButton(Messages.get((Object)this, "energize", item.energyVal())){

                        @Override
                        protected void onClick() {
                            WndEnergizeItem.energize(item);
                            this.hide();
                            this.consumeAlchemize();
                        }
                    };
                    btnEnergize.setRect(0.0f, pos + 2.0f, this.width, 18.0f);
                    btnEnergize.icon((Image)new ItemSprite(ItemSpriteSheet.ENERGY));
                    this.add((Gizmo)btnEnergize);
                    pos = btnEnergize.bottom();
                } else {
                    int energyAll = item.energyVal();
                    RedButton btnEnergize1 = new RedButton(Messages.get((Object)this, "energize_1", energyAll / item.quantity())){

                        @Override
                        protected void onClick() {
                            WndEnergizeItem.energizeOne(item);
                            this.hide();
                            this.consumeAlchemize();
                        }
                    };
                    btnEnergize1.setRect(0.0f, pos + 2.0f, this.width, 18.0f);
                    btnEnergize1.icon((Image)new ItemSprite(ItemSpriteSheet.ENERGY));
                    this.add((Gizmo)btnEnergize1);
                    RedButton btnEnergizeAll = new RedButton(Messages.get((Object)this, "energize_all", energyAll)){

                        @Override
                        protected void onClick() {
                            WndEnergizeItem.energize(item);
                            this.hide();
                            this.consumeAlchemize();
                        }
                    };
                    btnEnergizeAll.setRect(0.0f, btnEnergize1.bottom() + 1.0f, this.width, 18.0f);
                    btnEnergizeAll.icon((Image)new ItemSprite(ItemSpriteSheet.ENERGY));
                    this.add((Gizmo)btnEnergizeAll);
                    pos = btnEnergizeAll.bottom();
                }
            }
            this.resize(this.width, (int)pos);
        }

        private void consumeAlchemize() {
            Sample.INSTANCE.play((Object)"sounds/teleport.mp3");
            if (curItem.quantity() <= 1) {
                curItem.detachAll(Dungeon.hero.belongings.backpack);
                if (this.owner != null) {
                    this.owner.hide();
                }
            } else {
                curItem.detach(Dungeon.hero.belongings.backpack);
                if (this.owner != null) {
                    this.owner.hide();
                }
                GameScene.selectItem(itemSelector);
            }
        }
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{ArcaneCatalyst.class};
            this.inQuantity = new int[]{1};
            this.cost = 2;
            this.output = Alchemize.class;
            this.outQuantity = 8;
        }
    }
}

