/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.spells;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.MerchantsBeacon;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.ArcaneCatalyst;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.InventorySpell;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import java.util.ArrayList;

public class MagicalPorter
extends InventorySpell {
    public MagicalPorter() {
        this.image = ItemSpriteSheet.MAGIC_PORTER;
    }

    @Override
    protected void onCast(Hero hero) {
        if (Dungeon.depth >= 25) {
            GLog.w(Messages.get(this, "nowhere", new Object[0]), new Object[0]);
        } else {
            super.onCast(hero);
        }
    }

    @Override
    protected boolean usableOnItem(Item item) {
        return !item.isEquipped(Dungeon.hero);
    }

    @Override
    protected void onItemSelected(Item item) {
        Item result = item.detachAll(MagicalPorter.curUser.belongings.backpack);
        int portDepth = 5 * (1 + Dungeon.depth / 5);
        ArrayList<Item> ported = (ArrayList<Item>)Dungeon.portedItems.get(portDepth);
        if (ported == null) {
            ported = new ArrayList<Item>();
            Dungeon.portedItems.put(portDepth, ported);
        }
        ported.add(result);
    }

    @Override
    public int value() {
        return Math.round((float)this.quantity * 5.625f);
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{MerchantsBeacon.class, ArcaneCatalyst.class};
            this.inQuantity = new int[]{1, 1};
            this.cost = 4;
            this.output = MagicalPorter.class;
            this.outQuantity = 8;
        }
    }
}

