/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.spells;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.PinCushion;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.DwarfKing;
import com.shatteredpixel.shatteredpixeldungeon.effects.MagicMissile;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.LiquidMetal;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.ArcaneCatalyst;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.TargetedSpell;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.Visual;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Callback;

public class TelekineticGrab
extends TargetedSpell {
    public TelekineticGrab() {
        this.image = ItemSpriteSheet.TELE_GRAB;
    }

    @Override
    protected void fx(Ballistica bolt, Callback callback) {
        MagicMissile.boltFromChar(TelekineticGrab.curUser.sprite.parent, 6, (Visual)TelekineticGrab.curUser.sprite, bolt.collisionPos, callback);
        Sample.INSTANCE.play((Object)"sounds/zap.mp3");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void affectTarget(Ballistica bolt, Hero hero) {
        Char ch = Actor.findChar(bolt.collisionPos);
        if (!(ch != null || bolt.path.size() <= bolt.dist + 1 || (ch = Actor.findChar(bolt.path.get(bolt.dist + 1))) instanceof DwarfKing && Dungeon.level.solid[ch.pos])) {
            ch = null;
        }
        if (ch != null && ch.buff(PinCushion.class) != null) {
            Item item = ch.buff(PinCushion.class).grabOne();
            if (item.doPickUp(hero, ch.pos)) {
                hero.spend(-1.0f);
                return;
            }
            GLog.w(Messages.get(this, "cant_grab", new Object[0]), new Object[0]);
            Dungeon.level.drop((Item)item, (int)ch.pos).sprite.drop();
            return;
        }
        if (Dungeon.level.heaps.get(bolt.collisionPos.intValue()) == null) {
            GLog.w(Messages.get(this, "no_target", new Object[0]), new Object[0]);
            return;
        }
        Heap h = (Heap)Dungeon.level.heaps.get(bolt.collisionPos.intValue());
        if (h.type != Heap.Type.HEAP) {
            GLog.w(Messages.get(this, "cant_grab", new Object[0]), new Object[0]);
            h.sprite.drop();
            return;
        }
        Item item = h.peek();
        if (item.doPickUp(hero, h.pos)) {
            h.pickUp();
            hero.spend(-1.0f);
            return;
        }
        GLog.w(Messages.get(this, "cant_grab", new Object[0]), new Object[0]);
        h.sprite.drop();
    }

    @Override
    public int value() {
        return Math.round((float)this.quantity * 7.5f);
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{LiquidMetal.class, ArcaneCatalyst.class};
            this.inQuantity = new int[]{10, 1};
            this.cost = 2;
            this.output = TelekineticGrab.class;
            this.outQuantity = 6;
        }
    }
}

