/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.spells;

import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ArtifactRecharge;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Recharging;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.Recipe;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.Artifact;
import com.shatteredpixel.shatteredpixeldungeon.items.quest.MetalShard;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfRecharging;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.exotic.ScrollOfMysticalEnergy;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.TargetedSpell;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.CursedWand;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Callback;

public class WildEnergy
extends TargetedSpell {
    public WildEnergy() {
        this.image = ItemSpriteSheet.WILD_ENERGY;
        this.usesTargeting = true;
    }

    @Override
    protected void fx(Ballistica bolt, Callback callback) {
        CursedWand.cursedZap(this, curUser, bolt, callback);
    }

    @Override
    protected void affectTarget(Ballistica bolt, Hero hero) {
        Sample.INSTANCE.play((Object)"sounds/lightning.mp3");
        Sample.INSTANCE.play((Object)"sounds/chargeup.mp3");
        ScrollOfRecharging.charge(hero);
        hero.belongings.charge(1.0f);
        for (Buff b : hero.buffs()) {
            if (!(b instanceof Artifact.ArtifactBuff)) continue;
            ((Artifact.ArtifactBuff)b).charge(hero, 4.0f);
        }
        Buff.affect(hero, Recharging.class, 8.0f);
        Buff.affect((Char)hero, ArtifactRecharge.class).prolong((float)8.0f).ignoreHornOfPlenty = false;
    }

    @Override
    public int value() {
        return Math.round((float)this.quantity * 20.0f);
    }

    public static class Recipe
    extends Recipe.SimpleRecipe {
        public Recipe() {
            this.inputs = new Class[]{ScrollOfMysticalEnergy.class, MetalShard.class};
            this.inQuantity = new int[]{1, 1};
            this.cost = 4;
            this.output = WildEnergy.class;
            this.outQuantity = 5;
        }
    }
}

