/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.stones;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.FlavourBuff;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.stones.Runestone;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Bundle;

public class StoneOfAggression
extends Runestone {
    public StoneOfAggression() {
        this.image = ItemSpriteSheet.STONE_AGGRESSION;
    }

    @Override
    protected void activate(int cell) {
        Char ch = Actor.findChar(cell);
        if (ch != null) {
            if (ch.alignment == Char.Alignment.ENEMY) {
                Buff.prolong(ch, Aggression.class, 5.0f);
            } else {
                Buff.prolong(ch, Aggression.class, 20.0f);
            }
            CellEmitter.center(cell).start(Speck.factory(5), 0.3f, 3);
            Sample.INSTANCE.play((Object)"sounds/read.mp3");
        } else {
            Heap heap = Dungeon.level.drop(this, cell);
            if (!heap.isEmpty()) {
                heap.sprite.drop(cell);
            }
        }
    }

    public static class Aggression
    extends FlavourBuff {
        public static final float DURATION = 20.0f;

        public Aggression() {
            this.type = Buff.buffType.NEGATIVE;
            this.announced = true;
        }

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
        }

        @Override
        public void detach() {
            if (this.target.isAlive() && this.target.alignment == Char.Alignment.ENEMY) {
                for (Mob m : Dungeon.level.mobs) {
                    if (m.alignment != Char.Alignment.ENEMY || !m.isTargeting(this.target)) continue;
                    m.aggro(null);
                }
            }
            super.detach();
        }

        public String toString() {
            return Messages.get(this, "name", new Object[0]);
        }
    }
}

