/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.wands;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Paralysis;
import com.shatteredpixel.shatteredpixeldungeon.effects.Effects;
import com.shatteredpixel.shatteredpixeldungeon.effects.MagicMissile;
import com.shatteredpixel.shatteredpixeldungeon.effects.Pushing;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.DamageWand;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.enchantments.Elastic;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.melee.MagesStaff;
import com.shatteredpixel.shatteredpixeldungeon.levels.features.Door;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.TenguDartTrap;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.noosa.Game;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.Group;
import com.watabou.noosa.Image;
import com.watabou.noosa.Visual;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Callback;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;

public class WandOfBlastWave
extends DamageWand {
    public WandOfBlastWave() {
        this.image = ItemSpriteSheet.WAND_BLAST_WAVE;
        this.collisionProperties = 7;
    }

    @Override
    public int min(int lvl) {
        return 1 + lvl;
    }

    @Override
    public int max(int lvl) {
        return 3 + 3 * lvl;
    }

    @Override
    public void onZap(Ballistica bolt) {
        Sample.INSTANCE.play((Object)"sounds/blast.mp3");
        BlastWave.blast(bolt.collisionPos);
        for (int i : PathFinder.NEIGHBOURS9) {
            if (Dungeon.level.traps.get(bolt.collisionPos + i) instanceof TenguDartTrap) continue;
            Dungeon.level.pressCell(bolt.collisionPos + i);
        }
        for (int i : PathFinder.NEIGHBOURS8) {
            Char ch = Actor.findChar(bolt.collisionPos + i);
            if (ch == null) continue;
            this.wandProc(ch, this.chargesPerCast());
            if (ch.alignment != Char.Alignment.ALLY) {
                ch.damage(this.damageRoll(), this);
            }
            if (ch.pos != bolt.collisionPos + i) continue;
            Ballistica trajectory = new Ballistica(ch.pos, ch.pos + i, 6);
            int strength = 1 + Math.round((float)this.buffedLvl() / 2.0f);
            WandOfBlastWave.throwChar(ch, trajectory, strength, false);
        }
        Char ch = Actor.findChar(bolt.collisionPos);
        if (ch != null) {
            this.wandProc(ch, this.chargesPerCast());
            ch.damage(this.damageRoll(), this);
            if (bolt.path.size() > bolt.dist + 1 && ch.pos == bolt.collisionPos) {
                Ballistica trajectory = new Ballistica(ch.pos, bolt.path.get(bolt.dist + 1), 6);
                int strength = this.buffedLvl() + 3;
                WandOfBlastWave.throwChar(ch, trajectory, strength, false);
            }
        }
    }

    public static void throwChar(Char ch, Ballistica trajectory, int power) {
        WandOfBlastWave.throwChar(ch, trajectory, power, true);
    }

    public static void throwChar(Char ch, Ballistica trajectory, int power, boolean closeDoors) {
        WandOfBlastWave.throwChar(ch, trajectory, power, closeDoors, true);
    }

    public static void throwChar(final Char ch, Ballistica trajectory, int power, final boolean closeDoors, boolean collideDmg) {
        int dist;
        boolean collided;
        if (ch.properties().contains((Object)Char.Property.BOSS)) {
            power /= 2;
        }
        boolean bl = collided = (dist = Math.min(trajectory.dist, power)) == trajectory.dist;
        if (dist == 0 || ch.rooted || ch.properties().contains((Object)Char.Property.IMMOVABLE)) {
            return;
        }
        if (Char.hasProp(ch, Char.Property.LARGE)) {
            for (int i = 1; i <= dist; ++i) {
                if (Dungeon.level.openSpace[trajectory.path.get(i)]) continue;
                dist = i - 1;
                collided = true;
                break;
            }
        }
        if (Actor.findChar(trajectory.path.get(dist)) != null) {
            --dist;
            collided = true;
        }
        if (dist < 0) {
            return;
        }
        final int newPos = trajectory.path.get(dist);
        if (newPos == ch.pos) {
            return;
        }
        final int finalDist = dist;
        final boolean finalCollided = collided && collideDmg;
        final int initialpos = ch.pos;
        Actor.addDelayed(new Pushing(ch, ch.pos, newPos, new Callback(){

            public void call() {
                if (initialpos != ch.pos) {
                    ch.sprite.place(ch.pos);
                    return;
                }
                int oldPos = ch.pos;
                ch.pos = newPos;
                if (finalCollided && ch.isAlive()) {
                    ch.damage(Random.NormalIntRange((int)finalDist, (int)(2 * finalDist)), this);
                    Paralysis.prolong(ch, Paralysis.class, 1.0f + (float)finalDist / 2.0f);
                }
                if (closeDoors && Dungeon.level.map[oldPos] == 6) {
                    Door.leave(oldPos);
                }
                Dungeon.level.occupyCell(ch);
                if (ch == Dungeon.hero) {
                    Dungeon.observe();
                }
            }
        }), -1.0f);
    }

    @Override
    public void onHit(MagesStaff staff, Char attacker, Char defender, int damage) {
        new Elastic().proc(staff, attacker, defender, damage);
    }

    @Override
    public void fx(Ballistica bolt, Callback callback) {
        MagicMissile.boltFromChar(WandOfBlastWave.curUser.sprite.parent, 5, (Visual)WandOfBlastWave.curUser.sprite, bolt.collisionPos, callback);
        Sample.INSTANCE.play((Object)"sounds/zap.mp3");
    }

    @Override
    public void staffFx(MagesStaff.StaffParticle particle) {
        particle.color(0x664422);
        particle.am = 0.6f;
        particle.setLifespan(3.0f);
        particle.speed.polar(Random.Float((float)6.283185f), 0.3f);
        particle.setSize(1.0f, 2.0f);
        particle.radiateXY(2.5f);
    }

    public static class BlastWave
    extends Image {
        private static final float TIME_TO_FADE = 0.2f;
        private float time;

        public BlastWave() {
            super(Effects.get(Effects.Type.RIPPLE));
            this.origin.set(this.width / 2.0f, this.height / 2.0f);
        }

        public void reset(int pos) {
            this.revive();
            this.x = (float)(pos % Dungeon.level.width() * 16) + (16.0f - this.width) / 2.0f;
            this.y = (float)(pos / Dungeon.level.width() * 16) + (16.0f - this.height) / 2.0f;
            this.time = 0.2f;
        }

        public void update() {
            float f;
            super.update();
            this.time -= Game.elapsed;
            if (f <= 0.0f) {
                this.kill();
            } else {
                float p = this.time / 0.2f;
                this.alpha(p);
                this.scale.y = this.scale.x = (1.0f - p) * 3.0f;
            }
        }

        public static void blast(int pos) {
            Group parent = Dungeon.hero.sprite.parent;
            BlastWave b = (BlastWave)parent.recycle(BlastWave.class);
            parent.bringToFront((Gizmo)b);
            b.reset(pos);
        }
    }
}

