/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.enchantments;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.LeafParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class Blooming
extends Weapon.Enchantment {
    private static ItemSprite.Glowing DARK_GREEN = new ItemSprite.Glowing(34816);

    @Override
    public int proc(Weapon weapon, Char attacker, Char defender, int damage) {
        int level = Math.max(0, weapon.buffedLvl());
        float procChance = ((float)level + 1.0f) / ((float)level + 3.0f) * this.procChanceMultiplier(attacker);
        if (Random.Float() < procChance) {
            boolean secondPlant;
            boolean bl = secondPlant = level > Random.Int((int)10);
            if (this.plantGrass(defender.pos)) {
                if (secondPlant) {
                    secondPlant = false;
                } else {
                    return damage;
                }
            }
            ArrayList<Integer> positions = new ArrayList<Integer>();
            for (int i : PathFinder.NEIGHBOURS8) {
                positions.add(i);
            }
            Random.shuffle(positions);
            Object object = positions.iterator();
            while (object.hasNext()) {
                int i = (Integer)object.next();
                if (!this.plantGrass(defender.pos + i)) continue;
                if (secondPlant) {
                    secondPlant = false;
                    continue;
                }
                return damage;
            }
        }
        return damage;
    }

    private boolean plantGrass(int cell) {
        int t = Dungeon.level.map[cell];
        if ((t == 1 || t == 20 || t == 9 || t == 2 || t == 30) && Dungeon.level.plants.get(cell) == null) {
            Level.set(cell, 15);
            GameScene.updateMap(cell);
            CellEmitter.get(cell).burst(LeafParticle.LEVEL_SPECIFIC, 4);
            return true;
        }
        return false;
    }

    @Override
    public ItemSprite.Glowing glowing() {
        return DARK_GREEN;
    }
}

