/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.enchantments;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.ShadowParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.watabou.utils.Random;

public class Grim
extends Weapon.Enchantment {
    private static ItemSprite.Glowing BLACK = new ItemSprite.Glowing(0);

    @Override
    public int proc(Weapon weapon, Char attacker, Char defender, int damage) {
        int level = Math.max(0, weapon.buffedLvl());
        int enemyHealth = defender.HP - damage;
        if (enemyHealth <= 0) {
            return damage;
        }
        float maxChance = 0.5f + 0.05f * (float)level;
        float chanceMulti = (float)Math.pow((float)(defender.HT - enemyHealth) / (float)defender.HT, 2.0);
        float chance = maxChance * chanceMulti;
        chance *= this.procChanceMultiplier(attacker);
        if (Random.Float() < chance) {
            defender.damage(defender.HP, this);
            defender.sprite.emitter().burst(ShadowParticle.UP, 5);
            if (!defender.isAlive() && attacker instanceof Hero && weapon.hasEnchant(Grim.class, attacker)) {
                Badges.validateGrimWeapon();
            }
        }
        return damage;
    }

    @Override
    public ItemSprite.Glowing glowing() {
        return BLACK;
    }
}

