/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles;

import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.utils.Random;

public class Kunai
extends MissileWeapon {
    private Char enemy;

    public Kunai() {
        this.image = ItemSpriteSheet.KUNAI;
        this.hitSound = "sounds/hit_stab.mp3";
        this.hitSoundPitch = 1.1f;
        this.tier = 3;
        this.baseUses = 5.0f;
    }

    @Override
    protected void onThrow(int cell) {
        this.enemy = Actor.findChar(cell);
        super.onThrow(cell);
    }

    @Override
    public int damageRoll(Char owner) {
        if (owner instanceof Hero) {
            Hero hero = (Hero)owner;
            if (this.enemy instanceof Mob && ((Mob)this.enemy).surprisedBy(hero)) {
                int diff = this.max() - this.min();
                int damage = this.augment.damageFactor(Random.NormalIntRange((int)(this.min() + Math.round((float)diff * 0.6f)), (int)this.max()));
                int exStr = hero.STR() - this.STRReq();
                if (exStr > 0) {
                    damage += Random.IntRange((int)0, (int)exStr);
                }
                return damage;
            }
        }
        return super.damageRoll(owner);
    }
}

