/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.journal;

import com.shatteredpixel.shatteredpixeldungeon.journal.Journal;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.watabou.utils.Bundle;
import com.watabou.utils.DeviceCompat;
import java.util.Collection;
import java.util.LinkedHashMap;

public enum Document {
    ADVENTURERS_GUIDE(ItemSpriteSheet.GUIDE_PAGE),
    ALCHEMY_GUIDE(ItemSpriteSheet.ALCH_PAGE);

    private static final int NOT_FOUND = 0;
    private static final int FOUND = 1;
    private static final int READ = 2;
    private LinkedHashMap<String, Integer> pagesStates = new LinkedHashMap();
    private int pageSprite;
    public static final String GUIDE_INTRO = "Intro";
    public static final String GUIDE_EXAMINING = "Examining";
    public static final String GUIDE_SURPRISE_ATKS = "Surprise_Attacks";
    public static final String GUIDE_IDING = "Identifying";
    public static final String GUIDE_FOOD = "Food";
    public static final String GUIDE_DIEING = "Dieing";
    public static final String GUIDE_SEARCHING = "Searching";
    private static final String DOCUMENTS = "documents";

    private Document(int sprite) {
        this.pageSprite = sprite;
    }

    public boolean findPage(String page) {
        if (this.pagesStates.containsKey(page) && this.pagesStates.get(page) == 0) {
            this.pagesStates.put(page, 1);
            Journal.saveNeeded = true;
            return true;
        }
        return false;
    }

    public boolean findPage(int pageIdx) {
        return this.findPage(this.pagesStates.keySet().toArray(new String[0])[pageIdx]);
    }

    public boolean isPageFound(String page) {
        return this.pagesStates.containsKey(page) && this.pagesStates.get(page) > 0;
    }

    public boolean isPageFound(int pageIdx) {
        return this.isPageFound(this.pagesStates.keySet().toArray(new String[0])[pageIdx]);
    }

    public boolean readPage(String page) {
        if (this.pagesStates.containsKey(page) && this.pagesStates.get(page) == 1) {
            this.pagesStates.put(page, 2);
            Journal.saveNeeded = true;
            return true;
        }
        return false;
    }

    public boolean readPage(int pageIdx) {
        return this.readPage(this.pagesStates.keySet().toArray(new String[0])[pageIdx]);
    }

    public boolean isPageRead(String page) {
        return this.pagesStates.containsKey(page) && this.pagesStates.get(page) == 2;
    }

    public boolean isPageRead(int pageIdx) {
        return this.isPageRead(this.pagesStates.keySet().toArray(new String[0])[pageIdx]);
    }

    public Collection<String> pageNames() {
        return this.pagesStates.keySet();
    }

    public int pageIdx(String name) {
        int i = 0;
        for (String page : this.pagesStates.keySet()) {
            if (page.equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int pageSprite() {
        return this.pageSprite;
    }

    public String title() {
        return Messages.get((Object)this, this.name() + ".title", new Object[0]);
    }

    public String pageTitle(String page) {
        return Messages.get((Object)this, this.name() + "." + page + ".title", new Object[0]);
    }

    public String pageTitle(int pageIdx) {
        return this.pageTitle(this.pagesStates.keySet().toArray(new String[0])[pageIdx]);
    }

    public String pageBody(String page) {
        return Messages.get((Object)this, this.name() + "." + page + ".body", new Object[0]);
    }

    public String pageBody(int pageIdx) {
        return this.pageBody(this.pagesStates.keySet().toArray(new String[0])[pageIdx]);
    }

    public static void store(Bundle bundle) {
        Bundle docsBundle = new Bundle();
        for (Document doc : Document.values()) {
            Bundle pagesBundle = new Bundle();
            boolean empty = true;
            for (String page : doc.pageNames()) {
                if (doc.pagesStates.get(page) == 0) continue;
                pagesBundle.put(page, doc.pagesStates.get(page).intValue());
                empty = false;
            }
            if (empty) continue;
            docsBundle.put(doc.name(), pagesBundle);
        }
        bundle.put(DOCUMENTS, docsBundle);
    }

    public static void restore(Bundle bundle) {
        if (!bundle.contains(DOCUMENTS)) {
            return;
        }
        Bundle docsBundle = bundle.getBundle(DOCUMENTS);
        for (Document doc : Document.values()) {
            if (!docsBundle.contains(doc.name())) continue;
            Bundle pagesBundle = docsBundle.getBundle(doc.name());
            if (pagesBundle.isNull()) {
                for (String page : docsBundle.getStringArray(doc.name())) {
                    if (!doc.pagesStates.containsKey(page)) continue;
                    doc.pagesStates.put(page, 2);
                }
                continue;
            }
            for (String page : doc.pageNames()) {
                if (!pagesBundle.contains(page)) continue;
                doc.pagesStates.put(page, pagesBundle.getInt(page));
            }
        }
    }

    static {
        boolean debug = DeviceCompat.isDebug();
        Document.ADVENTURERS_GUIDE.pagesStates.put(GUIDE_INTRO, debug ? 2 : 1);
        Document.ADVENTURERS_GUIDE.pagesStates.put(GUIDE_EXAMINING, debug ? 2 : 1);
        Document.ADVENTURERS_GUIDE.pagesStates.put(GUIDE_SURPRISE_ATKS, debug ? 2 : 1);
        Document.ADVENTURERS_GUIDE.pagesStates.put(GUIDE_IDING, debug ? 2 : 1);
        Document.ADVENTURERS_GUIDE.pagesStates.put(GUIDE_FOOD, debug ? 2 : 1);
        Document.ADVENTURERS_GUIDE.pagesStates.put(GUIDE_DIEING, debug ? 2 : 1);
        Document.ADVENTURERS_GUIDE.pagesStates.put(GUIDE_SEARCHING, debug ? 2 : 0);
        Document.ADVENTURERS_GUIDE.pagesStates.put("Strength", debug ? 2 : 0);
        Document.ADVENTURERS_GUIDE.pagesStates.put("Upgrades", debug ? 2 : 0);
        Document.ADVENTURERS_GUIDE.pagesStates.put("Looting", debug ? 2 : 0);
        Document.ADVENTURERS_GUIDE.pagesStates.put("Levelling", debug ? 2 : 0);
        Document.ADVENTURERS_GUIDE.pagesStates.put("Positioning", debug ? 2 : 0);
        Document.ADVENTURERS_GUIDE.pagesStates.put("Magic", debug ? 2 : 0);
        Document.ALCHEMY_GUIDE.pagesStates.put("Potions", debug ? 2 : 0);
        Document.ALCHEMY_GUIDE.pagesStates.put("Stones", debug ? 2 : 0);
        Document.ALCHEMY_GUIDE.pagesStates.put("Energy_Food", debug ? 2 : 0);
        Document.ALCHEMY_GUIDE.pagesStates.put("Exotic_Potions", debug ? 2 : 0);
        Document.ALCHEMY_GUIDE.pagesStates.put("Exotic_Scrolls", debug ? 2 : 0);
        Document.ALCHEMY_GUIDE.pagesStates.put("Bombs", debug ? 2 : 0);
        Document.ALCHEMY_GUIDE.pagesStates.put("Weapons", debug ? 2 : 0);
        Document.ALCHEMY_GUIDE.pagesStates.put("Catalysts", debug ? 2 : 0);
        Document.ALCHEMY_GUIDE.pagesStates.put("Brews_Elixirs", debug ? 2 : 0);
        Document.ALCHEMY_GUIDE.pagesStates.put("Spells", debug ? 2 : 0);
    }
}

