/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels;

import com.shatteredpixel.shatteredpixeldungeon.Bones;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.GoldenMimic;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mimic;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.Artifact;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.DriedRose;
import com.shatteredpixel.shatteredpixeldungeon.items.food.SmallRation;
import com.shatteredpixel.shatteredpixeldungeon.items.journal.GuidePage;
import com.shatteredpixel.shatteredpixeldungeon.items.keys.GoldenKey;
import com.shatteredpixel.shatteredpixeldungeon.journal.Document;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.builders.Builder;
import com.shatteredpixel.shatteredpixeldungeon.levels.builders.FigureEightBuilder;
import com.shatteredpixel.shatteredpixeldungeon.levels.builders.LoopBuilder;
import com.shatteredpixel.shatteredpixeldungeon.levels.painters.Painter;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.Room;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.secret.SecretRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.special.PitRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.special.ShopRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.special.SpecialRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard.EntranceRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard.ExitRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard.StandardRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.BlazingTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.BurningTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.ChillingTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.DisintegrationTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.ExplosiveTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.FrostTrap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.Trap;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.WornDartTrap;
import com.watabou.utils.Bundle;
import com.watabou.utils.Point;
import com.watabou.utils.Random;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class RegularLevel
extends Level {
    protected ArrayList<Room> rooms;
    protected Builder builder;
    protected Room roomEntrance;
    protected Room roomExit;

    @Override
    protected boolean build() {
        this.builder = this.builder();
        ArrayList<Room> initRooms = this.initRooms();
        Random.shuffle(initRooms);
        do {
            for (Room r : initRooms) {
                r.neigbours.clear();
                r.connected.clear();
            }
            this.rooms = this.builder.build((ArrayList)initRooms.clone());
        } while (this.rooms == null);
        return this.painter().paint(this, this.rooms);
    }

    protected ArrayList<Room> initRooms() {
        ArrayList<Room> initRooms = new ArrayList<Room>();
        this.roomEntrance = new EntranceRoom();
        initRooms.add(this.roomEntrance);
        this.roomExit = new ExitRoom();
        initRooms.add(this.roomExit);
        int standards = this.standardRooms(this.feeling == Level.Feeling.LARGE);
        if (this.feeling == Level.Feeling.LARGE) {
            standards = (int)Math.ceil((float)standards * 1.5f);
        }
        for (int i = 0; i < standards; ++i) {
            StandardRoom s;
            while (!(s = StandardRoom.createRoom()).setSizeCat(standards - i)) {
            }
            i += s.sizeCat.roomValue - 1;
            initRooms.add(s);
        }
        if (Dungeon.shopOnLevel()) {
            initRooms.add(new ShopRoom());
        }
        int specials = this.specialRooms(this.feeling == Level.Feeling.LARGE);
        if (this.feeling == Level.Feeling.LARGE) {
            ++specials;
        }
        SpecialRoom.initForFloor();
        for (int i = 0; i < specials; ++i) {
            SpecialRoom s = SpecialRoom.createRoom();
            if (s instanceof PitRoom) {
                ++specials;
            }
            initRooms.add(s);
        }
        int secrets = SecretRoom.secretsForFloor(Dungeon.depth);
        if (this.feeling == Level.Feeling.SECRETS) {
            ++secrets;
        }
        for (int i = 0; i < secrets; ++i) {
            initRooms.add(SecretRoom.createRoom());
        }
        return initRooms;
    }

    protected int standardRooms(boolean forceMax) {
        return 0;
    }

    protected int specialRooms(boolean forceMax) {
        return 0;
    }

    protected Builder builder() {
        if (Random.Int((int)2) == 0) {
            return new LoopBuilder().setLoopShape(2, Random.Float((float)0.0f, (float)0.65f), Random.Float((float)0.0f, (float)0.5f));
        }
        return new FigureEightBuilder().setLoopShape(2, Random.Float((float)0.3f, (float)0.8f), 0.0f);
    }

    protected abstract Painter painter();

    protected int nTraps() {
        return Random.NormalIntRange((int)2, (int)(3 + Dungeon.depth / 5));
    }

    protected Class<?>[] trapClasses() {
        return new Class[]{WornDartTrap.class};
    }

    protected float[] trapChances() {
        return new float[]{1.0f};
    }

    @Override
    public int mobLimit() {
        if (Dungeon.depth <= 1) {
            return 0;
        }
        int mobs = 3 + Dungeon.depth % 5 + Random.Int((int)3);
        if (this.feeling == Level.Feeling.LARGE) {
            mobs = (int)Math.ceil((float)mobs * 1.33f);
        }
        return mobs;
    }

    @Override
    protected void createMobs() {
        int mobsToSpawn = Dungeon.depth == 1 ? 8 : this.mobLimit();
        ArrayList<Room> stdRooms = new ArrayList<Room>();
        for (Room room : this.rooms) {
            if (!(room instanceof StandardRoom) || room == this.roomEntrance) continue;
            for (int i = 0; i < ((StandardRoom)room).sizeCat.roomValue; ++i) {
                stdRooms.add(room);
            }
        }
        Random.shuffle(stdRooms);
        Iterator stdRoomIter = stdRooms.iterator();
        while (mobsToSpawn > 0) {
            Mob mob = this.createMob();
            if (!stdRoomIter.hasNext()) {
                stdRoomIter = stdRooms.iterator();
            }
            Room roomToSpawn = (Room)((Object)stdRoomIter.next());
            int tries = 30;
            do {
                mob.pos = this.pointToCell(roomToSpawn.random());
            } while (--tries >= 0 && (this.findMob(mob.pos) != null || !this.passable[mob.pos] || this.solid[mob.pos] || mob.pos == this.exit || !this.openSpace[mob.pos] && mob.properties().contains((Object)Char.Property.LARGE)));
            if (tries < 0) continue;
            this.mobs.add(mob);
            if (Dungeon.depth <= 1 || --mobsToSpawn <= 0 || Random.Int((int)4) != 0) continue;
            mob = this.createMob();
            tries = 30;
            do {
                mob.pos = this.pointToCell(roomToSpawn.random());
            } while (--tries >= 0 && (this.findMob(mob.pos) != null || !this.passable[mob.pos] || this.solid[mob.pos] || mob.pos == this.exit || !this.openSpace[mob.pos] && mob.properties().contains((Object)Char.Property.LARGE)));
            if (tries < 0) continue;
            --mobsToSpawn;
            this.mobs.add(mob);
        }
        for (Mob m : this.mobs) {
            if (this.map[m.pos] != 15 && this.map[m.pos] != 30) continue;
            this.map[m.pos] = 2;
            this.losBlocking[m.pos] = false;
        }
    }

    @Override
    public int randomRespawnCell(Char ch) {
        Room room;
        int count = 0;
        int cell = -1;
        do {
            if (++count <= 30) continue;
            return -1;
        } while ((room = this.randomRoom(StandardRoom.class)) == null || room == this.roomEntrance || this.heroFOV[cell = this.pointToCell(room.random(1))] || Actor.findChar(cell) != null || !this.passable[cell] || this.solid[cell] || Char.hasProp(ch, Char.Property.LARGE) && !this.openSpace[cell] || !room.canPlaceCharacter(this.cellToPoint(cell), this) || cell == this.exit);
        return cell;
    }

    @Override
    public int randomDestination(Char ch) {
        ArrayList<Point> points;
        Room room;
        int count = 0;
        int cell = -1;
        do {
            if (++count <= 30) continue;
            return -1;
        } while ((room = (Room)((Object)Random.element(this.rooms))) == null || (points = room.charPlaceablePoints(this)).isEmpty() || !this.passable[cell = this.pointToCell((Point)Random.element(points))] || Char.hasProp(ch, Char.Property.LARGE) && !this.openSpace[cell]);
        return cell;
    }

    @Override
    protected void createItems() {
        Talent.CachedRationsDropped dropped;
        DriedRose rose;
        int cell;
        int nItems = 3 + Random.chances((float[])new float[]{6.0f, 3.0f, 1.0f});
        if (this.feeling == Level.Feeling.LARGE) {
            nItems += 2;
        }
        block5: for (int i = 0; i < nItems; ++i) {
            Heap dropped2;
            Item toDrop = Generator.random();
            if (toDrop == null) continue;
            cell = this.randomDropCell();
            if (this.map[cell] == 15 || this.map[cell] == 30) {
                this.map[cell] = 2;
                this.losBlocking[cell] = false;
            }
            Heap.Type type = null;
            switch (Random.Int((int)20)) {
                case 0: {
                    type = Heap.Type.SKELETON;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    type = Heap.Type.CHEST;
                    break;
                }
                case 5: {
                    if (Dungeon.depth > 1 && this.findMob(cell) == null) {
                        this.mobs.add(Mimic.spawnAt(cell, toDrop));
                        continue block5;
                    }
                    type = Heap.Type.CHEST;
                    break;
                }
                default: {
                    type = Heap.Type.HEAP;
                }
            }
            if (toDrop instanceof Artifact && Random.Int((int)2) == 0 || toDrop.isUpgradable() && Random.Int((int)(4 - toDrop.level())) == 0) {
                if (Dungeon.depth > 1 && Random.Int((int)10) == 0 && this.findMob(cell) == null) {
                    this.mobs.add(Mimic.spawnAt(cell, toDrop, GoldenMimic.class));
                    continue;
                }
                dropped2 = this.drop(toDrop, cell);
                if (this.heaps.get(cell) != dropped2) continue;
                dropped2.type = Heap.Type.LOCKED_CHEST;
                this.addItemToSpawn(new GoldenKey(Dungeon.depth));
                continue;
            }
            dropped2 = this.drop(toDrop, cell);
            dropped2.type = type;
            if (type != Heap.Type.SKELETON) continue;
            dropped2.setHauntedIfCursed();
        }
        for (Item item : this.itemsToSpawn) {
            cell = this.randomDropCell();
            this.drop((Item)item, (int)cell).type = Heap.Type.HEAP;
            if (this.map[cell] != 15 && this.map[cell] != 30) continue;
            this.map[cell] = 2;
            this.losBlocking[cell] = false;
        }
        Random.pushGenerator((long)Dungeon.seedCurDepth());
        Item item = Bones.get();
        if (item != null) {
            this.epitaph = Bones.getEpitaph();
            int cell2 = this.randomDropCell();
            if (this.map[cell2] == 15 || this.map[cell2] == 30) {
                this.map[cell2] = 2;
                this.losBlocking[cell2] = false;
            }
            this.drop((Item)item, (int)cell2).setHauntedIfCursed().type = Heap.Type.REMAINS;
        }
        if ((rose = Dungeon.hero.belongings.getItem(DriedRose.class)) != null && rose.isIdentified() && !rose.cursed) {
            int petalsNeeded = (int)Math.ceil((float)(Dungeon.depth / 2 - rose.droppedPetals) / 3.0f);
            for (int i = 1; i <= petalsNeeded; ++i) {
                if (rose.droppedPetals >= 11) continue;
                item = new DriedRose.Petal();
                int cell3 = this.randomDropCell();
                this.drop((Item)item, (int)cell3).type = Heap.Type.HEAP;
                if (this.map[cell3] == 15 || this.map[cell3] == 30) {
                    this.map[cell3] = 2;
                    this.losBlocking[cell3] = false;
                }
                ++rose.droppedPetals;
            }
        }
        if (Dungeon.hero.hasTalent(Talent.CACHED_RATIONS) && (dropped = Buff.affect(Dungeon.hero, Talent.CachedRationsDropped.class)).count() < (float)(2 + 2 * Dungeon.hero.pointsInTalent(Talent.CACHED_RATIONS))) {
            int cell4;
            int tries = 100;
            do {
                cell4 = this.randomDropCell(SpecialRoom.class);
            } while (tries-- > 0 && (this.room(cell4) instanceof SecretRoom || this.room(cell4) instanceof ShopRoom));
            if (!(this.room(cell4) instanceof SecretRoom) && !(this.room(cell4) instanceof ShopRoom) && cell4 != -1) {
                if (this.map[cell4] == 15 || this.map[cell4] == 30) {
                    this.map[cell4] = 2;
                    this.losBlocking[cell4] = false;
                }
                this.drop((Item)new SmallRation(), (int)cell4).type = Heap.Type.CHEST;
                dropped.countUp(1.0f);
            }
        }
        Collection<String> allPages = Document.ADVENTURERS_GUIDE.pageNames();
        ArrayList<String> missingPages = new ArrayList<String>();
        for (String page : allPages) {
            if (Document.ADVENTURERS_GUIDE.isPageFound(page)) continue;
            missingPages.add(page);
        }
        missingPages.remove("Searching");
        float dropChance = 0.25f * (float)(Dungeon.depth - 1);
        if (!missingPages.isEmpty() && Random.Float() < dropChance) {
            GuidePage p = new GuidePage();
            p.page((String)missingPages.get(0));
            int cell5 = this.randomDropCell();
            if (this.map[cell5] == 15 || this.map[cell5] == 30) {
                this.map[cell5] = 2;
                this.losBlocking[cell5] = false;
            }
            this.drop(p, cell5);
        }
        Random.popGenerator();
    }

    public ArrayList<Room> rooms() {
        return new ArrayList<Room>(this.rooms);
    }

    public boolean hasPitRoom() {
        for (Room r : this.rooms) {
            if (!(r instanceof PitRoom)) continue;
            return true;
        }
        return false;
    }

    protected Room randomRoom(Class<? extends Room> type) {
        Random.shuffle(this.rooms);
        for (Room r : this.rooms) {
            if (!type.isInstance((Object)r)) continue;
            return r;
        }
        return null;
    }

    public Room room(int pos) {
        for (Room room : this.rooms) {
            if (!room.inside(this.cellToPoint(pos))) continue;
            return room;
        }
        return null;
    }

    protected int randomDropCell() {
        return this.randomDropCell(StandardRoom.class);
    }

    protected int randomDropCell(Class<? extends Room> roomType) {
        int tries = 100;
        while (tries-- > 0) {
            Trap t;
            int pos;
            Room room = this.randomRoom(roomType);
            if (room == null) {
                return -1;
            }
            if (room == this.roomEntrance || !this.passable[pos = this.pointToCell(room.random())] || this.solid[pos] || pos == this.exit || this.heaps.get(pos) != null || this.findMob(pos) != null || (t = (Trap)this.traps.get(pos)) != null && (t instanceof BurningTrap || t instanceof BlazingTrap || t instanceof ChillingTrap || t instanceof FrostTrap || t instanceof ExplosiveTrap || t instanceof DisintegrationTrap)) continue;
            return pos;
        }
        return -1;
    }

    @Override
    public int fallCell(boolean fallIntoPit) {
        if (fallIntoPit) {
            for (Room room : this.rooms) {
                int result;
                if (!(room instanceof PitRoom)) continue;
                while (this.traps.get(result = this.pointToCell(room.random())) != null || this.findMob(result) != null || this.heaps.get(result) != null) {
                }
                return result;
            }
        }
        return super.fallCell(false);
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put("rooms", this.rooms);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.rooms = new ArrayList(bundle.getCollection("rooms"));
        for (Room r : this.rooms) {
            r.onLevelLoad(this);
            if (r instanceof EntranceRoom) {
                this.roomEntrance = r;
                continue;
            }
            if (!(r instanceof ExitRoom)) continue;
            this.roomExit = r;
        }
    }
}

