/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels;

import com.shatteredpixel.shatteredpixeldungeon.Bones;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Goo;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.levels.PrisonLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.SewerLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.builders.Builder;
import com.shatteredpixel.shatteredpixeldungeon.levels.builders.FigureEightBuilder;
import com.shatteredpixel.shatteredpixeldungeon.levels.painters.Painter;
import com.shatteredpixel.shatteredpixeldungeon.levels.painters.SewerPainter;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.Room;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.secret.RatKingRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.sewerboss.GooBossRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.sewerboss.SewerBossEntranceRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.sewerboss.SewerBossExitRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.standard.StandardRoom;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.watabou.noosa.Game;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.Group;
import com.watabou.noosa.audio.Music;
import com.watabou.utils.Bundle;
import com.watabou.utils.Callback;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class SewerBossLevel
extends SewerLevel {
    private int stairs;
    private static final String STAIRS = "stairs";

    public SewerBossLevel() {
        this.color1 = 4748860;
        this.color2 = 5871946;
        this.stairs = 0;
    }

    @Override
    public void playLevelMusic() {
        if (this.locked) {
            Music.INSTANCE.play("music/sewers_boss.ogg", true);
            return;
        }
        boolean gooAlive = false;
        for (Mob m : this.mobs) {
            if (!(m instanceof Goo)) continue;
            gooAlive = true;
            break;
        }
        if (gooAlive) {
            Music.INSTANCE.end();
        } else {
            Music.INSTANCE.playTracks(new String[]{"music/sewers_1.ogg", "music/sewers_2.ogg", "music/sewers_2.ogg"}, new float[]{1.0f, 1.0f, 0.5f}, false);
        }
    }

    @Override
    protected ArrayList<Room> initRooms() {
        ArrayList<Room> initRooms = new ArrayList<Room>();
        this.roomEntrance = new SewerBossEntranceRoom();
        initRooms.add(this.roomEntrance);
        this.roomExit = new SewerBossExitRoom();
        initRooms.add(this.roomExit);
        int standards = this.standardRooms(true);
        for (int i = 0; i < standards; ++i) {
            StandardRoom s = StandardRoom.createRoom();
            s.setSizeCat(0, 0);
            initRooms.add(s);
        }
        GooBossRoom gooRoom = GooBossRoom.randomGooRoom();
        initRooms.add(gooRoom);
        ((FigureEightBuilder)this.builder).setLandmarkRoom(gooRoom);
        initRooms.add(new RatKingRoom());
        return initRooms;
    }

    @Override
    protected int standardRooms(boolean forceMax) {
        if (forceMax) {
            return 3;
        }
        return 2 + Random.chances((float[])new float[]{1.0f, 1.0f});
    }

    @Override
    protected Builder builder() {
        return new FigureEightBuilder().setLoopShape(2, Random.Float((float)0.3f, (float)0.8f), 0.0f).setPathLength(1.0f, new float[]{1.0f}).setTunnelLength(new float[]{1.0f, 2.0f}, new float[]{1.0f});
    }

    @Override
    protected Painter painter() {
        return new SewerPainter().setWater(0.5f, 5).setGrass(0.2f, 4).setTraps(this.nTraps(), this.trapClasses(), this.trapChances());
    }

    @Override
    protected int nTraps() {
        return 0;
    }

    @Override
    protected void createMobs() {
    }

    @Override
    public Actor addRespawner() {
        return null;
    }

    @Override
    protected void createItems() {
        Item item = Bones.get();
        if (item != null) {
            int pos;
            this.epitaph = Bones.getEpitaph();
            while ((pos = this.pointToCell(this.roomEntrance.random())) == this.entrance || this.solid[pos]) {
            }
            this.drop((Item)item, (int)pos).setHauntedIfCursed().type = Heap.Type.REMAINS;
        }
    }

    @Override
    public int randomRespawnCell(Char ch) {
        int pos;
        while ((pos = this.pointToCell(this.roomEntrance.random())) == this.entrance || !this.passable[pos] || Char.hasProp(ch, Char.Property.LARGE) && !this.openSpace[pos] || Actor.findChar(pos) != null) {
        }
        return pos;
    }

    @Override
    public void seal() {
        if (this.entrance != 0) {
            super.seal();
            SewerBossLevel.set(this.entrance, 29);
            GameScene.updateMap(this.entrance);
            GameScene.ripple(this.entrance);
            this.stairs = this.entrance;
            this.entrance = 0;
            Game.runOnRenderThread((Callback)new Callback(){

                public void call() {
                    Music.INSTANCE.play("music/sewers_boss.ogg", true);
                }
            });
        }
    }

    @Override
    public void unseal() {
        if (this.stairs != 0) {
            super.unseal();
            this.entrance = this.stairs;
            this.stairs = 0;
            SewerBossLevel.set(this.entrance, 7);
            GameScene.updateMap(this.entrance);
            Game.runOnRenderThread((Callback)new Callback(){

                public void call() {
                    Music.INSTANCE.end();
                }
            });
        }
    }

    @Override
    public Group addVisuals() {
        super.addVisuals();
        if (this.map[this.exit - 1] != 12) {
            this.visuals.add((Gizmo)new PrisonLevel.Torch(this.exit - 1));
        }
        if (this.map[this.exit + 1] != 12) {
            this.visuals.add((Gizmo)new PrisonLevel.Torch(this.exit + 1));
        }
        return this.visuals;
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(STAIRS, this.stairs);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.stairs = bundle.getInt(STAIRS);
        this.roomExit = this.roomEntrance;
    }
}

