/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels.features;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Bleeding;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Buff;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.Cripple;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.TimekeepersHourglass;
import com.shatteredpixel.shatteredpixeldungeon.items.spells.FeatherFall;
import com.shatteredpixel.shatteredpixeldungeon.levels.RegularLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.Room;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.special.WeakFloorRoom;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.plants.Swiftthistle;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.InterlevelScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.MobSprite;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndOptions;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Game;
import com.watabou.noosa.Image;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Callback;
import com.watabou.utils.Random;

public class Chasm
implements Hero.Doom {
    public static boolean jumpConfirmed = false;
    private static int heroPos;

    public static void heroJump(final Hero hero) {
        heroPos = hero.pos;
        Game.runOnRenderThread((Callback)new Callback(){

            public void call() {
                GameScene.show(new WndOptions(new Image((Object)Dungeon.level.tilesTex(), 48, 48, 16, 16), Messages.get(Chasm.class, "chasm", new Object[0]), Messages.get(Chasm.class, "jump", new Object[0]), new String[]{Messages.get(Chasm.class, "yes", new Object[0]), Messages.get(Chasm.class, "no", new Object[0])}){

                    @Override
                    protected void onSelect(int index) {
                        if (index == 0 && Dungeon.hero.pos == heroPos) {
                            jumpConfirmed = true;
                            hero.resume();
                        }
                    }
                });
            }
        });
    }

    public static void heroFall(int pos) {
        Swiftthistle.TimeBubble timeBubble;
        jumpConfirmed = false;
        Sample.INSTANCE.play((Object)"sounds/falling.mp3");
        TimekeepersHourglass.timeFreeze timeFreeze2 = Dungeon.hero.buff(TimekeepersHourglass.timeFreeze.class);
        if (timeFreeze2 != null) {
            timeFreeze2.disarmPressedTraps();
        }
        if ((timeBubble = Dungeon.hero.buff(Swiftthistle.TimeBubble.class)) != null) {
            timeBubble.disarmPressedTraps();
        }
        if (Dungeon.hero.isAlive()) {
            Room room;
            Dungeon.hero.interrupt();
            InterlevelScene.mode = InterlevelScene.Mode.FALL;
            InterlevelScene.fallIntoPit = Dungeon.level instanceof RegularLevel ? (room = ((RegularLevel)Dungeon.level).room(pos)) != null && room instanceof WeakFloorRoom : false;
            Game.switchScene(InterlevelScene.class);
        } else {
            Dungeon.hero.sprite.visible = false;
        }
    }

    @Override
    public void onDeath() {
        Badges.validateDeathFromFalling();
        Dungeon.fail(Chasm.class);
        GLog.n(Messages.get(Chasm.class, "ondeath", new Object[0]), new Object[0]);
    }

    public static void heroLand() {
        Hero hero = Dungeon.hero;
        FeatherFall.FeatherBuff b = hero.buff(FeatherFall.FeatherBuff.class);
        if (b != null) {
            hero.sprite.emitter().burst(Speck.factory(106), 20);
            b.detach();
            return;
        }
        Camera.main.shake(4.0f, 1.0f);
        Dungeon.level.occupyCell(hero);
        Buff.prolong(hero, Cripple.class, 10.0f);
        Buff.affect(hero, FallBleed.class).set(Math.round((float)hero.HT / (6.0f + 6.0f * ((float)hero.HP / (float)hero.HT))));
        hero.damage(Math.max(hero.HP / 2, Random.NormalIntRange((int)(hero.HP / 2), (int)(hero.HT / 4))), new Chasm());
    }

    public static void mobFall(Mob mob) {
        if (mob.isAlive()) {
            mob.die(Chasm.class);
        }
        if (mob.sprite != null) {
            ((MobSprite)mob.sprite).fall();
        }
    }

    public static class FallBleed
    extends Bleeding
    implements Hero.Doom {
        @Override
        public void onDeath() {
            Badges.validateDeathFromFalling();
        }
    }

    public static class Falling
    extends Buff {
        public Falling() {
            this.actPriority = 100;
        }

        @Override
        public boolean act() {
            Chasm.heroLand();
            this.detach();
            return true;
        }
    }
}

