/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels.features;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.ArmoredStatue;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.LeafParticle;
import com.shatteredpixel.shatteredpixeldungeon.items.Dewdrop;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.glyphs.Camouflage;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.DriedRose;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.SandalsOfNature;
import com.shatteredpixel.shatteredpixeldungeon.items.food.Berry;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.watabou.utils.Random;

public class HighGrass {
    private static boolean freezeTrample = false;

    public static void trample(Level level, int pos) {
        if (freezeTrample) {
            return;
        }
        Char ch = Actor.findChar(pos);
        if (level.map[pos] == 30) {
            if (ch instanceof Hero && ((Hero)ch).heroClass == HeroClass.HUNTRESS) {
                freezeTrample = true;
            } else {
                Level.set(pos, 2);
            }
        } else {
            ArmoredStatue statue;
            if (ch instanceof Hero && ((Hero)ch).heroClass == HeroClass.HUNTRESS) {
                Level.set(pos, 30);
                freezeTrample = true;
            } else {
                Level.set(pos, 2);
            }
            int naturalismLevel = 0;
            if (ch != null) {
                Talent.NatureBerriesAvailable berries;
                SandalsOfNature.Naturalism naturalism = ch.buff(SandalsOfNature.Naturalism.class);
                if (naturalism != null) {
                    if (!naturalism.isCursed()) {
                        naturalismLevel = naturalism.itemLevel() + 1;
                        naturalism.charge(1.0f);
                    } else {
                        naturalismLevel = -1;
                    }
                }
                if ((berries = ch.buff(Talent.NatureBerriesAvailable.class)) != null) {
                    int targetFloor = 2 + 2 * ((Hero)ch).pointsInTalent(Talent.NATURES_BOUNTY);
                    int n = (targetFloor = (int)((float)targetFloor - berries.count())) >= 5 ? 3 : 2;
                    boolean droppingBerry = false;
                    if (Dungeon.depth > (targetFloor += n)) {
                        droppingBerry = Random.Int((int)10) == 0;
                    } else if (Dungeon.depth == targetFloor) {
                        droppingBerry = Random.Int((int)30) == 0;
                    } else if (Dungeon.depth < targetFloor) {
                        boolean bl = droppingBerry = Random.Int((int)90) == 0;
                    }
                    if (droppingBerry) {
                        berries.countDown(1.0f);
                        level.drop((Item)new Berry(), (int)pos).sprite.drop();
                        if (berries.count() <= 0.0f) {
                            berries.detach();
                        }
                    }
                }
            }
            if (naturalismLevel >= 0) {
                if (Random.Int((int)(25 - naturalismLevel * 5)) == 0) {
                    level.drop((Item)Generator.random((Generator.Category)Generator.Category.SEED), (int)pos).sprite.drop();
                }
                if (Random.Int((int)(24 - naturalismLevel * 3)) <= 3) {
                    level.drop((Item)new Dewdrop(), (int)pos).sprite.drop();
                }
            }
            if (ch instanceof Hero) {
                Hero hero = (Hero)ch;
                if (hero.belongings.armor() != null && hero.belongings.armor().hasGlyph(Camouflage.class, hero)) {
                    Camouflage.activate(hero, hero.belongings.armor.buffedLvl());
                }
            } else if (ch instanceof DriedRose.GhostHero) {
                DriedRose.GhostHero ghost = (DriedRose.GhostHero)ch;
                if (ghost.armor() != null && ghost.armor().hasGlyph(Camouflage.class, ghost)) {
                    Camouflage.activate(ghost, ghost.armor().buffedLvl());
                }
            } else if (ch instanceof ArmoredStatue && (statue = (ArmoredStatue)ch).armor() != null && statue.armor().hasGlyph(Camouflage.class, statue)) {
                Camouflage.activate(statue, statue.armor().buffedLvl());
            }
        }
        freezeTrample = false;
        if (ShatteredPixelDungeon.scene() instanceof GameScene) {
            GameScene.updateMap(pos);
            CellEmitter.get(pos).burst(LeafParticle.LEVEL_SPECIFIC, 4);
            if (Dungeon.level.heroFOV[pos]) {
                Dungeon.observe();
            }
        }
    }
}

