/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels.rooms.secret;

import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.RatKing;
import com.shatteredpixel.shatteredpixeldungeon.items.Gold;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.painters.Painter;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.Room;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.secret.SecretRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.sewerboss.SewerBossEntranceRoom;
import com.watabou.utils.Random;

public class RatKingRoom
extends SecretRoom {
    @Override
    public boolean canConnect(Room r) {
        return !(r instanceof SewerBossEntranceRoom) && super.canConnect(r);
    }

    @Override
    public int maxHeight() {
        return 7;
    }

    @Override
    public int maxWidth() {
        return 7;
    }

    @Override
    public void paint(Level level) {
        int i;
        Painter.fill(level, this, 4);
        Painter.fill(level, this, 1, 14);
        Room.Door entrance = this.entrance();
        entrance.set(Room.Door.Type.HIDDEN);
        int door = entrance.x + entrance.y * level.width();
        for (i = this.left + 1; i < this.right; ++i) {
            RatKingRoom.addChest(level, (this.top + 1) * level.width() + i, door);
            RatKingRoom.addChest(level, (this.bottom - 1) * level.width() + i, door);
        }
        for (i = this.top + 2; i < this.bottom - 1; ++i) {
            RatKingRoom.addChest(level, i * level.width() + this.left + 1, door);
            RatKingRoom.addChest(level, i * level.width() + this.right - 1, door);
        }
        RatKing king = new RatKing();
        king.pos = level.pointToCell(this.random(2));
        level.mobs.add(king);
    }

    private static void addChest(Level level, int pos, int door) {
        if (pos == door - 1 || pos == door + 1 || pos == door - level.width() || pos == door + level.width()) {
            return;
        }
        Gold prize = new Gold(Random.IntRange((int)10, (int)25));
        level.drop((Item)prize, (int)pos).type = Heap.Type.CHEST;
    }
}

