/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels.traps;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Sheep;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.Trap;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.utils.BArray;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import java.util.ArrayList;
import java.util.Iterator;

public class FlockTrap
extends Trap {
    public FlockTrap() {
        this.color = 6;
        this.shape = 1;
    }

    @Override
    public void activate() {
        PathFinder.buildDistanceMap((int)this.pos, (boolean[])BArray.not(Dungeon.level.solid, null), (int)2);
        ArrayList<Integer> spawnPoints = new ArrayList<Integer>();
        for (int i = 0; i < PathFinder.distance.length; ++i) {
            if (PathFinder.distance[i] >= Integer.MAX_VALUE) continue;
            spawnPoints.add(i);
        }
        Iterator iterator = spawnPoints.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (!Dungeon.level.insideMap(i) || Actor.findChar(i) != null || Dungeon.level.pit[i]) continue;
            Sheep sheep = new Sheep();
            sheep.lifespan = Random.NormalIntRange((int)4, (int)8);
            sheep.pos = i;
            GameScene.add(sheep);
            CellEmitter.get(i).burst(Speck.factory(7), 4);
            Trap t = (Trap)Dungeon.level.traps.get(i);
            if (t != null && t.active) {
                if (t.disarmedByActivation) {
                    t.disarm();
                }
                t.reveal();
                t.activate();
            }
            Dungeon.level.occupyCell(sheep);
            Sample.INSTANCE.play((Object)"sounds/puff.mp3");
            Sample.INSTANCE.play((Object)"sounds/sheep.mp3");
        }
    }
}

