/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels.traps;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Fire;
import com.shatteredpixel.shatteredpixeldungeon.effects.Splash;
import com.shatteredpixel.shatteredpixeldungeon.items.wands.WandOfBlastWave;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.Trap;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.tiles.DungeonTilemap;
import com.shatteredpixel.shatteredpixeldungeon.utils.BArray;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.PathFinder;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class GeyserTrap
extends Trap {
    public int centerKnockBackDirection;

    public GeyserTrap() {
        this.color = 4;
        this.shape = 4;
        this.centerKnockBackDirection = -1;
    }

    @Override
    public void activate() {
        Splash.at(DungeonTilemap.tileCenterToWorld(this.pos), -1.5707963f, 1.5707963f, 6013411, 100, 0.01f);
        Sample.INSTANCE.play((Object)"sounds/gas.mp3", 1.0f, 0.75f);
        Fire fire = (Fire)Dungeon.level.blobs.get(Fire.class);
        PathFinder.buildDistanceMap((int)this.pos, (boolean[])BArray.not(Dungeon.level.solid, null), (int)2);
        for (int i = 0; i < PathFinder.distance.length; ++i) {
            if (PathFinder.distance[i] == 2 && Random.Int((int)3) > 0) {
                Dungeon.level.setCellToWater(true, i);
                if (fire == null) continue;
                fire.clear(i);
                continue;
            }
            if (PathFinder.distance[i] >= 2) continue;
            Dungeon.level.setCellToWater(true, i);
            if (fire == null) continue;
            fire.clear(i);
        }
        for (int i : PathFinder.NEIGHBOURS8) {
            Char ch = Actor.findChar(this.pos + i);
            if (ch == null) continue;
            Ballistica trajectory = new Ballistica(this.pos, ch.pos, 1);
            trajectory = new Ballistica(trajectory.collisionPos, trajectory.path.get(trajectory.path.size() - 1), 7);
            WandOfBlastWave.throwChar(ch, trajectory, 2, true);
        }
        Char ch = Actor.findChar(this.pos);
        if (ch != null) {
            int targetpos = -1;
            if (this.centerKnockBackDirection != -1) {
                targetpos = this.centerKnockBackDirection;
            } else if (ch == Dungeon.hero) {
                ArrayList<Integer> candidates = new ArrayList<Integer>();
                for (int i : PathFinder.NEIGHBOURS8) {
                    if (Dungeon.level.avoid[this.pos + i] || Dungeon.level.avoid[this.pos + i + i]) continue;
                    candidates.add(this.pos + i);
                }
                if (!candidates.isEmpty()) {
                    targetpos = (Integer)Random.element(candidates);
                }
            } else {
                targetpos = this.pos + PathFinder.NEIGHBOURS8[Random.Int((int)8)];
            }
            if (targetpos != -1) {
                Ballistica trajectory = new Ballistica(this.pos, targetpos, 6);
                WandOfBlastWave.throwChar(ch, trajectory, 2, true);
            }
        }
    }
}

