/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels.traps;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.MagicMissile;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.ShadowParticle;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.Trap;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.tiles.DungeonTilemap;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Callback;

public class GrimTrap
extends Trap {
    public GrimTrap() {
        this.color = 7;
        this.shape = 6;
        this.canBeHidden = false;
        this.avoidsHallways = true;
    }

    @Override
    public void activate() {
        Char target = Actor.findChar(this.pos);
        if (target == null) {
            float closestDist = Float.MAX_VALUE;
            for (Char ch : Actor.chars()) {
                float curDist = Dungeon.level.trueDistance(this.pos, ch.pos);
                if (ch.invisible > 0) {
                    curDist += 1000.0f;
                }
                Ballistica bolt = new Ballistica(this.pos, ch.pos, 7);
                if (bolt.collisionPos != ch.pos || !(curDist < closestDist)) continue;
                target = ch;
                closestDist = curDist;
            }
        }
        if (target != null) {
            final Char finalTarget = target;
            final GrimTrap trap = this;
            int damage = finalTarget == Dungeon.hero && (float)finalTarget.HP / (float)finalTarget.HT >= 0.9f ? finalTarget.HP - 1 : finalTarget.HP;
            final int finalDmg = damage;
            Actor.add(new Actor(){
                {
                    this.actPriority = 100;
                }

                @Override
                protected boolean act() {
                    final 1 toRemove = this;
                    ((MagicMissile)finalTarget.sprite.parent.recycle(MagicMissile.class)).reset(7, DungeonTilemap.tileCenterToWorld(GrimTrap.this.pos), finalTarget.sprite.center(), new Callback(){

                        public void call() {
                            finalTarget.damage(finalDmg, trap);
                            if (finalTarget == Dungeon.hero) {
                                Sample.INSTANCE.play((Object)"sounds/cursed.mp3");
                                if (!finalTarget.isAlive()) {
                                    Dungeon.fail(GrimTrap.class);
                                    GLog.n(Messages.get(GrimTrap.class, "ondeath", new Object[0]), new Object[0]);
                                }
                            } else {
                                Sample.INSTANCE.play((Object)"sounds/burning.mp3");
                            }
                            finalTarget.sprite.emitter().burst(ShadowParticle.UP, 10);
                            Actor.remove(toRemove);
                            this.next();
                        }
                    });
                    return false;
                }
            });
        } else {
            CellEmitter.get(this.pos).burst(ShadowParticle.UP, 10);
            Sample.INSTANCE.play((Object)"sounds/burning.mp3");
        }
    }
}

