/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.levels.traps;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.darts.Dart;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.Trap;
import com.shatteredpixel.shatteredpixeldungeon.mechanics.Ballistica;
import com.shatteredpixel.shatteredpixeldungeon.sprites.MissileSprite;
import com.watabou.noosa.Visual;
import com.watabou.noosa.audio.Sample;
import com.watabou.utils.Callback;
import com.watabou.utils.Random;

public class WornDartTrap
extends Trap {
    public WornDartTrap() {
        this.color = 7;
        this.shape = 5;
        this.canBeHidden = false;
        this.avoidsHallways = true;
    }

    @Override
    public void activate() {
        Char target = Actor.findChar(this.pos);
        if (target == null) {
            float closestDist = Float.MAX_VALUE;
            for (Char ch : Actor.chars()) {
                float curDist = Dungeon.level.trueDistance(this.pos, ch.pos);
                if (ch.invisible > 0) {
                    curDist += 1000.0f;
                }
                Ballistica bolt = new Ballistica(this.pos, ch.pos, 7);
                if (bolt.collisionPos != ch.pos || !(curDist < closestDist)) continue;
                target = ch;
                closestDist = curDist;
            }
        }
        if (target != null) {
            final Char finalTarget = target;
            final WornDartTrap trap = this;
            if (Dungeon.level.heroFOV[this.pos] || Dungeon.level.heroFOV[target.pos]) {
                Actor.add(new Actor(){
                    {
                        this.actPriority = 100;
                    }

                    @Override
                    protected boolean act() {
                        final 1 toRemove = this;
                        ((MissileSprite)ShatteredPixelDungeon.scene().recycle(MissileSprite.class)).reset(WornDartTrap.this.pos, (Visual)finalTarget.sprite, (Item)new Dart(), new Callback(){

                            public void call() {
                                int dmg = Random.NormalIntRange((int)4, (int)8) - finalTarget.drRoll();
                                finalTarget.damage(dmg, trap);
                                if (finalTarget == Dungeon.hero && !finalTarget.isAlive()) {
                                    Dungeon.fail(trap.getClass());
                                }
                                Sample.INSTANCE.play((Object)"sounds/hit.mp3", 1.0f, 1.0f, Random.Float((float)0.8f, (float)1.25f));
                                finalTarget.sprite.bloodBurstA(finalTarget.sprite.center(), dmg);
                                finalTarget.sprite.flash();
                                Actor.remove(toRemove);
                                this.next();
                            }
                        });
                        return false;
                    }
                });
            } else {
                finalTarget.damage(Random.NormalIntRange((int)4, (int)8) - finalTarget.drRoll(), trap);
            }
        }
    }
}

