/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.messages;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.I18NBundle;
import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Languages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IllegalFormatException;
import java.util.Locale;

public class Messages {
    private static ArrayList<I18NBundle> bundles;
    private static Languages lang;
    private static String[] prop_files;
    private static final HashSet<String> noCaps;

    public static Languages lang() {
        return lang;
    }

    public static void setup(Languages lang) {
        I18NBundle.setExceptionOnMissingKey((boolean)false);
        bundles = new ArrayList();
        Messages.lang = lang;
        Locale locale = new Locale(lang.code());
        for (String file : prop_files) {
            bundles.add(I18NBundle.createBundle((FileHandle)Gdx.files.internal(file), (Locale)locale));
        }
    }

    public static String get(String key, Object ... args) {
        return Messages.get(null, key, args);
    }

    public static String get(Object o, String k, Object ... args) {
        return Messages.get(o.getClass(), k, args);
    }

    public static String get(Class c, String k, Object ... args) {
        String key;
        if (c != null) {
            key = c.getName().replace("com.shatteredpixel.shatteredpixeldungeon.", "");
            key = key + "." + k;
        } else {
            key = k;
        }
        String value = Messages.getFromBundle(key.toLowerCase(Locale.ENGLISH));
        if (value != null) {
            if (args.length > 0) {
                return Messages.format(value, args);
            }
            return value;
        }
        if (c != null && c.getSuperclass() != null) {
            return Messages.get(c.getSuperclass(), k, args);
        }
        return "!!!NO TEXT FOUND!!!";
    }

    private static String getFromBundle(String key) {
        for (I18NBundle b : bundles) {
            String result = b.get(key);
            if (result.length() == key.length() + 6 && result.contains(key)) continue;
            return result;
        }
        return null;
    }

    public static String format(String format, Object ... args) {
        try {
            return String.format(Locale.ENGLISH, format, args);
        }
        catch (IllegalFormatException e) {
            ShatteredPixelDungeon.reportException((Throwable)e);
            return format;
        }
    }

    public static String capitalize(String str) {
        if (str.length() == 0) {
            return str;
        }
        return Character.toTitleCase(str.charAt(0)) + str.substring(1);
    }

    public static String titleCase(String str) {
        if (lang == Languages.ENGLISH) {
            String result = "";
            for (String word : str.split("(?<=\\p{Zs})")) {
                result = noCaps.contains(word.trim().toLowerCase(Locale.ENGLISH).replaceAll(":|[0-9]", "")) ? result + word : result + Messages.capitalize(word);
            }
            return Messages.capitalize(result);
        }
        return Messages.capitalize(str);
    }

    static {
        prop_files = new String[]{"messages/actors/actors", "messages/items/items", "messages/journal/journal", "messages/levels/levels", "messages/misc/misc", "messages/plants/plants", "messages/private/private", "messages/scenes/scenes", "messages/ui/ui", "messages/windows/windows"};
        Messages.setup(SPDSettings.language());
        noCaps = new HashSet<String>(Arrays.asList("a", "an", "and", "of", "by", "to", "the", "x"));
    }
}

