/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.plants;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.CellEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.Speck;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.TimekeepersHourglass;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfTeleportation;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.plants.Plant;
import com.shatteredpixel.shatteredpixeldungeon.plants.Swiftthistle;
import com.shatteredpixel.shatteredpixeldungeon.scenes.InterlevelScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.noosa.Game;

public class Fadeleaf
extends Plant {
    public Fadeleaf() {
        this.image = 10;
        this.seedClass = Seed.class;
    }

    @Override
    public void activate(Char ch) {
        if (ch instanceof Hero) {
            ((Hero)ch).curAction = null;
            if (((Hero)ch).subClass == HeroSubClass.WARDEN) {
                Swiftthistle.TimeBubble timeBubble;
                if (Dungeon.level.locked) {
                    GLog.w(Messages.get(ScrollOfTeleportation.class, "no_tele", new Object[0]), new Object[0]);
                    return;
                }
                TimekeepersHourglass.timeFreeze timeFreeze2 = Dungeon.hero.buff(TimekeepersHourglass.timeFreeze.class);
                if (timeFreeze2 != null) {
                    timeFreeze2.disarmPressedTraps();
                }
                if ((timeBubble = Dungeon.hero.buff(Swiftthistle.TimeBubble.class)) != null) {
                    timeBubble.disarmPressedTraps();
                }
                InterlevelScene.mode = InterlevelScene.Mode.RETURN;
                InterlevelScene.returnDepth = Math.max(1, Dungeon.depth - 1);
                InterlevelScene.returnPos = -2;
                Game.switchScene(InterlevelScene.class);
            } else {
                ScrollOfTeleportation.teleportChar((Hero)ch);
            }
        } else if (ch instanceof Mob && !ch.properties().contains((Object)Char.Property.IMMOVABLE)) {
            ScrollOfTeleportation.teleportChar(ch);
        }
        if (Dungeon.level.heroFOV[this.pos]) {
            CellEmitter.get(this.pos).start(Speck.factory(2), 0.2f, 3);
        }
    }

    public static class Seed
    extends Plant.Seed {
        public Seed() {
            this.image = ItemSpriteSheet.SEED_FADELEAF;
            this.plantClass = Fadeleaf.class;
        }
    }
}

