/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.scenes;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.Rankings;
import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.Statistics;
import com.shatteredpixel.shatteredpixeldungeon.actors.Actor;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.blobs.Blob;
import com.shatteredpixel.shatteredpixeldungeon.actors.buffs.ChampionEnemy;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.DemonSpawner;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Snake;
import com.shatteredpixel.shatteredpixeldungeon.effects.BannerSprites;
import com.shatteredpixel.shatteredpixeldungeon.effects.BlobEmitter;
import com.shatteredpixel.shatteredpixeldungeon.effects.EmoIcon;
import com.shatteredpixel.shatteredpixeldungeon.effects.Flare;
import com.shatteredpixel.shatteredpixeldungeon.effects.FloatingText;
import com.shatteredpixel.shatteredpixeldungeon.effects.Ripple;
import com.shatteredpixel.shatteredpixeldungeon.effects.SpellSprite;
import com.shatteredpixel.shatteredpixeldungeon.items.Ankh;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Honeypot;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.DriedRose;
import com.shatteredpixel.shatteredpixeldungeon.items.journal.Guidebook;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.Potion;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfTeleportation;
import com.shatteredpixel.shatteredpixeldungeon.journal.Document;
import com.shatteredpixel.shatteredpixeldungeon.journal.Journal;
import com.shatteredpixel.shatteredpixeldungeon.levels.Level;
import com.shatteredpixel.shatteredpixeldungeon.levels.RegularLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.Room;
import com.shatteredpixel.shatteredpixeldungeon.levels.rooms.secret.SecretRoom;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.Trap;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.plants.Plant;
import com.shatteredpixel.shatteredpixeldungeon.scenes.CellSelector;
import com.shatteredpixel.shatteredpixeldungeon.scenes.InterlevelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.TitleScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.CharSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.DiscardedItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.HeroSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.tiles.CustomTilemap;
import com.shatteredpixel.shatteredpixeldungeon.tiles.DungeonTerrainTilemap;
import com.shatteredpixel.shatteredpixeldungeon.tiles.DungeonTileSheet;
import com.shatteredpixel.shatteredpixeldungeon.tiles.DungeonWallsTilemap;
import com.shatteredpixel.shatteredpixeldungeon.tiles.FogOfWar;
import com.shatteredpixel.shatteredpixeldungeon.tiles.GridTileMap;
import com.shatteredpixel.shatteredpixeldungeon.tiles.RaisedTerrainTilemap;
import com.shatteredpixel.shatteredpixeldungeon.tiles.TerrainFeaturesTilemap;
import com.shatteredpixel.shatteredpixeldungeon.tiles.WallBlockingTilemap;
import com.shatteredpixel.shatteredpixeldungeon.ui.ActionIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.AttackIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.Banner;
import com.shatteredpixel.shatteredpixeldungeon.ui.BossHealthBar;
import com.shatteredpixel.shatteredpixeldungeon.ui.CharHealthIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.GameLog;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.InventoryPane;
import com.shatteredpixel.shatteredpixeldungeon.ui.LootIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.MenuPane;
import com.shatteredpixel.shatteredpixeldungeon.ui.QuickSlotButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.ResumeIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.RightClickMenu;
import com.shatteredpixel.shatteredpixeldungeon.ui.StatusPane;
import com.shatteredpixel.shatteredpixeldungeon.ui.Tag;
import com.shatteredpixel.shatteredpixeldungeon.ui.TargetHealthIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.Toast;
import com.shatteredpixel.shatteredpixeldungeon.ui.Toolbar;
import com.shatteredpixel.shatteredpixeldungeon.ui.Window;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndBag;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndGame;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndHero;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndInfoCell;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndInfoItem;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndInfoMob;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndInfoPlant;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndInfoTrap;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndMessage;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndOptions;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndResurrect;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndStory;
import com.watabou.glwrap.Blending;
import com.watabou.input.PointerEvent;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Game;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.Group;
import com.watabou.noosa.Image;
import com.watabou.noosa.NoosaScript;
import com.watabou.noosa.NoosaScriptNoLighting;
import com.watabou.noosa.SkinnedBlock;
import com.watabou.noosa.Visual;
import com.watabou.noosa.audio.Sample;
import com.watabou.noosa.particles.Emitter;
import com.watabou.utils.DeviceCompat;
import com.watabou.utils.GameMath;
import com.watabou.utils.Point;
import com.watabou.utils.PointF;
import com.watabou.utils.Random;
import com.watabou.utils.RectF;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;

public class GameScene
extends PixelScene {
    static GameScene scene;
    private SkinnedBlock water;
    private DungeonTerrainTilemap tiles;
    private GridTileMap visualGrid;
    private TerrainFeaturesTilemap terrainFeatures;
    private RaisedTerrainTilemap raisedTerrain;
    private DungeonWallsTilemap walls;
    private WallBlockingTilemap wallBlocking;
    private FogOfWar fog;
    private HeroSprite hero;
    private MenuPane menu;
    private StatusPane status;
    private BossHealthBar boss;
    private GameLog log;
    private static CellSelector cellSelector;
    private Group terrain;
    private Group customTiles;
    private Group levelVisuals;
    private Group customWalls;
    private Group ripples;
    private Group plants;
    private Group traps;
    private Group heaps;
    private Group mobs;
    private Group floorEmitters;
    private Group emitters;
    private Group effects;
    private Group gases;
    private Group spells;
    private Group statuses;
    private Group emoicons;
    private Group overFogEffects;
    private Group healthIndicators;
    private InventoryPane inventory;
    private static boolean invVisible;
    private Toolbar toolbar;
    private Toast prompt;
    private AttackIndicator attack;
    private LootIndicator loot;
    private ActionIndicator action;
    private ResumeIndicator resume;
    private static Thread actorThread;
    private ArrayList<Gizmo> toDestroy;
    private float notifyDelay;
    public static boolean updateItemDisplays;
    private static Point lastOffset;
    private boolean tagAttack;
    private boolean tagLoot;
    private boolean tagAction;
    private boolean tagResume;
    private static final CellSelector.Listener defaultCellListener;

    public GameScene() {
        this.inGameScene = true;
        this.toDestroy = new ArrayList();
        this.notifyDelay = 0.016666668f;
        this.tagAttack = false;
        this.tagLoot = false;
        this.tagAction = false;
        this.tagResume = false;
    }

    @Override
    public void create() {
        ArrayList ported;
        if (Dungeon.hero == null || Dungeon.level == null) {
            ShatteredPixelDungeon.switchNoFade(TitleScene.class);
            return;
        }
        Dungeon.level.playLevelMusic();
        SPDSettings.lastClass(Dungeon.hero.heroClass.ordinal());
        super.create();
        Camera.main.zoom(GameMath.gate((float)minZoom, (float)(defaultZoom + SPDSettings.zoom()), (float)maxZoom));
        scene = this;
        this.terrain = new Group();
        this.add((Gizmo)this.terrain);
        this.water = new SkinnedBlock(Dungeon.level.width() * 16, Dungeon.level.height() * 16, Dungeon.level.waterTex()){

            protected NoosaScript script() {
                return NoosaScriptNoLighting.get();
            }

            public void draw() {
                Blending.disable();
                super.draw();
                Blending.enable();
            }
        };
        this.water.autoAdjust = true;
        this.terrain.add((Gizmo)this.water);
        this.ripples = new Group();
        this.terrain.add((Gizmo)this.ripples);
        DungeonTileSheet.setupVariance(Dungeon.level.map.length, Dungeon.seedCurDepth());
        this.tiles = new DungeonTerrainTilemap();
        this.terrain.add((Gizmo)this.tiles);
        this.customTiles = new Group();
        this.terrain.add((Gizmo)this.customTiles);
        for (CustomTilemap visual : Dungeon.level.customTiles) {
            this.addCustomTile(visual);
        }
        this.visualGrid = new GridTileMap();
        this.terrain.add((Gizmo)this.visualGrid);
        this.terrainFeatures = new TerrainFeaturesTilemap(Dungeon.level.plants, Dungeon.level.traps);
        this.terrain.add((Gizmo)this.terrainFeatures);
        this.levelVisuals = Dungeon.level.addVisuals();
        this.add((Gizmo)this.levelVisuals);
        this.floorEmitters = new Group();
        this.add((Gizmo)this.floorEmitters);
        this.heaps = new Group();
        this.add((Gizmo)this.heaps);
        for (Heap heap : Dungeon.level.heaps.valueList()) {
            this.addHeapSprite(heap);
        }
        this.emitters = new Group();
        this.effects = new Group();
        this.healthIndicators = new Group();
        this.emoicons = new Group();
        this.overFogEffects = new Group();
        this.mobs = new Group();
        this.add((Gizmo)this.mobs);
        this.hero = new HeroSprite();
        this.hero.place(Dungeon.hero.pos);
        this.hero.updateArmor();
        this.mobs.add((Gizmo)this.hero);
        for (Mob mob : Dungeon.level.mobs) {
            this.addMobSprite(mob);
            if (!Statistics.amuletObtained) continue;
            mob.beckon(Dungeon.hero.pos);
        }
        this.raisedTerrain = new RaisedTerrainTilemap();
        this.add((Gizmo)this.raisedTerrain);
        this.walls = new DungeonWallsTilemap();
        this.add((Gizmo)this.walls);
        this.customWalls = new Group();
        this.add((Gizmo)this.customWalls);
        for (CustomTilemap visual : Dungeon.level.customWalls) {
            this.addCustomWall(visual);
        }
        this.wallBlocking = new WallBlockingTilemap();
        this.add((Gizmo)this.wallBlocking);
        this.add((Gizmo)this.emitters);
        this.add((Gizmo)this.effects);
        this.gases = new Group();
        this.add((Gizmo)this.gases);
        for (Blob blob : Dungeon.level.blobs.values()) {
            blob.emitter = null;
            this.addBlobSprite(blob);
        }
        this.fog = new FogOfWar(Dungeon.level.width(), Dungeon.level.height());
        this.add((Gizmo)this.fog);
        this.spells = new Group();
        this.add((Gizmo)this.spells);
        this.add((Gizmo)this.overFogEffects);
        this.statuses = new Group();
        this.add((Gizmo)this.statuses);
        this.add((Gizmo)this.healthIndicators);
        this.add((Gizmo)new TargetHealthIndicator());
        this.add((Gizmo)this.emoicons);
        cellSelector = new CellSelector(this.tiles);
        this.add((Gizmo)cellSelector);
        int uiSize = SPDSettings.interfaceSize();
        this.menu = new MenuPane();
        this.menu.camera = uiCamera;
        this.menu.setPos(GameScene.uiCamera.width - 32, uiSize > 0 ? 0.0f : 1.0f);
        this.add((Gizmo)this.menu);
        this.status = new StatusPane(SPDSettings.interfaceSize() > 0);
        this.status.camera = uiCamera;
        this.status.setRect(0.0f, uiSize > 0 ? (float)(GameScene.uiCamera.height - 39) : 0.0f, GameScene.uiCamera.width, 0.0f);
        this.add((Gizmo)this.status);
        this.boss = new BossHealthBar();
        this.boss.camera = uiCamera;
        this.boss.setPos(6.0f + ((float)GameScene.uiCamera.width - this.boss.width()) / 2.0f, 20.0f);
        this.add((Gizmo)this.boss);
        this.attack = new AttackIndicator();
        this.attack.camera = uiCamera;
        this.add((Gizmo)this.attack);
        this.loot = new LootIndicator();
        this.loot.camera = uiCamera;
        this.add((Gizmo)this.loot);
        this.action = new ActionIndicator();
        this.action.camera = uiCamera;
        this.add((Gizmo)this.action);
        this.resume = new ResumeIndicator();
        this.resume.camera = uiCamera;
        this.add((Gizmo)this.resume);
        this.log = new GameLog();
        this.log.camera = uiCamera;
        this.log.newLine();
        this.add((Gizmo)this.log);
        if (uiSize > 0) {
            this.bringToFront((Gizmo)this.status);
        }
        this.toolbar = new Toolbar();
        this.toolbar.camera = uiCamera;
        this.add((Gizmo)this.toolbar);
        if (uiSize == 2) {
            this.inventory = new InventoryPane();
            this.inventory.camera = uiCamera;
            this.inventory.setPos((float)GameScene.uiCamera.width - this.inventory.width(), (float)GameScene.uiCamera.height - this.inventory.height());
            this.add((Gizmo)this.inventory);
            this.toolbar.setRect(0.0f, (float)GameScene.uiCamera.height - this.toolbar.height() - this.inventory.height(), GameScene.uiCamera.width, this.toolbar.height());
        } else {
            this.toolbar.setRect(0.0f, (float)GameScene.uiCamera.height - this.toolbar.height(), GameScene.uiCamera.width, this.toolbar.height());
        }
        GameScene.layoutTags();
        switch (InterlevelScene.mode) {
            case RESURRECT: {
                Sample.INSTANCE.play((Object)"sounds/teleport.mp3");
                ScrollOfTeleportation.appear(Dungeon.hero, Dungeon.hero.pos);
                SpellSprite.show(Dungeon.hero, 5);
                new Flare(5, 16.0f).color(0xFFFF00, true).show((Visual)this.hero, 4.0f);
                break;
            }
            case RETURN: {
                ScrollOfTeleportation.appear(Dungeon.hero, Dungeon.hero.pos);
                break;
            }
            case DESCEND: 
            case FALL: {
                switch (Dungeon.depth) {
                    case 1: {
                        WndStory.showChapter(0);
                        break;
                    }
                    case 6: {
                        WndStory.showChapter(1);
                        break;
                    }
                    case 11: {
                        WndStory.showChapter(2);
                        break;
                    }
                    case 16: {
                        WndStory.showChapter(3);
                        break;
                    }
                    case 21: {
                        WndStory.showChapter(4);
                    }
                }
                if (!Dungeon.hero.isAlive()) break;
                Badges.validateNoKilling();
            }
        }
        ArrayList dropped = (ArrayList)Dungeon.droppedItems.get(Dungeon.depth);
        if (dropped != null) {
            for (Item item : dropped) {
                int pos = Dungeon.level.randomRespawnCell(null);
                if (item instanceof Potion) {
                    ((Potion)item).shatter(pos);
                    continue;
                }
                if (item instanceof Plant.Seed && !Dungeon.isChallenged(8)) {
                    Dungeon.level.plant((Plant.Seed)item, pos);
                    continue;
                }
                if (item instanceof Honeypot) {
                    Dungeon.level.drop(((Honeypot)item).shatter(null, pos), pos);
                    continue;
                }
                Dungeon.level.drop(item, pos);
            }
            Dungeon.droppedItems.remove(Dungeon.depth);
        }
        if ((ported = (ArrayList)Dungeon.portedItems.get(Dungeon.depth)) != null) {
            int pos;
            int tries = 100;
            do {
                pos = Dungeon.level.randomRespawnCell(null);
            } while (--tries > 0 && Dungeon.level.heaps.get(pos) != null);
            for (Item item : ported) {
                Dungeon.level.drop((Item)item, (int)pos).type = Heap.Type.CHEST;
            }
            ((Heap)Dungeon.level.heaps.get((int)pos)).type = Heap.Type.CHEST;
            ((Heap)Dungeon.level.heaps.get((int)pos)).sprite.link();
            Dungeon.portedItems.remove(Dungeon.depth);
        }
        Dungeon.hero.next();
        switch (InterlevelScene.mode) {
            case DESCEND: 
            case FALL: 
            case CONTINUE: {
                Camera.main.snapTo(this.hero.center().x, this.hero.center().y - 16.0f * ((float)defaultZoom / Camera.main.zoom));
                break;
            }
            case ASCEND: {
                Camera.main.snapTo(this.hero.center().x, this.hero.center().y + 16.0f * ((float)defaultZoom / Camera.main.zoom));
                break;
            }
            default: {
                Camera.main.snapTo(this.hero.center().x, this.hero.center().y);
            }
        }
        Camera.main.panTo(this.hero.center(), 2.5f);
        if (InterlevelScene.mode != InterlevelScene.Mode.NONE) {
            if (Dungeon.depth == Statistics.deepestFloor && (InterlevelScene.mode == InterlevelScene.Mode.DESCEND || InterlevelScene.mode == InterlevelScene.Mode.FALL)) {
                GLog.h(Messages.get((Object)this, "descend", new Object[0]), Dungeon.depth);
                Sample.INSTANCE.play((Object)"sounds/descend.mp3");
                for (Char ch : Actor.chars()) {
                    if (!(ch instanceof DriedRose.GhostHero)) continue;
                    ((DriedRose.GhostHero)ch).sayAppeared();
                }
                int spawnersAbove = Statistics.spawnersAlive;
                if (spawnersAbove > 0 && Dungeon.depth <= 25) {
                    for (Mob m : Dungeon.level.mobs) {
                        if (!(m instanceof DemonSpawner) || !((DemonSpawner)m).spawnRecorded) continue;
                        --spawnersAbove;
                    }
                    if (spawnersAbove > 0) {
                        if (Dungeon.bossLevel()) {
                            GLog.n(Messages.get((Object)this, "spawner_warn_final", new Object[0]), new Object[0]);
                        } else {
                            GLog.n(Messages.get((Object)this, "spawner_warn", new Object[0]), new Object[0]);
                        }
                    }
                }
            } else if (InterlevelScene.mode == InterlevelScene.Mode.RESET) {
                GLog.h(Messages.get((Object)this, "warp", new Object[0]), new Object[0]);
            } else if (InterlevelScene.mode == InterlevelScene.Mode.RESURRECT) {
                GLog.h(Messages.get((Object)this, "resurrect", new Object[0]), Dungeon.depth);
            } else {
                GLog.h(Messages.get((Object)this, "return", new Object[0]), Dungeon.depth);
            }
            if (Dungeon.hero.hasTalent(Talent.ROGUES_FORESIGHT) && Dungeon.level instanceof RegularLevel) {
                int reqSecrets = Dungeon.level.feeling == Level.Feeling.SECRETS ? 2 : 1;
                for (Room r : ((RegularLevel)Dungeon.level).rooms()) {
                    if (!(r instanceof SecretRoom)) continue;
                    --reqSecrets;
                }
                Random.pushGenerator((long)Dungeon.seedCurDepth());
                if (reqSecrets <= 0 && Random.Int((int)4) <= Dungeon.hero.pointsInTalent(Talent.ROGUES_FORESIGHT)) {
                    GLog.p(Messages.get((Object)this, "secret_hint", new Object[0]), new Object[0]);
                }
                Random.popGenerator();
            }
            boolean unspentTalents = false;
            for (int i = 1; i <= Dungeon.hero.talents.size(); ++i) {
                if (Dungeon.hero.talentPointsAvailable(i) <= 0) continue;
                unspentTalents = true;
                break;
            }
            if (unspentTalents) {
                GLog.newLine();
                GLog.w(Messages.get(Dungeon.hero, "unspent", new Object[0]), new Object[0]);
                StatusPane.talentBlink = 10.0f;
                WndHero.lastIdx = 1;
            }
            switch (Dungeon.level.feeling) {
                case CHASM: {
                    GLog.w(Messages.get((Object)this, "chasm", new Object[0]), new Object[0]);
                    break;
                }
                case WATER: {
                    GLog.w(Messages.get((Object)this, "water", new Object[0]), new Object[0]);
                    break;
                }
                case GRASS: {
                    GLog.w(Messages.get((Object)this, "grass", new Object[0]), new Object[0]);
                    break;
                }
                case DARK: {
                    GLog.w(Messages.get((Object)this, "dark", new Object[0]), new Object[0]);
                    break;
                }
                case LARGE: {
                    GLog.w(Messages.get((Object)this, "large", new Object[0]), new Object[0]);
                    break;
                }
                case TRAPS: {
                    GLog.w(Messages.get((Object)this, "traps", new Object[0]), new Object[0]);
                    break;
                }
                case SECRETS: {
                    GLog.w(Messages.get((Object)this, "secrets", new Object[0]), new Object[0]);
                }
            }
            for (Mob mob : Dungeon.level.mobs) {
                if (mob.buffs(ChampionEnemy.class).isEmpty()) continue;
                GLog.w(Messages.get(ChampionEnemy.class, "warn", new Object[0]), new Object[0]);
            }
            InterlevelScene.mode = InterlevelScene.Mode.NONE;
        }
        if (Rankings.INSTANCE.totalNumber > 0 && !Document.ADVENTURERS_GUIDE.isPageRead("Dieing")) {
            GLog.p(Messages.get(Guidebook.class, "hint", new Object[0]), new Object[0]);
            GameScene.flashForDocument("Dieing");
        }
        if (!invVisible) {
            GameScene.toggleInvPane();
        }
        this.fadeIn();
        if (!Dungeon.hero.isAlive()) {
            Ankh ankh = null;
            for (Ankh i : Dungeon.hero.belongings.getAllItems(Ankh.class)) {
                if (i.isBlessed()) continue;
                ankh = i;
            }
            if (ankh != null) {
                this.add((Gizmo)new WndResurrect(ankh));
            }
        }
    }

    @Override
    public void destroy() {
        if (!this.waitForActorThread(4500, true)) {
            Throwable t = new Throwable();
            t.setStackTrace(actorThread.getStackTrace());
            throw new RuntimeException("timeout waiting for actor thread! ", t);
        }
        Emitter.freezeEmitters = false;
        scene = null;
        Badges.saveGlobal();
        Journal.saveGlobal();
        super.destroy();
    }

    public static void endActorThread() {
        if (actorThread != null && actorThread.isAlive()) {
            Actor.keepActorThreadAlive = false;
            actorThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForActorThread(int msToWait, boolean interrupt) {
        if (actorThread == null || !actorThread.isAlive()) {
            return true;
        }
        Thread thread = actorThread;
        synchronized (thread) {
            if (interrupt) {
                actorThread.interrupt();
            }
            try {
                actorThread.wait(msToWait);
            }
            catch (InterruptedException e) {
                ShatteredPixelDungeon.reportException((Throwable)e);
            }
            return !Actor.processing();
        }
    }

    public synchronized void onPause() {
        try {
            Dungeon.saveAll();
            Badges.saveGlobal();
            Journal.saveGlobal();
        }
        catch (IOException e) {
            ShatteredPixelDungeon.reportException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void update() {
        lastOffset = null;
        if (updateItemDisplays) {
            updateItemDisplays = false;
            QuickSlotButton.refresh();
            InventoryPane.refresh();
        }
        if (Dungeon.hero == null || scene == null) {
            return;
        }
        super.update();
        if (this.notifyDelay > 0.0f) {
            this.notifyDelay -= Game.elapsed;
        }
        if (!Emitter.freezeEmitters) {
            this.water.offset(0.0f, -5.0f * Game.elapsed);
        }
        if (!Actor.processing() && Dungeon.hero.isAlive()) {
            if (actorThread == null || !actorThread.isAlive()) {
                actorThread = new Thread(){

                    @Override
                    public void run() {
                        Actor.process();
                    }
                };
                if (Runtime.getRuntime().availableProcessors() == 1) {
                    actorThread.setPriority(4);
                }
                actorThread.setName("SHPD Actor Thread");
                Thread.currentThread().setName("SHPD Render Thread");
                Actor.keepActorThreadAlive = true;
                actorThread.start();
            } else if (this.notifyDelay <= 0.0f) {
                this.notifyDelay += 0.016666668f;
                Thread thread = actorThread;
                synchronized (thread) {
                    actorThread.notify();
                }
            }
        }
        if (Dungeon.hero.ready && Dungeon.hero.paralysed == 0) {
            this.log.newLine();
        }
        if (this.tagAttack != this.attack.active || this.tagLoot != this.loot.visible || this.tagAction != this.action.visible || this.tagResume != this.resume.visible) {
            boolean tagAppearing = this.attack.active && !this.tagAttack || this.loot.visible && !this.tagLoot || this.action.visible && !this.tagAction || this.resume.visible && !this.tagResume;
            this.tagAttack = this.attack.active;
            this.tagLoot = this.loot.visible;
            this.tagAction = this.action.visible;
            this.tagResume = this.resume.visible;
            if (tagAppearing) {
                GameScene.layoutTags();
            }
        }
        cellSelector.enable(Dungeon.hero.ready);
        for (Gizmo g : this.toDestroy) {
            g.destroy();
        }
        this.toDestroy.clear();
    }

    public synchronized Gizmo erase(Gizmo g) {
        Gizmo result = super.erase(g);
        if (result instanceof Window) {
            lastOffset = ((Window)result).getOffset();
        }
        return result;
    }

    public static void layoutTags() {
        float y;
        if (scene == null) {
            return;
        }
        if (GameScene.scene.inventory != null && GameScene.scene.inventory.visible && GameScene.uiCamera.width < 460 && GameScene.uiCamera.height < 300) {
            Camera.main.setCenterOffset(0.0f, (float)Math.min(300 - GameScene.uiCamera.height, 460 - GameScene.uiCamera.width) / Camera.main.zoom);
        } else {
            Camera.main.setCenterOffset(0.0f, 0.0f);
        }
        RectF insets = DeviceCompat.getSafeInsets();
        insets = insets.scale(1.0f / GameScene.uiCamera.zoom);
        boolean tagsOnLeft = SPDSettings.flipTags();
        float tagWidth = (float)Tag.SIZE + (tagsOnLeft ? insets.left : insets.right);
        float tagLeft = tagsOnLeft ? 0.0f : (float)GameScene.uiCamera.width - tagWidth;
        float f = y = SPDSettings.interfaceSize() == 0 ? GameScene.scene.toolbar.top() - 2.0f : GameScene.scene.status.top() - 2.0f;
        if (tagsOnLeft) {
            GameScene.scene.log.setRect(tagWidth, y, (float)GameScene.uiCamera.width - tagWidth - insets.right, 0.0f);
        } else {
            GameScene.scene.log.setRect(insets.left, y, (float)GameScene.uiCamera.width - tagWidth - insets.left, 0.0f);
        }
        float pos = GameScene.scene.toolbar.top();
        if (tagsOnLeft && SPDSettings.interfaceSize() > 0) {
            pos = GameScene.scene.status.top();
        }
        if (GameScene.scene.tagAttack) {
            GameScene.scene.attack.setRect(tagLeft, pos - (float)Tag.SIZE, tagWidth, Tag.SIZE);
            GameScene.scene.attack.flip(tagsOnLeft);
            pos = GameScene.scene.attack.top();
        }
        if (GameScene.scene.tagLoot) {
            GameScene.scene.loot.setRect(tagLeft, pos - (float)Tag.SIZE, tagWidth, Tag.SIZE);
            GameScene.scene.loot.flip(tagsOnLeft);
            pos = GameScene.scene.loot.top();
        }
        if (GameScene.scene.tagAction) {
            GameScene.scene.action.setRect(tagLeft, pos - (float)Tag.SIZE, tagWidth, Tag.SIZE);
            GameScene.scene.action.flip(tagsOnLeft);
            pos = GameScene.scene.action.top();
        }
        if (GameScene.scene.tagResume) {
            GameScene.scene.resume.setRect(tagLeft, pos - (float)Tag.SIZE, tagWidth, Tag.SIZE);
            GameScene.scene.resume.flip(tagsOnLeft);
        }
    }

    protected void onBackPressed() {
        if (!GameScene.cancel()) {
            this.add((Gizmo)new WndGame());
        }
    }

    public void addCustomTile(CustomTilemap visual) {
        this.customTiles.add((Gizmo)visual.create());
    }

    public void addCustomWall(CustomTilemap visual) {
        this.customWalls.add((Gizmo)visual.create());
    }

    private void addHeapSprite(Heap heap) {
        ItemSprite sprite = heap.sprite = (ItemSprite)this.heaps.recycle(ItemSprite.class);
        sprite.revive();
        sprite.link(heap);
        this.heaps.add((Gizmo)sprite);
    }

    private void addDiscardedSprite(Heap heap) {
        heap.sprite = (DiscardedItemSprite)this.heaps.recycle(DiscardedItemSprite.class);
        heap.sprite.revive();
        heap.sprite.link(heap);
        this.heaps.add((Gizmo)heap.sprite);
    }

    private void addPlantSprite(Plant plant) {
    }

    private void addTrapSprite(Trap trap) {
    }

    private void addBlobSprite(Blob gas) {
        if (gas.emitter == null) {
            this.gases.add((Gizmo)new BlobEmitter(gas));
        }
    }

    private void addMobSprite(Mob mob) {
        CharSprite sprite = mob.sprite();
        sprite.visible = Dungeon.level.heroFOV[mob.pos];
        this.mobs.add((Gizmo)sprite);
        sprite.link(mob);
    }

    private synchronized void prompt(String text) {
        if (this.prompt != null) {
            this.prompt.killAndErase();
            this.toDestroy.add((Gizmo)this.prompt);
            this.prompt = null;
        }
        if (text != null) {
            this.prompt = new Toast(text){

                @Override
                protected void onClose() {
                    GameScene.cancel();
                }
            };
            this.prompt.camera = uiCamera;
            this.prompt.setPos(((float)GameScene.uiCamera.width - this.prompt.width()) / 2.0f, GameScene.uiCamera.height - 60);
            this.add((Gizmo)this.prompt);
        }
    }

    private void showBanner(Banner banner) {
        banner.camera = uiCamera;
        banner.x = GameScene.align(uiCamera, ((float)GameScene.uiCamera.width - banner.width) / 2.0f);
        banner.y = GameScene.align(uiCamera, ((float)GameScene.uiCamera.height - banner.height) / 3.0f);
        this.addToFront((Gizmo)banner);
    }

    public static void add(Plant plant) {
        if (scene != null) {
            scene.addPlantSprite(plant);
        }
    }

    public static void add(Trap trap) {
        if (scene != null) {
            scene.addTrapSprite(trap);
        }
    }

    public static void add(Blob gas) {
        Actor.add(gas);
        if (scene != null) {
            scene.addBlobSprite(gas);
        }
    }

    public static void add(Heap heap) {
        if (scene != null) {
            scene.addHeapSprite(heap);
        }
    }

    public static void discard(Heap heap) {
        if (scene != null) {
            scene.addDiscardedSprite(heap);
        }
    }

    public static void add(Mob mob) {
        Dungeon.level.mobs.add(mob);
        scene.addMobSprite(mob);
        Actor.add(mob);
    }

    public static void addSprite(Mob mob) {
        scene.addMobSprite(mob);
    }

    public static void add(Mob mob, float delay) {
        Dungeon.level.mobs.add(mob);
        scene.addMobSprite(mob);
        Actor.addDelayed(mob, delay);
    }

    public static void add(EmoIcon icon) {
        GameScene.scene.emoicons.add((Gizmo)icon);
    }

    public static void add(CharHealthIndicator indicator) {
        if (scene != null) {
            GameScene.scene.healthIndicators.add((Gizmo)indicator);
        }
    }

    public static void add(CustomTilemap t, boolean wall) {
        if (scene == null) {
            return;
        }
        if (wall) {
            scene.addCustomWall(t);
        } else {
            scene.addCustomTile(t);
        }
    }

    public static void effect(Visual effect) {
        if (scene != null) {
            GameScene.scene.effects.add((Gizmo)effect);
        }
    }

    public static void effectOverFog(Visual effect) {
        GameScene.scene.overFogEffects.add((Gizmo)effect);
    }

    public static Ripple ripple(int pos) {
        if (scene != null) {
            Ripple ripple = (Ripple)GameScene.scene.ripples.recycle(Ripple.class);
            ripple.reset(pos);
            return ripple;
        }
        return null;
    }

    public static SpellSprite spellSprite() {
        return (SpellSprite)GameScene.scene.spells.recycle(SpellSprite.class);
    }

    public static Emitter emitter() {
        if (scene != null) {
            Emitter emitter = (Emitter)GameScene.scene.emitters.recycle(Emitter.class);
            emitter.revive();
            return emitter;
        }
        return null;
    }

    public static Emitter floorEmitter() {
        if (scene != null) {
            Emitter emitter = (Emitter)GameScene.scene.floorEmitters.recycle(Emitter.class);
            emitter.revive();
            return emitter;
        }
        return null;
    }

    public static FloatingText status() {
        return scene != null ? (FloatingText)GameScene.scene.statuses.recycle(FloatingText.class) : null;
    }

    public static void pickUp(Item item, int pos) {
        if (scene != null) {
            GameScene.scene.toolbar.pickup(item, pos);
        }
    }

    public static void pickUpJournal(Item item, int pos) {
        if (scene != null) {
            GameScene.scene.menu.pickup(item, pos);
        }
    }

    public static void flashForDocument(String page) {
        if (scene != null) {
            GameScene.scene.menu.flashForPage(page);
        }
    }

    public static void updateKeyDisplay() {
        if (scene != null) {
            GameScene.scene.menu.updateKeys();
        }
    }

    public static void showlevelUpStars() {
        if (scene != null) {
            GameScene.scene.status.showStarParticles();
        }
    }

    public static void resetMap() {
        if (scene != null) {
            GameScene.scene.tiles.map(Dungeon.level.map, Dungeon.level.width());
            GameScene.scene.visualGrid.map(Dungeon.level.map, Dungeon.level.width());
            GameScene.scene.terrainFeatures.map(Dungeon.level.map, Dungeon.level.width());
            GameScene.scene.raisedTerrain.map(Dungeon.level.map, Dungeon.level.width());
            GameScene.scene.walls.map(Dungeon.level.map, Dungeon.level.width());
        }
        GameScene.updateFog();
    }

    public static void updateMap() {
        if (scene != null) {
            GameScene.scene.tiles.updateMap();
            GameScene.scene.visualGrid.updateMap();
            GameScene.scene.terrainFeatures.updateMap();
            GameScene.scene.raisedTerrain.updateMap();
            GameScene.scene.walls.updateMap();
            GameScene.updateFog();
        }
    }

    public static void updateMap(int cell) {
        if (scene != null) {
            GameScene.scene.tiles.updateMapCell(cell);
            GameScene.scene.visualGrid.updateMapCell(cell);
            GameScene.scene.terrainFeatures.updateMapCell(cell);
            GameScene.scene.raisedTerrain.updateMapCell(cell);
            GameScene.scene.walls.updateMapCell(cell);
            GameScene.updateFog(cell, 1);
        }
    }

    public static void plantSeed(int cell) {
        if (scene != null) {
            GameScene.scene.terrainFeatures.growPlant(cell);
        }
    }

    public static void discoverTile(int pos, int oldValue) {
        if (scene != null) {
            GameScene.scene.tiles.discover(pos, oldValue);
        }
    }

    public static void show(Window wnd) {
        if (scene != null) {
            GameScene.cancelCellSelector();
            if (GameScene.scene.inventory != null && GameScene.scene.inventory.visible) {
                Point offsetToInherit = null;
                for (Gizmo g : GameScene.scene.members) {
                    if (!(g instanceof Window)) continue;
                    offsetToInherit = ((Window)g).getOffset();
                }
                if (lastOffset != null && offsetToInherit == null) {
                    offsetToInherit = lastOffset;
                }
                if (offsetToInherit != null) {
                    wnd.offset(offsetToInherit);
                    wnd.boundOffsetWithMargin(3);
                }
            }
            scene.addToFront((Gizmo)wnd);
        }
    }

    public static boolean showingWindow() {
        if (scene == null) {
            return false;
        }
        for (Gizmo g : GameScene.scene.members) {
            if (!(g instanceof Window)) continue;
            return true;
        }
        return false;
    }

    public static boolean interfaceBlockingHero() {
        if (scene == null) {
            return false;
        }
        if (GameScene.showingWindow()) {
            return true;
        }
        return GameScene.scene.inventory != null && GameScene.scene.inventory.isSelecting();
    }

    public static void toggleInvPane() {
        if (scene != null && GameScene.scene.inventory != null) {
            if (GameScene.scene.inventory.visible) {
                invVisible = false;
                GameScene.scene.inventory.active = false;
                GameScene.scene.inventory.visible = false;
                GameScene.scene.toolbar.setPos(GameScene.scene.toolbar.left(), (float)GameScene.uiCamera.height - GameScene.scene.toolbar.height());
            } else {
                invVisible = true;
                GameScene.scene.inventory.active = true;
                GameScene.scene.inventory.visible = true;
                GameScene.scene.toolbar.setPos(GameScene.scene.toolbar.left(), GameScene.scene.inventory.top() - GameScene.scene.toolbar.height());
            }
            GameScene.layoutTags();
        }
    }

    public static void centerNextWndOnInvPane() {
        if (scene != null && GameScene.scene.inventory != null && GameScene.scene.inventory.visible) {
            lastOffset = new Point((int)GameScene.scene.inventory.centerX() - GameScene.uiCamera.width / 2, (int)GameScene.scene.inventory.centerY() - GameScene.uiCamera.height / 2);
        }
    }

    public static void updateFog() {
        if (scene != null) {
            GameScene.scene.fog.updateFog();
            GameScene.scene.wallBlocking.updateMap();
        }
    }

    public static void updateFog(int x, int y, int w, int h) {
        if (scene != null) {
            GameScene.scene.fog.updateFogArea(x, y, w, h);
            GameScene.scene.wallBlocking.updateArea(x, y, w, h);
        }
    }

    public static void updateFog(int cell, int radius) {
        if (scene != null) {
            GameScene.scene.fog.updateFog(cell, radius);
            GameScene.scene.wallBlocking.updateArea(cell, radius);
        }
    }

    public static void afterObserve() {
        if (scene != null) {
            for (Mob mob : Dungeon.level.mobs) {
                if (mob.sprite == null) continue;
                mob.sprite.visible = Dungeon.level.heroFOV[mob.pos];
            }
        }
    }

    public static void flash(int color) {
        GameScene.flash(color, true);
    }

    public static void flash(int color, boolean lightmode) {
        if (color > 0 && color < 0x1000000) {
            scene.fadeIn(0xFF000000 | color, lightmode);
        } else {
            scene.fadeIn(color, lightmode);
        }
    }

    public static void gameOver() {
        Banner gameOver = new Banner(BannerSprites.get(BannerSprites.Type.GAME_OVER));
        gameOver.show(0, 1.0f);
        scene.showBanner(gameOver);
        Sample.INSTANCE.play((Object)"sounds/death.mp3");
    }

    public static void bossSlain() {
        if (Dungeon.hero.isAlive()) {
            Banner bossSlain = new Banner(BannerSprites.get(BannerSprites.Type.BOSS_SLAIN));
            bossSlain.show(0xFFFFFF, 0.3f, 5.0f);
            scene.showBanner(bossSlain);
            Sample.INSTANCE.play((Object)"sounds/boss.mp3");
        }
    }

    public static void handleCell(int cell) {
        cellSelector.select(cell, 0);
    }

    public static void selectCell(CellSelector.Listener listener) {
        if (GameScene.cellSelector.listener != null && GameScene.cellSelector.listener != defaultCellListener) {
            GameScene.cellSelector.listener.onSelect(null);
        }
        GameScene.cellSelector.listener = listener;
        GameScene.cellSelector.enabled = Dungeon.hero.ready;
        if (scene != null) {
            scene.prompt(listener.prompt());
        }
    }

    private static boolean cancelCellSelector() {
        cellSelector.resetKeyHold();
        if (GameScene.cellSelector.listener != null && GameScene.cellSelector.listener != defaultCellListener) {
            cellSelector.cancel();
            return true;
        }
        return false;
    }

    public static WndBag selectItem(WndBag.ItemSelector listener) {
        GameScene.cancelCellSelector();
        if (scene != null) {
            if (GameScene.scene.inventory != null && GameScene.scene.inventory.visible && !GameScene.showingWindow()) {
                GameScene.scene.inventory.setSelector(listener);
                return null;
            }
            WndBag wnd = WndBag.getBag(listener);
            GameScene.show(wnd);
            return wnd;
        }
        return null;
    }

    public static boolean cancel() {
        if (Dungeon.hero != null && (Dungeon.hero.curAction != null || Dungeon.hero.resting)) {
            Dungeon.hero.curAction = null;
            Dungeon.hero.resting = false;
            return true;
        }
        return GameScene.cancelCellSelector();
    }

    public static void ready() {
        GameScene.selectCell(defaultCellListener);
        QuickSlotButton.cancel();
        InventoryPane.cancelTargeting();
        if (scene != null && GameScene.scene.toolbar != null) {
            GameScene.scene.toolbar.examining = false;
        }
    }

    public static void checkKeyHold() {
        cellSelector.processKeyHold();
    }

    public static void resetKeyHold() {
        cellSelector.resetKeyHold();
    }

    public static void examineCell(Integer cell) {
        if (cell == null || cell < 0 || cell > Dungeon.level.length() || !Dungeon.level.visited[cell] && !Dungeon.level.mapped[cell]) {
            return;
        }
        final ArrayList<Object> objects = GameScene.getObjectsAtCell(cell);
        if (objects.isEmpty()) {
            GameScene.show(new WndInfoCell(cell));
        } else if (objects.size() == 1) {
            GameScene.examineObject(objects.get(0));
        } else {
            String[] names = GameScene.getObjectNames(objects).toArray(new String[0]);
            GameScene.show(new WndOptions(Icons.get(Icons.INFO), Messages.get(GameScene.class, "choose_examine", new Object[0]), Messages.get(GameScene.class, "multiple_examine", new Object[0]), names){

                @Override
                protected void onSelect(int index) {
                    GameScene.examineObject(objects.get(index));
                }
            });
        }
    }

    private static ArrayList<Object> getObjectsAtCell(int cell) {
        Trap trap;
        Plant plant;
        Mob mob;
        ArrayList<Object> objects = new ArrayList<Object>();
        if (cell == Dungeon.hero.pos) {
            objects.add(Dungeon.hero);
        } else if (Dungeon.level.heroFOV[cell] && (mob = (Mob)Actor.findChar(cell)) != null) {
            objects.add(mob);
        }
        Heap heap = (Heap)Dungeon.level.heaps.get(cell);
        if (heap != null && heap.seen) {
            objects.add(heap);
        }
        if ((plant = (Plant)Dungeon.level.plants.get(cell)) != null) {
            objects.add(plant);
        }
        if ((trap = (Trap)Dungeon.level.traps.get(cell)) != null && trap.visible) {
            objects.add(trap);
        }
        return objects;
    }

    private static ArrayList<String> getObjectNames(ArrayList<Object> objects) {
        ArrayList<String> names = new ArrayList<String>();
        for (Object obj : objects) {
            if (obj instanceof Hero) {
                names.add(((Hero)obj).className().toUpperCase(Locale.ENGLISH));
                continue;
            }
            if (obj instanceof Mob) {
                names.add(Messages.titleCase(((Mob)obj).name()));
                continue;
            }
            if (obj instanceof Heap) {
                names.add(Messages.titleCase(((Heap)obj).toString()));
                continue;
            }
            if (obj instanceof Plant) {
                names.add(Messages.titleCase(((Plant)obj).name()));
                continue;
            }
            if (!(obj instanceof Trap)) continue;
            names.add(Messages.titleCase(((Trap)obj).name()));
        }
        return names;
    }

    public static void examineObject(Object o) {
        if (o == Dungeon.hero) {
            GameScene.show(new WndHero());
        } else if (o instanceof Mob) {
            GameScene.show(new WndInfoMob((Mob)o));
            if (o instanceof Snake && !Document.ADVENTURERS_GUIDE.isPageRead("Surprise_Attacks")) {
                GLog.p(Messages.get(Guidebook.class, "hint", new Object[0]), new Object[0]);
                GameScene.flashForDocument("Surprise_Attacks");
            }
        } else if (o instanceof Heap) {
            GameScene.show(new WndInfoItem((Heap)o));
        } else if (o instanceof Plant) {
            GameScene.show(new WndInfoPlant((Plant)o));
        } else if (o instanceof Trap) {
            GameScene.show(new WndInfoTrap((Trap)o));
        } else {
            GameScene.show(new WndMessage(Messages.get(GameScene.class, "dont_know", new Object[0])));
        }
    }

    static {
        invVisible = true;
        updateItemDisplays = false;
        lastOffset = null;
        defaultCellListener = new CellSelector.Listener(){

            @Override
            public void onSelect(Integer cell) {
                if (Dungeon.hero.handle(cell)) {
                    Dungeon.hero.next();
                }
            }

            @Override
            public void onRightClick(final Integer cell) {
                if (cell == null || cell < 0 || cell > Dungeon.level.length() || !Dungeon.level.visited[cell] && !Dungeon.level.mapped[cell]) {
                    return;
                }
                final ArrayList objects = GameScene.getObjectsAtCell(cell);
                ArrayList textLines = GameScene.getObjectNames(objects);
                String title = null;
                Object image = null;
                if (objects.isEmpty()) {
                    title = WndInfoCell.cellName(cell);
                    image = WndInfoCell.cellImage(cell);
                } else if (objects.size() > 1) {
                    title = Messages.get(GameScene.class, "multiple", new Object[0]);
                    image = Icons.get(Icons.INFO);
                } else if (objects.get(0) instanceof Hero) {
                    title = (String)textLines.remove(0);
                    image = new Image((Image)((Hero)objects.get((int)0)).sprite);
                } else if (objects.get(0) instanceof Mob) {
                    title = (String)textLines.remove(0);
                    image = new Image((Image)((Mob)objects.get((int)0)).sprite);
                } else if (objects.get(0) instanceof Heap) {
                    title = (String)textLines.remove(0);
                    image = new ItemSprite((Heap)objects.get(0));
                } else if (objects.get(0) instanceof Plant) {
                    title = (String)textLines.remove(0);
                    image = TerrainFeaturesTilemap.tile(cell, Dungeon.level.map[cell]);
                } else if (objects.get(0) instanceof Trap) {
                    title = (String)textLines.remove(0);
                    image = TerrainFeaturesTilemap.tile(cell, Dungeon.level.map[cell]);
                }
                if (objects.isEmpty()) {
                    textLines.add(0, Messages.get(GameScene.class, "go_here", new Object[0]));
                } else if (objects.get(0) instanceof Hero) {
                    textLines.add(0, Messages.get(GameScene.class, "go_here", new Object[0]));
                } else if (objects.get(0) instanceof Mob) {
                    if (((Mob)objects.get((int)0)).alignment != Char.Alignment.ENEMY) {
                        textLines.add(0, Messages.get(GameScene.class, "interact", new Object[0]));
                    } else {
                        textLines.add(0, Messages.get(GameScene.class, "attack", new Object[0]));
                    }
                } else if (objects.get(0) instanceof Heap) {
                    switch (((Heap)objects.get((int)0)).type) {
                        case HEAP: {
                            textLines.add(0, Messages.get(GameScene.class, "pick_up", new Object[0]));
                            break;
                        }
                        case FOR_SALE: {
                            textLines.add(0, Messages.get(GameScene.class, "purchase", new Object[0]));
                            break;
                        }
                        default: {
                            textLines.add(0, Messages.get(GameScene.class, "interact", new Object[0]));
                            break;
                        }
                    }
                } else if (objects.get(0) instanceof Plant) {
                    textLines.add(0, Messages.get(GameScene.class, "trample", new Object[0]));
                } else if (objects.get(0) instanceof Trap) {
                    textLines.add(0, Messages.get(GameScene.class, "interact", new Object[0]));
                }
                if (objects.size() > 1) {
                    textLines.add(0, "_" + (String)textLines.remove(0) + ":_ " + (String)textLines.get(0));
                    for (int i = 1; i < textLines.size(); ++i) {
                        textLines.add(i, "_" + Messages.get(GameScene.class, "examine", new Object[0]) + ":_ " + (String)textLines.remove(i));
                    }
                } else {
                    textLines.add(0, "_" + (String)textLines.remove(0) + "_");
                    textLines.add(1, "_" + Messages.get(GameScene.class, "examine", new Object[0]) + "_");
                }
                RightClickMenu menu = new RightClickMenu((Image)image, title, textLines.toArray(new String[0])){

                    @Override
                    public void onSelect(int index) {
                        if (index == 0) {
                            GameScene.handleCell(cell);
                        } else if (objects.size() == 0) {
                            GameScene.show(new WndInfoCell(cell));
                        } else {
                            GameScene.examineObject(objects.get(index - 1));
                        }
                    }
                };
                scene.addToFront((Gizmo)menu);
                menu.camera = PixelScene.uiCamera;
                PointF mousePos = PointerEvent.currentHoverPos();
                mousePos = menu.camera.screenToCamera((int)mousePos.x, (int)mousePos.y);
                menu.setPos(mousePos.x - 3.0f, mousePos.y - 3.0f);
            }

            @Override
            public String prompt() {
                return null;
            }
        };
    }
}

