/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.scenes;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.effects.BadgeBanner;
import com.shatteredpixel.shatteredpixeldungeon.messages.Languages;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.InterlevelScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.ui.Tooltip;
import com.shatteredpixel.shatteredpixeldungeon.ui.Window;
import com.watabou.gltextures.SmartTexture;
import com.watabou.gltextures.TextureCache;
import com.watabou.glwrap.Blending;
import com.watabou.input.ControllerHandler;
import com.watabou.input.PointerEvent;
import com.watabou.noosa.BitmapText;
import com.watabou.noosa.Camera;
import com.watabou.noosa.ColorBlock;
import com.watabou.noosa.Game;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.Image;
import com.watabou.noosa.Scene;
import com.watabou.noosa.Visual;
import com.watabou.noosa.ui.Component;
import com.watabou.noosa.ui.Cursor;
import com.watabou.utils.GameMath;
import com.watabou.utils.PointF;
import com.watabou.utils.Reflection;
import java.util.ArrayList;

public class PixelScene
extends Scene {
    public static final float MIN_WIDTH_P = 135.0f;
    public static final float MIN_HEIGHT_P = 225.0f;
    public static final float MIN_WIDTH_L = 240.0f;
    public static final float MIN_HEIGHT_L = 160.0f;
    public static final float MIN_WIDTH_FULL = 360.0f;
    public static final float MIN_HEIGHT_FULL = 200.0f;
    public static int defaultZoom = 0;
    public static int maxDefaultZoom = 0;
    public static int maxScreenZoom = 0;
    public static float minZoom;
    public static float maxZoom;
    public static Camera uiCamera;
    public static BitmapText.Font pixelFont;
    protected boolean inGameScene = false;
    private static PointF virtualCursorPos;
    private Image cursor = null;
    private static ArrayList<Class<? extends Window>> savedWindows;
    private static Class<? extends PixelScene> savedClass;
    public static boolean noFade;

    public void create() {
        float scaleFactor;
        float minHeight;
        float minWidth;
        super.create();
        GameScene.scene = null;
        if (!this.inGameScene && InterlevelScene.lastRegion != -1) {
            InterlevelScene.lastRegion = -1;
            TextureCache.clear();
        }
        if (SPDSettings.interfaceSize() > 0) {
            minWidth = 360.0f;
            minHeight = 200.0f;
            scaleFactor = 3.75f;
        } else if (PixelScene.landscape()) {
            minWidth = 240.0f;
            minHeight = 160.0f;
            scaleFactor = 2.5f;
        } else {
            minWidth = 135.0f;
            minHeight = 225.0f;
            scaleFactor = 2.5f;
        }
        maxDefaultZoom = (int)Math.min((float)Game.width / minWidth, (float)Game.height / minHeight);
        maxScreenZoom = (int)Math.min((float)Game.dispWidth / minWidth, (float)Game.dispHeight / minHeight);
        defaultZoom = SPDSettings.scale();
        if ((double)defaultZoom < Math.ceil(Game.density * 2.0f) || defaultZoom > maxDefaultZoom) {
            defaultZoom = (int)GameMath.gate((float)2.0f, (float)((int)Math.ceil(Game.density * scaleFactor)), (float)maxDefaultZoom);
            if (SPDSettings.interfaceSize() > 0 && defaultZoom < (maxDefaultZoom + 1) / 2) {
                defaultZoom = (maxDefaultZoom + 1) / 2;
            }
        }
        minZoom = 1.0f;
        maxZoom = defaultZoom * 2;
        Camera.reset((Camera)new PixelCamera(defaultZoom));
        float uiZoom = defaultZoom;
        uiCamera = Camera.createFullscreen((float)uiZoom);
        Camera.add((Camera)uiCamera);
        pixelFont = BitmapText.Font.colorMarked((SmartTexture)TextureCache.get((Object)"fonts/pixel_font.png"), (int)0, (String)" !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u007f");
        PixelScene.pixelFont.baseLine = 6.0f;
        PixelScene.pixelFont.tracking = -1.0f;
        int renderedTextPageSize = defaultZoom <= 3 ? 256 : (defaultZoom <= 8 ? 512 : 1024);
        if (Messages.lang() == Languages.KOREAN || Messages.lang() == Languages.CHINESE || Messages.lang() == Languages.JAPANESE) {
            renderedTextPageSize *= 2;
        }
        Game.platform.setupFontGenerators(renderedTextPageSize, SPDSettings.systemFont());
        Tooltip.resetLastUsedTime();
        Cursor.setCustomCursor((Cursor.Type)Cursor.Type.DEFAULT, (int)defaultZoom);
    }

    public void update() {
        super.update();
        if (Math.abs(ControllerHandler.rightStickPosition.x) >= 0.2f || Math.abs(ControllerHandler.rightStickPosition.y) >= 0.2f) {
            if (!ControllerHandler.controllerPointerActive()) {
                ControllerHandler.setControllerPointer((boolean)true);
                virtualCursorPos = PointerEvent.currentHoverPos();
            }
            PixelScene.virtualCursorPos.x += (float)(defaultZoom * 500) * Game.elapsed * ControllerHandler.rightStickPosition.x;
            PixelScene.virtualCursorPos.y += (float)(defaultZoom * 500) * Game.elapsed * ControllerHandler.rightStickPosition.y;
            PixelScene.virtualCursorPos.x = GameMath.gate((float)0.0f, (float)PixelScene.virtualCursorPos.x, (float)Game.width);
            PixelScene.virtualCursorPos.y = GameMath.gate((float)0.0f, (float)PixelScene.virtualCursorPos.y, (float)Game.height);
            PointerEvent.addPointerEvent((PointerEvent)new PointerEvent((int)PixelScene.virtualCursorPos.x, (int)PixelScene.virtualCursorPos.y, 10000, PointerEvent.Type.HOVER, -1));
        }
    }

    public synchronized void draw() {
        super.draw();
        if (ControllerHandler.controllerPointerActive()) {
            if (this.cursor == null) {
                this.cursor = new Image((Object)Cursor.Type.CONTROLLER.file);
            }
            this.cursor.x = PixelScene.virtualCursorPos.x / (float)defaultZoom - this.cursor.width() / 2.0f;
            this.cursor.y = PixelScene.virtualCursorPos.y / (float)defaultZoom - this.cursor.height() / 2.0f;
            this.cursor.camera = uiCamera;
            PixelScene.align((Visual)this.cursor);
            this.cursor.draw();
        }
    }

    public synchronized void saveWindows() {
        if (this.members == null) {
            return;
        }
        savedWindows.clear();
        savedClass = ((Object)((Object)this)).getClass();
        for (Gizmo g : this.members.toArray(new Gizmo[0])) {
            if (!(g instanceof Window)) continue;
            savedWindows.add(g.getClass());
        }
    }

    public synchronized void restoreWindows() {
        if (((Object)((Object)this)).getClass().equals(savedClass)) {
            for (Class<? extends Window> w : savedWindows) {
                try {
                    this.add((Gizmo)Reflection.newInstanceUnhandled(w));
                }
                catch (Exception exception) {}
            }
        }
        savedWindows.clear();
    }

    public void destroy() {
        super.destroy();
        PointerEvent.clearListeners();
        if (this.cursor != null) {
            this.cursor.destroy();
        }
    }

    public static boolean landscape() {
        return SPDSettings.interfaceSize() > 0 || Game.width > Game.height;
    }

    public static RenderedTextBlock renderTextBlock(int size) {
        return PixelScene.renderTextBlock("", size);
    }

    public static RenderedTextBlock renderTextBlock(String text, int size) {
        RenderedTextBlock result = new RenderedTextBlock(text, size * defaultZoom);
        result.zoom(1.0f / (float)defaultZoom);
        return result;
    }

    public static float align(float pos) {
        return (float)Math.round(pos * (float)defaultZoom) / (float)defaultZoom;
    }

    public static float align(Camera camera, float pos) {
        return (float)Math.round(pos * camera.zoom) / camera.zoom;
    }

    public static void align(Visual v) {
        v.x = PixelScene.align(v.x);
        v.y = PixelScene.align(v.y);
    }

    public static void align(Component c) {
        c.setPos(PixelScene.align(c.left()), PixelScene.align(c.top()));
    }

    protected void fadeIn() {
        if (noFade) {
            noFade = false;
        } else {
            this.fadeIn(-16777216, false);
        }
    }

    protected void fadeIn(int color, boolean light) {
        this.add((Gizmo)new Fader(color, light));
    }

    public static void showBadge(Badges.Badge badge) {
        BadgeBanner banner = BadgeBanner.show(badge.image);
        banner.camera = uiCamera;
        banner.x = PixelScene.align(banner.camera, ((float)banner.camera.width - banner.width) / 2.0f);
        banner.y = PixelScene.align(banner.camera, ((float)banner.camera.height - banner.height) / 3.0f);
        Scene s = Game.scene();
        if (s != null) {
            s.add((Gizmo)banner);
        }
    }

    static {
        savedWindows = new ArrayList();
        savedClass = null;
        noFade = false;
    }

    private static class PixelCamera
    extends Camera {
        public PixelCamera(float zoom) {
            super((int)((double)Game.width - Math.ceil((float)Game.width / zoom) * (double)zoom) / 2, (int)((double)Game.height - Math.ceil((float)Game.height / zoom) * (double)zoom) / 2, (int)Math.ceil((float)Game.width / zoom), (int)Math.ceil((float)Game.height / zoom), zoom);
            this.fullScreen = true;
        }

        protected void updateMatrix() {
            float sx = PixelScene.align(this, this.scroll.x + this.shakeX);
            float sy = PixelScene.align(this, this.scroll.y + this.shakeY);
            this.matrix[0] = this.zoom * invW2;
            this.matrix[5] = -this.zoom * invH2;
            this.matrix[12] = -1.0f + (float)this.x * invW2 - sx * this.matrix[0];
            this.matrix[13] = 1.0f - (float)this.y * invH2 - sy * this.matrix[5];
        }
    }

    protected static class Fader
    extends ColorBlock {
        private static float FADE_TIME = 1.0f;
        private boolean light;
        private float time;

        public Fader(int color, boolean light) {
            super((float)PixelScene.uiCamera.width, (float)PixelScene.uiCamera.height, color);
            this.light = light;
            this.camera = uiCamera;
            this.alpha(1.0f);
            this.time = FADE_TIME;
        }

        public void update() {
            float f;
            super.update();
            this.time -= Game.elapsed;
            if (f <= 0.0f) {
                this.alpha(0.0f);
                this.parent.remove((Gizmo)this);
                this.destroy();
            } else {
                this.alpha(this.time / FADE_TIME);
            }
        }

        public void draw() {
            if (this.light) {
                Blending.setLightMode();
                super.draw();
                Blending.setNormalMode();
            } else {
                super.draw();
            }
        }
    }
}

