/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.scenes;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Chrome;
import com.shatteredpixel.shatteredpixeldungeon.GamesInProgress;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.journal.Journal;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.HeroSelectScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.TitleScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.Archs;
import com.shatteredpixel.shatteredpixeldungeon.ui.Button;
import com.shatteredpixel.shatteredpixeldungeon.ui.ExitButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndGameInProgress;
import com.watabou.noosa.BitmapText;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.Image;
import com.watabou.noosa.NinePatch;
import com.watabou.noosa.Visual;
import java.util.ArrayList;

public class StartScene
extends PixelScene {
    private static final int SLOT_WIDTH = 120;
    private static final int SLOT_HEIGHT = 30;

    @Override
    public void create() {
        super.create();
        Badges.loadGlobal();
        Journal.loadGlobal();
        StartScene.uiCamera.visible = false;
        int w = Camera.main.width;
        int h = Camera.main.height;
        Archs archs = new Archs();
        archs.setSize(w, h);
        this.add((Gizmo)archs);
        ExitButton btnExit = new ExitButton();
        btnExit.setPos((float)w - btnExit.width(), 0.0f);
        this.add((Gizmo)btnExit);
        RenderedTextBlock title = PixelScene.renderTextBlock(Messages.get((Object)this, "title", new Object[0]), 9);
        title.hardlight(0xFFFF44);
        title.setPos(((float)w - title.width()) / 2.0f, (20.0f - title.height()) / 2.0f);
        StartScene.align(title);
        this.add((Gizmo)title);
        ArrayList<GamesInProgress.Info> games = GamesInProgress.checkAll();
        int slotGap = StartScene.landscape() ? 5 : 10;
        int slotCount = Math.min(4, games.size() + 1);
        int slotsHeight = slotCount * 30 + (slotCount - 1) * slotGap;
        float yPos = (float)(h - slotsHeight) / 2.0f;
        if (StartScene.landscape()) {
            yPos += 8.0f;
        }
        for (GamesInProgress.Info game : games) {
            SaveSlotButton existingGame = new SaveSlotButton();
            existingGame.set(game.slot);
            existingGame.setRect((float)(w - 120) / 2.0f, yPos, 120.0f, 30.0f);
            yPos += (float)(30 + slotGap);
            StartScene.align(existingGame);
            this.add((Gizmo)existingGame);
        }
        if (games.size() < 4) {
            SaveSlotButton newGame = new SaveSlotButton();
            newGame.set(GamesInProgress.firstEmpty());
            newGame.setRect((float)(w - 120) / 2.0f, yPos, 120.0f, 30.0f);
            yPos += (float)(30 + slotGap);
            StartScene.align(newGame);
            this.add((Gizmo)newGame);
        }
        GamesInProgress.curSlot = 0;
        this.fadeIn();
    }

    protected void onBackPressed() {
        ShatteredPixelDungeon.switchNoFade(TitleScene.class);
    }

    private static class SaveSlotButton
    extends Button {
        private NinePatch bg;
        private Image hero;
        private RenderedTextBlock name;
        private Image steps;
        private BitmapText depth;
        private Image classIcon;
        private BitmapText level;
        private int slot;
        private boolean newGame;

        private SaveSlotButton() {
        }

        @Override
        protected void createChildren() {
            super.createChildren();
            this.bg = Chrome.get(Chrome.Type.GEM);
            this.add((Gizmo)this.bg);
            this.name = PixelScene.renderTextBlock(9);
            this.add((Gizmo)this.name);
        }

        public void set(int slot) {
            this.slot = slot;
            GamesInProgress.Info info = GamesInProgress.check(slot);
            boolean bl = this.newGame = info == null;
            if (this.newGame) {
                this.name.text(Messages.get(StartScene.class, "new", new Object[0]));
                if (this.hero != null) {
                    this.remove((Gizmo)this.hero);
                    this.hero = null;
                    this.remove((Gizmo)this.steps);
                    this.steps = null;
                    this.remove((Gizmo)this.depth);
                    this.depth = null;
                    this.remove((Gizmo)this.classIcon);
                    this.classIcon = null;
                    this.remove((Gizmo)this.level);
                    this.level = null;
                }
            } else {
                if (info.subClass != HeroSubClass.NONE) {
                    this.name.text(Messages.titleCase(info.subClass.title()));
                } else {
                    this.name.text(Messages.titleCase(info.heroClass.title()));
                }
                if (this.hero == null) {
                    this.hero = new Image((Object)info.heroClass.spritesheet(), 0, 15 * info.armorTier, 12, 15);
                    this.add((Gizmo)this.hero);
                    this.steps = new Image(Icons.get(Icons.STAIRS));
                    this.add((Gizmo)this.steps);
                    this.depth = new BitmapText(PixelScene.pixelFont);
                    this.add((Gizmo)this.depth);
                    this.classIcon = new Image(Icons.get(info.heroClass));
                    this.add((Gizmo)this.classIcon);
                    this.level = new BitmapText(PixelScene.pixelFont);
                    this.add((Gizmo)this.level);
                } else {
                    this.hero.copy(new Image((Object)info.heroClass.spritesheet(), 0, 15 * info.armorTier, 12, 15));
                    this.classIcon.copy(Icons.get(info.heroClass));
                }
                this.depth.text(Integer.toString(info.depth));
                this.depth.measure();
                this.level.text(Integer.toString(info.level));
                this.level.measure();
                if (info.challenges > 0) {
                    this.name.hardlight(0xFFFF44);
                    this.depth.hardlight(0xFFFF44);
                    this.level.hardlight(0xFFFF44);
                } else {
                    this.name.resetColor();
                    this.depth.resetColor();
                    this.level.resetColor();
                }
            }
            this.layout();
        }

        @Override
        protected void layout() {
            super.layout();
            this.bg.x = this.x;
            this.bg.y = this.y;
            this.bg.size(this.width, this.height);
            if (this.hero != null) {
                this.hero.x = this.x + 8.0f;
                this.hero.y = this.y + (this.height - this.hero.height()) / 2.0f;
                PixelScene.align((Visual)this.hero);
                this.name.setPos(this.hero.x + this.hero.width() + 6.0f, this.y + (this.height - this.name.height()) / 2.0f);
                PixelScene.align(this.name);
                this.classIcon.x = this.x + this.width - 24.0f + (16.0f - this.classIcon.width()) / 2.0f;
                this.classIcon.y = this.y + (this.height - this.classIcon.height()) / 2.0f;
                PixelScene.align((Visual)this.classIcon);
                this.level.x = this.classIcon.x + (this.classIcon.width() - this.level.width()) / 2.0f;
                this.level.y = this.classIcon.y + (this.classIcon.height() - this.level.height()) / 2.0f + 1.0f;
                PixelScene.align((Visual)this.level);
                this.steps.x = this.x + this.width - 40.0f + (16.0f - this.steps.width()) / 2.0f;
                this.steps.y = this.y + (this.height - this.steps.height()) / 2.0f;
                PixelScene.align((Visual)this.steps);
                this.depth.x = this.steps.x + (this.steps.width() - this.depth.width()) / 2.0f;
                this.depth.y = this.steps.y + (this.steps.height() - this.depth.height()) / 2.0f + 1.0f;
                PixelScene.align((Visual)this.depth);
            } else {
                this.name.setPos(this.x + (this.width - this.name.width()) / 2.0f, this.y + (this.height - this.name.height()) / 2.0f);
                PixelScene.align(this.name);
            }
        }

        @Override
        protected void onClick() {
            if (this.newGame) {
                GamesInProgress.selectedClass = null;
                GamesInProgress.curSlot = this.slot;
                ShatteredPixelDungeon.switchScene(HeroSelectScene.class);
            } else {
                ShatteredPixelDungeon.scene().add((Gizmo)new WndGameInProgress(this.slot));
            }
        }
    }
}

