/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.services.analytics;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.Statistics;
import com.shatteredpixel.shatteredpixeldungeon.actors.Char;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Talent;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.Artifact;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.SpiritBow;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.services.analytics.AnalyticsBelongingsData;
import com.shatteredpixel.shatteredpixeldungeon.services.analytics.AnalyticsGameData;
import com.shatteredpixel.shatteredpixeldungeon.services.analytics.AnalyticsItemData;
import com.shatteredpixel.shatteredpixeldungeon.services.analytics.AnalyticsService;
import com.watabou.noosa.Game;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class Analytics {
    public static AnalyticsService service;

    public static boolean supportsAnalytics() {
        return service != null;
    }

    public static void enable() {
        if (Analytics.supportsAnalytics()) {
            service.enable();
            SPDSettings.analytics(true);
            Analytics.trackGameSettings();
        }
    }

    public static void disable() {
        SPDSettings.analytics(false);
        if (Analytics.supportsAnalytics()) {
            service.disable();
        }
    }

    public static void trackScreen(String screen) {
        if (Analytics.supportsAnalytics() && SPDSettings.analytics()) {
            service.trackScreen(screen);
        }
    }

    public static void trackException(Throwable e) {
        if (Analytics.supportsAnalytics() && SPDSettings.analytics()) {
            service.trackException(e);
        }
    }

    public static void trackGameSettings() {
        if (Analytics.supportsAnalytics() && SPDSettings.analytics()) {
            String orientation = "";
            Boolean landscapeSetting = SPDSettings.landscape();
            orientation = landscapeSetting == null ? (PixelScene.landscape() ? "landscape_default" : "portrait_default") : (landscapeSetting != false ? "landscape_forced" : "portrait_forced");
            service.trackGameSettings(SPDSettings.powerSaver(), SPDSettings.brightness(), SPDSettings.visualGrid(), SPDSettings.toolbarMode(), SPDSettings.flipToolbar(), SPDSettings.flipTags(), SPDSettings.quickSlots(), SPDSettings.getBoolean((String)"system_font", (boolean)false), orientation);
        }
    }

    public static void trackItemConsumed(Item item) {
        if (Analytics.supportsAnalytics() && SPDSettings.analytics()) {
            AnalyticsItemData itemData = Analytics.convertItemToData(item);
            AnalyticsGameData gameData = Analytics.convertGameToData();
            if (!itemData.cheater && !gameData.cheater) {
                service.trackItemConsumed(itemData, gameData);
            }
        }
    }

    public static void trackItemUpgraded(Item item) {
        if (Analytics.supportsAnalytics() && SPDSettings.analytics()) {
            AnalyticsItemData itemData = Analytics.convertItemToData(item);
            AnalyticsGameData gameData = Analytics.convertGameToData();
            if (!itemData.cheater && !gameData.cheater) {
                service.trackItemUpgraded(itemData, gameData);
            }
        }
    }

    public static void trackItemCrafted(Item item) {
        if (Analytics.supportsAnalytics() && SPDSettings.analytics()) {
            AnalyticsItemData itemData = Analytics.convertItemToData(item);
            AnalyticsGameData gameData = Analytics.convertGameToData();
            if (!itemData.cheater && !gameData.cheater) {
                service.trackItemCrafted(itemData, gameData);
            }
        }
    }

    public static void trackRunEnd(String desc) {
        if (Analytics.supportsAnalytics() && SPDSettings.analytics()) {
            AnalyticsGameData data = Analytics.convertGameToData();
            if (!data.cheater) {
                service.trackRunEnd(data, desc);
            }
        }
    }

    public static void trackBossBeaten(Char boss) {
        if (Analytics.supportsAnalytics() && SPDSettings.analytics()) {
            AnalyticsGameData gameData = Analytics.convertGameToData();
            AnalyticsBelongingsData belongingsData = Analytics.convertBelongingsToData(Dungeon.hero);
            if (!gameData.cheater && !belongingsData.cheater) {
                service.trackBossBeaten(gameData, belongingsData, boss.getClass().getSimpleName());
            }
        }
    }

    public static AnalyticsItemData convertItemToData(Item item) {
        AnalyticsItemData data = new AnalyticsItemData();
        data.name = item.analyticsName();
        boolean temp = item.levelKnown;
        item.levelKnown = true;
        data.level = item instanceof Artifact ? item.visiblyUpgraded() : item.level();
        item.levelKnown = temp;
        if (data.level > 22) {
            data.cheater = true;
        }
        return data;
    }

    public static AnalyticsGameData convertGameToData() {
        AnalyticsGameData data = new AnalyticsGameData();
        data.gameVersion = Game.version;
        data.heroCls = Dungeon.hero.heroClass.toString();
        data.heroSubCls = Dungeon.hero.subClass.toString();
        data.heroArmorAbility = Dungeon.hero.armorAbility == null ? "NONE" : Dungeon.hero.armorAbility.getClass().getSimpleName();
        data.heroLvl = Dungeon.hero.lvl;
        data.depth = Dungeon.depth;
        data.deepest = Statistics.deepestFloor;
        data.spawnersAlive = Statistics.spawnersAlive;
        data.duration = Statistics.duration;
        data.challengeMask = Dungeon.challenges;
        data.upgrades = Dungeon.hero.upgrades;
        data.crafts = Dungeon.hero.crafted;
        data.talents = new LinkedHashMap();
        int tierNum = 0;
        for (LinkedHashMap<Talent, Integer> tier : Dungeon.hero.talents) {
            ++tierNum;
            for (Talent talent : tier.keySet()) {
                if (tier.get((Object)talent) <= 0 || Dungeon.hero.metamorphedTalents.containsValue((Object)talent)) continue;
                data.talents.put(tierNum + ": " + talent.name(), tier.get((Object)talent));
            }
        }
        data.bestBossBeaten = Badges.isUnlocked(Badges.Badge.CHAMPION_3) ? "8.6+ Challenges" : (Badges.isUnlocked(Badges.Badge.CHAMPION_2) ? "7.3+ Challenges" : (Badges.isUnlocked(Badges.Badge.CHAMPION_1) ? "6.1+ Challenges" : (Badges.isUnlocked(Badges.Badge.VICTORY) ? "5.Yog-Dzewa" : (Badges.isUnlocked(Badges.Badge.BOSS_SLAIN_4) ? "4.King of Dwarves" : (Badges.isUnlocked(Badges.Badge.BOSS_SLAIN_3) ? "3.DM-300" : (Badges.isUnlocked(Badges.Badge.BOSS_SLAIN_2) ? "2.Tengu" : (Badges.isUnlocked(Badges.Badge.BOSS_SLAIN_1) ? "1.Goo" : "0.None")))))));
        data.ratMogrifyFound = Badges.isUnlocked(Badges.Badge.FOUND_RATMOGRIFY);
        if (data.heroLvl > 30) {
            data.cheater = true;
        }
        Iterator<LinkedHashMap<Talent, Integer>> iterator = data.upgrades.values().iterator();
        while (iterator.hasNext()) {
            int lvl = (Integer)((Object)iterator.next());
            if (lvl <= 22) continue;
            data.cheater = true;
        }
        return data;
    }

    public static AnalyticsBelongingsData convertBelongingsToData(Hero hero) {
        AnalyticsBelongingsData data = new AnalyticsBelongingsData();
        data.items = new LinkedHashMap();
        for (Item item : hero.belongings) {
            if (item.visiblyUpgraded() > 22) {
                data.cheater = true;
            }
            if (!item.isEquipped(hero) && !Dungeon.quickslot.contains(item)) continue;
            boolean temp = item.levelKnown;
            item.levelKnown = true;
            data.items.put(item.analyticsName(), item.visiblyUpgraded());
            if (item instanceof Weapon) {
                if (((Weapon)item).enchantment != null) {
                    data.items.put("Enchant: " + ((Weapon)item).enchantment.getClass().getSimpleName(), item.visiblyUpgraded());
                }
                if (((Weapon)item).augment != null) {
                    if (item instanceof SpiritBow) {
                        data.items.put("BowAug: " + ((Weapon)item).augment.name(), item.visiblyUpgraded());
                    } else {
                        data.items.put("WepAug: " + ((Weapon)item).augment.name(), item.visiblyUpgraded());
                    }
                }
            }
            if (item instanceof Armor) {
                if (((Armor)item).glyph != null) {
                    data.items.put("Glyph: " + ((Armor)item).glyph.getClass().getSimpleName(), item.visiblyUpgraded());
                }
                if (((Armor)item).augment != null) {
                    data.items.put("ArmAug: " + ((Armor)item).augment.name(), item.visiblyUpgraded());
                }
            }
            item.levelKnown = temp;
        }
        return data;
    }
}

