/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.tiles;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.levels.LastShopLevel;
import com.shatteredpixel.shatteredpixeldungeon.levels.traps.Trap;
import com.shatteredpixel.shatteredpixeldungeon.plants.Plant;
import com.shatteredpixel.shatteredpixeldungeon.tiles.DungeonTileSheet;
import com.shatteredpixel.shatteredpixeldungeon.tiles.DungeonTilemap;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.Image;
import com.watabou.noosa.Visual;
import com.watabou.noosa.tweeners.ScaleTweener;
import com.watabou.utils.PointF;
import com.watabou.utils.RectF;
import com.watabou.utils.SparseArray;

public class TerrainFeaturesTilemap
extends DungeonTilemap {
    private static TerrainFeaturesTilemap instance;
    private SparseArray<Plant> plants;
    private SparseArray<Trap> traps;

    public TerrainFeaturesTilemap(SparseArray<Plant> plants, SparseArray<Trap> traps) {
        super("environment/terrain_features.png");
        this.plants = plants;
        this.traps = traps;
        this.map(Dungeon.level.map, Dungeon.level.width());
        instance = this;
    }

    @Override
    protected int getTileVisual(int pos, int tile, boolean flat) {
        if (this.traps.get(pos) != null) {
            Trap trap = (Trap)this.traps.get(pos);
            if (!trap.visible) {
                return -1;
            }
            return (trap.active ? trap.color : 8) + trap.shape * 16;
        }
        if (this.plants.get(pos) != null) {
            return ((Plant)this.plants.get((int)pos)).image + 112;
        }
        int stage = (Dungeon.depth - 1) / 5;
        if (Dungeon.depth == 21 && Dungeon.level instanceof LastShopLevel) {
            --stage;
        }
        if (tile == 15) {
            return 9 + 16 * stage + (DungeonTileSheet.tileVariance[pos] >= 50 ? 1 : 0);
        }
        if (tile == 30) {
            return 11 + 16 * stage + (DungeonTileSheet.tileVariance[pos] >= 50 ? 1 : 0);
        }
        if (tile == 2) {
            return 13 + 16 * stage + (DungeonTileSheet.tileVariance[pos] >= 50 ? 1 : 0);
        }
        if (tile == 9) {
            return 720 + (DungeonTileSheet.tileVariance[pos] >= 50 ? 1 : 0);
        }
        return -1;
    }

    public static Image tile(int pos, int tile) {
        RectF uv = TerrainFeaturesTilemap.instance.tileset.get((Object)instance.getTileVisual(pos, tile, true));
        if (uv == null) {
            return null;
        }
        Image img = new Image((Object)TerrainFeaturesTilemap.instance.texture);
        img.frame(uv);
        return img;
    }

    public void growPlant(final int pos) {
        final Image plant = TerrainFeaturesTilemap.tile(pos, this.map[pos]);
        if (plant == null) {
            return;
        }
        plant.origin.set(8.0f, 12.0f);
        plant.scale.set(0.0f);
        plant.point(DungeonTilemap.tileToWorld(pos));
        this.parent.add((Gizmo)plant);
        this.parent.add((Gizmo)new ScaleTweener((Visual)plant, new PointF(1.0f, 1.0f), 0.2f){

            protected void onComplete() {
                plant.killAndErase();
                this.killAndErase();
                TerrainFeaturesTilemap.this.updateMapCell(pos);
            }
        });
    }
}

