/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.ui;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.SPDAction;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.Tag;
import com.watabou.input.GameAction;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.Image;
import com.watabou.noosa.Visual;

public class ActionIndicator
extends Tag {
    Image icon;
    public static Action action;
    public static ActionIndicator instance;
    private boolean needsLayout = false;

    public ActionIndicator() {
        super(0xFFFF4C);
        instance = this;
        this.setSize(SIZE, SIZE);
        this.visible = false;
    }

    @Override
    public GameAction keyAction() {
        return SPDAction.TAG_ACTION;
    }

    @Override
    public void destroy() {
        super.destroy();
        instance = null;
    }

    @Override
    protected synchronized void layout() {
        super.layout();
        if (this.icon != null) {
            this.icon.x = !this.flipped ? this.x + ((float)SIZE - this.icon.width()) / 2.0f + 1.0f : this.x + this.width - ((float)SIZE + this.icon.width()) / 2.0f - 1.0f;
            this.icon.y = this.y + (this.height - this.icon.height()) / 2.0f;
            PixelScene.align((Visual)this.icon);
            if (!this.members.contains(this.icon)) {
                this.add((Gizmo)this.icon);
            }
        }
    }

    @Override
    public synchronized void update() {
        super.update();
        if (!Dungeon.hero.ready) {
            if (this.icon != null) {
                this.icon.alpha(0.5f);
            }
        } else if (this.icon != null) {
            this.icon.alpha(1.0f);
        }
        if (!this.visible && action != null) {
            this.visible = true;
            ActionIndicator.updateIcon();
            this.flash();
        } else {
            boolean bl = this.visible = action != null;
        }
        if (this.needsLayout) {
            this.layout();
            this.needsLayout = false;
        }
    }

    @Override
    protected void onClick() {
        if (action != null && Dungeon.hero.ready) {
            action.doAction();
        }
    }

    @Override
    protected String hoverText() {
        return Messages.titleCase(action.actionName());
    }

    public static void setAction(Action action) {
        ActionIndicator.action = action;
        ActionIndicator.updateIcon();
    }

    public static void clearAction(Action action) {
        if (ActionIndicator.action == action) {
            ActionIndicator.action = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateIcon() {
        if (instance != null) {
            ActionIndicator actionIndicator = instance;
            synchronized (actionIndicator) {
                if (ActionIndicator.instance.icon != null) {
                    ActionIndicator.instance.icon.killAndErase();
                    ActionIndicator.instance.icon = null;
                }
                if (action != null) {
                    ActionIndicator.instance.icon = action.actionIcon();
                    ActionIndicator.instance.needsLayout = true;
                }
            }
        }
    }

    public static interface Action {
        public String actionName();

        public Image actionIcon();

        public void doAction();
    }
}

