/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.ui;

import com.watabou.noosa.Game;
import com.watabou.noosa.Image;

public class Banner
extends Image {
    private State state;
    private float time;
    private int color;
    private float fadeTime;
    private float showTime;

    public Banner(Image sample) {
        this.copy(sample);
        this.alpha(0.0f);
    }

    public Banner(Object tx) {
        super(tx);
        this.alpha(0.0f);
    }

    public void show(int color, float fadeTime, float showTime) {
        this.color = color;
        this.fadeTime = fadeTime;
        this.showTime = showTime;
        this.state = State.FADE_IN;
        this.time = fadeTime;
    }

    public void show(int color, float fadeTime) {
        this.show(color, fadeTime, Float.MAX_VALUE);
    }

    public void update() {
        super.update();
        this.time -= Game.elapsed;
        if (this.time >= 0.0f) {
            float p = this.time / this.fadeTime;
            switch (this.state) {
                case FADE_IN: {
                    this.tint(this.color, p);
                    this.alpha(1.0f - p);
                    break;
                }
                case STATIC: {
                    this.resetColor();
                    break;
                }
                case FADE_OUT: {
                    this.resetColor();
                    this.alpha(p);
                }
            }
        } else {
            switch (this.state) {
                case FADE_IN: {
                    this.time = this.showTime;
                    this.state = State.STATIC;
                    break;
                }
                case STATIC: {
                    this.time = this.fadeTime;
                    this.state = State.FADE_OUT;
                    break;
                }
                case FADE_OUT: {
                    this.killAndErase();
                }
            }
        }
    }

    private static enum State {
        FADE_IN,
        STATIC,
        FADE_OUT;

    }
}

