/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.ui;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.effects.particles.BloodParticle;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.Image;
import com.watabou.noosa.Visual;
import com.watabou.noosa.particles.Emitter;
import com.watabou.noosa.ui.Component;

public class BossHealthBar
extends Component {
    private Image bar;
    private Image rawShielding;
    private Image shieldedHP;
    private Image hp;
    private static Mob boss;
    private Image skull;
    private Emitter blood;
    private static String asset;
    private static BossHealthBar instance;
    private static boolean bleeding;

    public BossHealthBar() {
        this.active = boss != null;
        this.visible = this.active;
        instance = this;
    }

    protected void createChildren() {
        this.bar = new Image((Object)asset, 0, 0, 64, 16);
        this.add((Gizmo)this.bar);
        this.width = this.bar.width;
        this.height = this.bar.height;
        this.rawShielding = new Image((Object)asset, 15, 25, 47, 4);
        this.rawShielding.alpha(0.5f);
        this.add((Gizmo)this.rawShielding);
        this.shieldedHP = new Image((Object)asset, 15, 25, 47, 4);
        this.add((Gizmo)this.shieldedHP);
        this.hp = new Image((Object)asset, 15, 19, 47, 4);
        this.add((Gizmo)this.hp);
        this.skull = new Image((Object)asset, 5, 18, 6, 6);
        this.add((Gizmo)this.skull);
        this.blood = new Emitter();
        this.blood.pos((Visual)this.skull);
        this.blood.pour(BloodParticle.FACTORY, 0.3f);
        this.blood.autoKill = false;
        this.blood.on = false;
        this.add((Gizmo)this.blood);
    }

    protected void layout() {
        this.bar.x = this.x;
        this.bar.y = this.y;
        this.shieldedHP.x = this.rawShielding.x = this.bar.x + 15.0f;
        this.hp.x = this.rawShielding.x;
        this.shieldedHP.y = this.rawShielding.y = this.bar.y + 6.0f;
        this.hp.y = this.rawShielding.y;
        this.skull.x = this.bar.x + 5.0f;
        this.skull.y = this.bar.y + 5.0f;
    }

    public void update() {
        super.update();
        if (boss != null) {
            if (!boss.isAlive() || !Dungeon.level.mobs.contains(boss)) {
                boss = null;
                this.active = false;
                this.visible = false;
            } else {
                float health = BossHealthBar.boss.HP;
                float shield = boss.shielding();
                float max = BossHealthBar.boss.HT;
                this.hp.scale.x = Math.max(0.0f, (health - shield) / max);
                this.shieldedHP.scale.x = health / max;
                this.rawShielding.scale.x = shield / max;
                if (this.hp.scale.x < 0.25f) {
                    BossHealthBar.bleed(true);
                }
                if (bleeding != this.blood.on) {
                    if (bleeding) {
                        this.skull.tint(0xCC0000, 0.6f);
                    } else {
                        this.skull.resetColor();
                    }
                    this.blood.on = bleeding;
                }
            }
        }
    }

    public static void assignBoss(Mob boss) {
        BossHealthBar.boss = boss;
        BossHealthBar.bleed(false);
        if (instance != null) {
            BossHealthBar.instance.active = true;
            BossHealthBar.instance.visible = true;
        }
    }

    public static boolean isAssigned() {
        return boss != null && boss.isAlive() && Dungeon.level.mobs.contains(boss);
    }

    public static void bleed(boolean value) {
        bleeding = value;
    }

    static {
        asset = SPDSettings.goldenUI() ? "private/boss_hp_gold.png" : "interfaces/boss_hp.png";
    }
}

