/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.ui;

import com.shatteredpixel.shatteredpixeldungeon.ui.Tooltip;
import com.watabou.input.ControllerHandler;
import com.watabou.input.GameAction;
import com.watabou.input.KeyBindings;
import com.watabou.input.KeyEvent;
import com.watabou.input.PointerEvent;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Game;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.PointerArea;
import com.watabou.noosa.ui.Component;
import com.watabou.utils.Signal;
import java.util.ArrayList;
import java.util.Iterator;

public class Button
extends Component {
    public static float longClick = 0.5f;
    protected PointerArea hotArea;
    protected Tooltip hoverTip;
    protected boolean pressed;
    protected float pressTime;
    protected boolean processed;
    private Signal.Listener<KeyEvent> keyListener;

    protected void createChildren() {
        this.hotArea = new PointerArea(0.0f, 0.0f, 0.0f, 0.0f){

            protected void onPointerDown(PointerEvent event) {
                Button.this.pressed = true;
                Button.this.pressTime = 0.0f;
                Button.this.processed = false;
                Button.this.onPointerDown();
            }

            protected void onPointerUp(PointerEvent event) {
                Button.this.pressed = false;
                Button.this.onPointerUp();
            }

            protected void onClick(PointerEvent event) {
                if (!Button.this.processed) {
                    Button.this.killTooltip();
                    switch (event.button) {
                        default: {
                            Button.this.onClick();
                            break;
                        }
                        case 1: {
                            Button.this.onRightClick();
                            break;
                        }
                        case 2: {
                            Button.this.onMiddleClick();
                        }
                    }
                }
            }

            protected void onHoverStart(PointerEvent event) {
                String text = Button.this.hoverText();
                if (text != null) {
                    ArrayList bindings;
                    if (Button.this.keyAction() != null && !(bindings = KeyBindings.getBoundKeysForAction((GameAction)Button.this.keyAction())).isEmpty()) {
                        int key = (Integer)bindings.get(0);
                        if (ControllerHandler.controllerPointerActive()) {
                            Iterator iterator = bindings.iterator();
                            while (iterator.hasNext()) {
                                int code = (Integer)iterator.next();
                                if (!ControllerHandler.icControllerKey((int)code)) continue;
                                key = code;
                                break;
                            }
                        }
                        text = text + " _(" + KeyBindings.getKeyName((int)key) + ")_";
                    }
                    Button.this.hoverTip = new Tooltip(text, 80);
                    Button.this.parent.addToFront((Gizmo)Button.this.hoverTip);
                    Button.this.hoverTip.camera = this.camera();
                    Button.this.alignTooltip(Button.this.hoverTip);
                }
            }

            protected void onHoverEnd(PointerEvent event) {
                Button.this.killTooltip();
            }
        };
        this.add((Gizmo)this.hotArea);
        this.keyListener = new Signal.Listener<KeyEvent>(){

            public boolean onSignal(KeyEvent event) {
                if (Button.this.active && KeyBindings.getActionForKey((KeyEvent)event) == Button.this.keyAction()) {
                    if (event.pressed) {
                        Button.this.pressed = true;
                        Button.this.pressTime = 0.0f;
                        Button.this.processed = false;
                        Button.this.onPointerDown();
                    } else {
                        Button.this.onPointerUp();
                        if (Button.this.pressed && !Button.this.processed) {
                            Button.this.onClick();
                        }
                        Button.this.pressed = false;
                    }
                    return true;
                }
                return false;
            }
        };
        KeyEvent.addKeyListener((Signal.Listener)this.keyListener);
    }

    public GameAction keyAction() {
        return null;
    }

    public void update() {
        super.update();
        this.hotArea.active = this.visible;
        if (this.pressed) {
            float f;
            this.pressTime += Game.elapsed;
            if (f >= longClick) {
                this.pressed = false;
                if (this.onLongClick()) {
                    this.hotArea.reset();
                    this.processed = true;
                    this.onPointerUp();
                    Game.vibrate((int)50);
                }
            }
        }
    }

    protected void onPointerDown() {
    }

    protected void onPointerUp() {
    }

    protected void onClick() {
    }

    protected void onRightClick() {
    }

    protected void onMiddleClick() {
    }

    protected boolean onLongClick() {
        return false;
    }

    protected String hoverText() {
        return null;
    }

    private void alignTooltip(Tooltip tip) {
        tip.setPos(this.x, this.y - tip.height() - 1.0f);
        Camera cam = this.camera();
        if (tip.right() > (float)cam.width + cam.scroll.x) {
            tip.setPos(tip.left() - (tip.right() - ((float)cam.width + cam.scroll.x)), tip.top());
        }
        if (tip.top() < 0.0f) {
            tip.setPos(tip.left(), this.bottom() + 1.0f);
        }
    }

    public void killTooltip() {
        if (this.hoverTip != null) {
            this.hoverTip.killAndErase();
            this.hoverTip = null;
        }
    }

    protected void layout() {
        this.hotArea.x = this.x;
        this.hotArea.y = this.y;
        this.hotArea.width = this.width;
        this.hotArea.height = this.height;
    }

    public synchronized void destroy() {
        super.destroy();
        KeyEvent.removeKeyListener(this.keyListener);
    }
}

