/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.ui;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.Armor;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.Ring;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.Weapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.ui.Button;
import com.watabou.noosa.BitmapText;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.Image;
import com.watabou.noosa.Visual;
import com.watabou.utils.Rect;

public class ItemSlot
extends Button {
    public static final int DEGRADED = 0xFF4444;
    public static final int UPGRADED = 0x44FF44;
    public static final int FADED = 0x999999;
    public static final int WARNING = 0xFF8800;
    public static final int ENHANCED = 0x3399FF;
    private static final float ENABLED = 1.0f;
    private static final float DISABLED = 0.3f;
    private Rect margin = new Rect();
    protected ItemSprite sprite;
    protected Item item;
    protected BitmapText status;
    protected BitmapText extra;
    protected Image itemIcon;
    protected BitmapText level;
    private static final String TXT_STRENGTH = ":%d";
    private static final String TXT_TYPICAL_STR = "%d?";
    private static final String TXT_LEVEL = "%+d";
    public static final Item CHEST = new Item(){

        @Override
        public int image() {
            return ItemSpriteSheet.CHEST;
        }
    };
    public static final Item LOCKED_CHEST = new Item(){

        @Override
        public int image() {
            return ItemSpriteSheet.LOCKED_CHEST;
        }
    };
    public static final Item CRYSTAL_CHEST = new Item(){

        @Override
        public int image() {
            return ItemSpriteSheet.CRYSTAL_CHEST;
        }
    };
    public static final Item TOMB = new Item(){

        @Override
        public int image() {
            return ItemSpriteSheet.TOMB;
        }
    };
    public static final Item SKELETON = new Item(){

        @Override
        public int image() {
            return ItemSpriteSheet.BONES;
        }
    };
    public static final Item REMAINS = new Item(){

        @Override
        public int image() {
            return Dungeon.level.epitaph == null ? ItemSpriteSheet.REMAINS : ItemSpriteSheet.GRAVE;
        }
    };

    public ItemSlot() {
        this.sprite.visible(false);
        this.enable(false);
    }

    public ItemSlot(Item item) {
        this();
        this.item(item);
    }

    @Override
    protected void createChildren() {
        super.createChildren();
        this.sprite = new ItemSprite();
        this.add((Gizmo)this.sprite);
        this.status = new BitmapText(PixelScene.pixelFont);
        this.add((Gizmo)this.status);
        this.extra = new BitmapText(PixelScene.pixelFont);
        this.add((Gizmo)this.extra);
        this.level = new BitmapText(PixelScene.pixelFont);
        this.add((Gizmo)this.level);
    }

    @Override
    protected void layout() {
        super.layout();
        this.sprite.x = this.x + (float)this.margin.left + (this.width - this.sprite.width - (float)(this.margin.left + this.margin.right)) / 2.0f;
        this.sprite.y = this.y + (float)this.margin.top + (this.height - this.sprite.height - (float)(this.margin.top + this.margin.bottom)) / 2.0f;
        PixelScene.align((Visual)this.sprite);
        if (this.status != null) {
            this.status.measure();
            if (this.status.width > this.width - (float)(this.margin.left + this.margin.right)) {
                this.status.scale.set(PixelScene.align(0.8f));
            } else {
                this.status.scale.set(1.0f);
            }
            this.status.x = this.x + (float)this.margin.left;
            this.status.y = this.y + (float)this.margin.top;
            PixelScene.align((Visual)this.status);
        }
        if (this.extra != null) {
            this.extra.x = this.x + (this.width - this.extra.width()) - (float)this.margin.right;
            this.extra.y = this.y + (float)this.margin.top;
            PixelScene.align((Visual)this.extra);
            if (this.status.width() + this.extra.width() > this.width) {
                this.extra.visible = false;
            } else if (this.item != null) {
                this.extra.visible = true;
            }
        }
        if (this.itemIcon != null) {
            this.itemIcon.x = this.x + this.width - (8.0f + this.itemIcon.width()) / 2.0f - (float)this.margin.right;
            this.itemIcon.y = this.y + (8.0f - this.itemIcon.height) / 2.0f + (float)this.margin.top;
            PixelScene.align((Visual)this.itemIcon);
        }
        if (this.level != null) {
            this.level.x = this.x + (this.width - this.level.width()) - (float)this.margin.right;
            this.level.y = this.y + (this.height - this.level.baseLine() - 1.0f) - (float)this.margin.bottom;
            PixelScene.align((Visual)this.level);
        }
    }

    public void clear() {
        this.item(null);
        this.enable(true);
        this.sprite.visible(true);
        this.sprite.view(ItemSpriteSheet.SOMETHING, null);
        this.layout();
    }

    public void item(Item item) {
        if (this.item == item) {
            if (item != null) {
                this.sprite.view(item);
            }
            this.updateText();
            return;
        }
        this.item = item;
        if (item == null) {
            this.enable(false);
            this.sprite.visible(false);
            this.updateText();
        } else {
            this.enable(true);
            this.sprite.visible(true);
            this.sprite.view(item);
            this.updateText();
        }
    }

    public void updateText() {
        if (this.itemIcon != null) {
            this.remove((Gizmo)this.itemIcon);
            this.itemIcon = null;
        }
        if (this.item == null) {
            this.level.visible = false;
            this.extra.visible = false;
            this.status.visible = false;
            return;
        }
        this.level.visible = true;
        this.extra.visible = true;
        this.status.visible = true;
        this.status.text(this.item.status());
        if (this.item.icon != -1 && (this.item.isIdentified() || this.item instanceof Ring && ((Ring)this.item).isKnown())) {
            this.extra.text(null);
            this.itemIcon = new Image((Object)"sprites/item_icons.png");
            this.itemIcon.frame(ItemSpriteSheet.Icons.film.get((Object)this.item.icon));
            this.add((Gizmo)this.itemIcon);
        } else if (this.item instanceof Weapon || this.item instanceof Armor) {
            int str;
            if (this.item.levelKnown) {
                str = this.item instanceof Weapon ? ((Weapon)this.item).STRReq() : ((Armor)this.item).STRReq();
                this.extra.text(Messages.format(TXT_STRENGTH, str));
                if (str > Dungeon.hero.STR()) {
                    this.extra.hardlight(0xFF4444);
                } else {
                    this.extra.resetColor();
                }
            } else {
                str = this.item instanceof Weapon ? ((Weapon)this.item).STRReq(0) : ((Armor)this.item).STRReq(0);
                this.extra.text(Messages.format(TXT_TYPICAL_STR, str));
                this.extra.hardlight(0xFF8800);
            }
            this.extra.measure();
        } else {
            this.extra.text(null);
        }
        int trueLvl = this.item.visiblyUpgraded();
        int buffedLvl = this.item.buffedVisiblyUpgraded();
        if (trueLvl != 0 || buffedLvl != 0) {
            this.level.text(Messages.format(TXT_LEVEL, buffedLvl));
            this.level.measure();
            if (trueLvl == buffedLvl || buffedLvl <= 0) {
                this.level.hardlight(buffedLvl > 0 ? 0x44FF44 : 0xFF4444);
            } else {
                this.level.hardlight(buffedLvl > trueLvl ? 0x3399FF : 0xFF8800);
            }
        } else {
            this.level.text(null);
        }
        this.layout();
    }

    public void enable(boolean value) {
        this.active = value;
        float alpha = value ? 1.0f : 0.3f;
        this.sprite.alpha(alpha);
        this.status.alpha(alpha);
        this.extra.alpha(alpha);
        this.level.alpha(alpha);
        if (this.itemIcon != null) {
            this.itemIcon.alpha(alpha);
        }
    }

    public void showExtraInfo(boolean show) {
        if (show) {
            this.add((Gizmo)this.extra);
        } else {
            this.remove((Gizmo)this.extra);
        }
    }

    public void setMargins(int left, int top, int right, int bottom) {
        this.margin.set(left, top, right, bottom);
        this.layout();
    }

    @Override
    protected String hoverText() {
        if (this.item != null && this.item.name() != null) {
            return Messages.titleCase(this.item.name());
        }
        return super.hoverText();
    }
}

