/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.ui;

import com.shatteredpixel.shatteredpixeldungeon.Chrome;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.watabou.noosa.Game;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.NinePatch;
import com.watabou.noosa.ui.Component;
import com.watabou.utils.GameMath;

public class Tooltip
extends Component {
    private static float tooltipAlpha = -5.0f;
    private static float lastUsedTime = -1.0f;
    private NinePatch bg;
    private RenderedTextBlock text;

    public static void resetLastUsedTime() {
        lastUsedTime = -1.0f;
        tooltipAlpha = -5.0f;
    }

    public Tooltip(String msg, int maxWidth) {
        this.text.text(msg, maxWidth);
        this.layout();
        if (lastUsedTime == -1.0f || lastUsedTime > Game.timeTotal) {
            tooltipAlpha = -5.0f;
        } else {
            float elapsed = Game.timeTotal - lastUsedTime;
            if (elapsed >= 0.25f || tooltipAlpha < 1.0f) {
                tooltipAlpha = -5.0f;
            }
        }
        lastUsedTime = Game.timeTotal;
        this.bg.alpha(GameMath.gate((float)0.0f, (float)tooltipAlpha, (float)1.0f));
        this.text.alpha(GameMath.gate((float)0.0f, (float)tooltipAlpha, (float)1.0f));
    }

    protected void createChildren() {
        super.createChildren();
        this.bg = Chrome.get(Chrome.Type.TOAST_TR);
        this.add((Gizmo)this.bg);
        this.text = PixelScene.renderTextBlock(6);
        this.add((Gizmo)this.text);
    }

    public synchronized void update() {
        super.update();
        tooltipAlpha = Math.min(1.0f, tooltipAlpha + 10.0f * Game.elapsed);
        lastUsedTime = Game.timeTotal;
        this.bg.alpha(GameMath.gate((float)0.0f, (float)tooltipAlpha, (float)1.0f));
        this.text.alpha(GameMath.gate((float)0.0f, (float)tooltipAlpha, (float)1.0f));
    }

    protected void layout() {
        this.text.setPos(this.x + (float)this.bg.marginLeft(), this.y + (float)this.bg.marginTop());
        this.bg.x = this.x;
        this.bg.y = this.y;
        this.bg.size(this.text.width() + (float)this.bg.marginHor(), this.text.height() + (float)this.bg.marginVer());
        this.width = this.bg.width;
        this.height = this.bg.height;
    }
}

