/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.ui;

import com.shatteredpixel.shatteredpixeldungeon.Chrome;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.RedButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.ui.Window;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.TextInput;
import com.watabou.utils.DeviceCompat;

public class WndTextInput
extends Window {
    private static final int WIDTH = 120;
    private static final int W_LAND_MULTI = 200;
    private static final int MARGIN = 2;
    private static final int BUTTON_HEIGHT = 16;
    private TextInput textBox;

    public WndTextInput(String title, String initialValue, int maxLength, boolean multiLine, String posTxt, String negTxt) {
        if (!DeviceCompat.isDesktop()) {
            if (PixelScene.landscape()) {
                this.offset(0, -45);
            } else {
                this.offset(0, multiLine ? -60 : -45);
            }
        }
        int width = PixelScene.landscape() && multiLine ? 200 : 120;
        RenderedTextBlock txtTitle = PixelScene.renderTextBlock(title, 9);
        txtTitle.maxWidth(width);
        txtTitle.hardlight(0xFFFF44);
        txtTitle.setPos(((float)width - txtTitle.width()) / 2.0f, 2.0f);
        this.add((Gizmo)txtTitle);
        int textSize = (int)PixelScene.uiCamera.zoom * (multiLine ? 6 : 9);
        this.textBox = new TextInput(Chrome.get(Chrome.Type.TOAST_WHITE), multiLine, textSize){

            public void enterPressed() {
                WndTextInput.this.onSelect(true, this.getText());
                WndTextInput.this.hide();
            }
        };
        if (initialValue != null) {
            this.textBox.setText(initialValue);
        }
        this.textBox.setMaxLength(maxLength);
        float pos = txtTitle.bottom() + 4.0f;
        float inputHeight = multiLine ? 64.0f : 16.0f;
        this.add((Gizmo)this.textBox);
        this.textBox.setRect(2.0f, pos, (float)(width - 4), inputHeight);
        pos += inputHeight + 2.0f;
        RedButton positiveBtn = new RedButton(posTxt){

            @Override
            protected void onClick() {
                WndTextInput.this.onSelect(true, WndTextInput.this.textBox.getText());
                WndTextInput.this.hide();
            }
        };
        RedButton negativeBtn = negTxt != null ? new RedButton(negTxt){

            @Override
            protected void onClick() {
                WndTextInput.this.onSelect(false, WndTextInput.this.textBox.getText());
                WndTextInput.this.hide();
            }
        } : null;
        if (negTxt != null) {
            positiveBtn.setRect(2.0f, pos, (width - 6) / 2, 16.0f);
            this.add((Gizmo)positiveBtn);
            negativeBtn.setRect(positiveBtn.right() + 2.0f, pos, (width - 6) / 2, 16.0f);
            this.add((Gizmo)negativeBtn);
        } else {
            positiveBtn.setRect(2.0f, pos, width - 4, 16.0f);
            this.add((Gizmo)positiveBtn);
        }
        this.resize(width, (int)(pos += 18.0f));
        this.textBox.setRect(2.0f, this.textBox.top(), (float)(width - 4), inputHeight);
    }

    @Override
    public void offset(int xOffset, int yOffset) {
        super.offset(xOffset, yOffset);
        if (this.textBox != null) {
            this.textBox.setRect(this.textBox.left(), this.textBox.top(), this.textBox.width(), this.textBox.height());
        }
    }

    public void onSelect(boolean positive, String text) {
    }

    @Override
    public void onBackPressed() {
    }
}

