/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.utils;

import com.watabou.utils.Random;

public class DungeonSeed {
    private static long TOTAL_SEEDS = 5429503678976L;

    public static long randomSeed() {
        return Random.Long((long)TOTAL_SEEDS);
    }

    public static long convertFromCode(String code) {
        if (code.length() != 9) {
            throw new IllegalArgumentException("codes must be 9 A-Z characters.");
        }
        long result = 0L;
        for (int i = 8; i >= 0; --i) {
            char c = code.charAt(i);
            if (c > 'Z' || c < 'A') {
                throw new IllegalArgumentException("codes must be 9 A-Z characters.");
            }
            result = (long)((double)result + (double)(c - 65) * Math.pow(26.0, 8 - i));
        }
        return result;
    }

    public static String convertToCode(long seed) {
        if (seed < 0L || seed >= TOTAL_SEEDS) {
            throw new IllegalArgumentException("seeds must be within the range [0, TOTAL_SEEDS)");
        }
        String interrim = Long.toString(seed, 26);
        String result = "";
        for (int i = 0; i < 9; ++i) {
            if (i < interrim.length()) {
                char c = interrim.charAt(i);
                c = c <= '9' ? (char)(c + 17) : (char)(c - 22);
                result = result + c;
                continue;
            }
            result = 'A' + result;
        }
        return result;
    }

    public static long convertFromText(String inputText) {
        long total = 0L;
        for (char c : inputText.toCharArray()) {
            total = 31L * total + (long)c;
        }
        if (total < 0L) {
            total += Long.MAX_VALUE;
        }
        return total %= TOTAL_SEEDS;
    }
}

