/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.windows;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.items.EnergyCrystal;
import com.shatteredpixel.shatteredpixeldungeon.items.EquipableItem;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.AlchemyScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.ui.RedButton;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndBag;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndInfoItem;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.Image;

public class WndEnergizeItem
extends WndInfoItem {
    private static final float GAP = 2.0f;
    private static final int BTN_HEIGHT = 18;
    private WndBag owner;
    public static WndBag.ItemSelector selector = new WndBag.ItemSelector(){

        @Override
        public String textPrompt() {
            return Messages.get(WndEnergizeItem.class, "prompt", new Object[0]);
        }

        @Override
        public boolean itemSelectable(Item item) {
            return item.energyVal() > 0;
        }

        @Override
        public void onSelect(Item item) {
            if (item != null) {
                WndBag parentWnd = WndEnergizeItem.openItemSelector();
                if (ShatteredPixelDungeon.scene() instanceof GameScene) {
                    GameScene.show(new WndEnergizeItem(item, parentWnd));
                } else {
                    ShatteredPixelDungeon.scene().addToFront((Gizmo)new WndEnergizeItem(item, parentWnd));
                }
            }
        }
    };

    public WndEnergizeItem(final Item item, WndBag owner) {
        super(item);
        this.owner = owner;
        float pos = this.height;
        if (item.quantity() == 1) {
            RedButton btnEnergize = new RedButton(Messages.get((Object)this, "energize", item.energyVal())){

                @Override
                protected void onClick() {
                    WndEnergizeItem.energize(item);
                    WndEnergizeItem.this.hide();
                }
            };
            btnEnergize.setRect(0.0f, pos + 2.0f, this.width, 18.0f);
            btnEnergize.icon((Image)new ItemSprite(ItemSpriteSheet.ENERGY));
            this.add((Gizmo)btnEnergize);
            pos = btnEnergize.bottom();
        } else {
            int energyAll = item.energyVal();
            RedButton btnEnergize1 = new RedButton(Messages.get((Object)this, "energize_1", energyAll / item.quantity())){

                @Override
                protected void onClick() {
                    WndEnergizeItem.energizeOne(item);
                    WndEnergizeItem.this.hide();
                }
            };
            btnEnergize1.setRect(0.0f, pos + 2.0f, this.width, 18.0f);
            btnEnergize1.icon((Image)new ItemSprite(ItemSpriteSheet.ENERGY));
            this.add((Gizmo)btnEnergize1);
            RedButton btnEnergizeAll = new RedButton(Messages.get((Object)this, "energize_all", energyAll)){

                @Override
                protected void onClick() {
                    WndEnergizeItem.energize(item);
                    WndEnergizeItem.this.hide();
                }
            };
            btnEnergizeAll.setRect(0.0f, btnEnergize1.bottom() + 1.0f, this.width, 18.0f);
            btnEnergizeAll.icon((Image)new ItemSprite(ItemSpriteSheet.ENERGY));
            this.add((Gizmo)btnEnergizeAll);
            pos = btnEnergizeAll.bottom();
        }
        this.resize(this.width, (int)pos);
    }

    @Override
    public void hide() {
        super.hide();
        if (this.owner != null) {
            this.owner.hide();
            WndEnergizeItem.openItemSelector();
        }
    }

    public static void energize(Item item) {
        Hero hero = Dungeon.hero;
        if (item.isEquipped(hero) && !((EquipableItem)item).doUnequip(hero, false)) {
            return;
        }
        item.detachAll(hero.belongings.backpack);
        if (ShatteredPixelDungeon.scene() instanceof AlchemyScene) {
            Dungeon.energy += item.energyVal();
            ((AlchemyScene)ShatteredPixelDungeon.scene()).createEnergy();
        } else {
            hero.spend(-hero.cooldown());
            new EnergyCrystal(item.energyVal()).doPickUp(hero);
        }
    }

    public static void energizeOne(Item item) {
        if (item.quantity() <= 1) {
            WndEnergizeItem.energize(item);
        } else {
            Hero hero = Dungeon.hero;
            item = item.detach(hero.belongings.backpack);
            if (ShatteredPixelDungeon.scene() instanceof AlchemyScene) {
                Dungeon.energy += item.energyVal();
                ((AlchemyScene)ShatteredPixelDungeon.scene()).createEnergy();
            } else {
                hero.spend(-hero.cooldown());
                new EnergyCrystal(item.energyVal()).doPickUp(hero);
            }
        }
    }

    public static WndBag openItemSelector() {
        if (ShatteredPixelDungeon.scene() instanceof GameScene) {
            return GameScene.selectItem(selector);
        }
        WndBag window = WndBag.getBag(selector);
        ShatteredPixelDungeon.scene().addToFront((Gizmo)window);
        return window;
    }
}

