/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.windows;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.GamesInProgress;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.InterlevelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.StartScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.HeroSprite;
import com.shatteredpixel.shatteredpixeldungeon.ui.ActionIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.Button;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.RedButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.ui.Window;
import com.shatteredpixel.shatteredpixeldungeon.windows.IconTitle;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndChallenges;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndMessage;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndOptions;
import com.watabou.noosa.Game;
import com.watabou.noosa.Gizmo;
import com.watabou.utils.Bundle;
import com.watabou.utils.FileUtils;
import java.io.IOException;
import java.util.Locale;

public class WndGameInProgress
extends Window {
    private static final int WIDTH = 120;
    private int GAP = 6;
    private float pos;

    public WndGameInProgress(final int slot) {
        final GamesInProgress.Info info = GamesInProgress.check(slot);
        String className = null;
        className = info.subClass != HeroSubClass.NONE ? info.subClass.title() : info.heroClass.title();
        IconTitle title = new IconTitle();
        title.icon(HeroSprite.avatar(info.heroClass, info.armorTier));
        if (info.name.equals("")) {
            title.label(Messages.get((Object)this, "title", info.level, className).toUpperCase(Locale.ENGLISH));
        } else {
            title.label((info.name + "\n" + Messages.get((Object)this, "title", info.level, className)).toUpperCase(Locale.ENGLISH));
        }
        title.color(0xFFFF44);
        title.setRect(0.0f, 0.0f, 120.0f, 0.0f);
        this.add((Gizmo)title);
        Button debug = new Button(){

            @Override
            protected boolean onLongClick() {
                try {
                    Bundle bundle = FileUtils.bundleFromFile((String)GamesInProgress.gameFile(slot));
                    ShatteredPixelDungeon.scene().addToFront((Gizmo)new WndMessage("_Debug Info:_\n\nVersion: " + Game.version + " (" + Game.versionCode + ")\nSeed: " + bundle.getLong("seed") + "\nChallenge Mask: " + info.challenges));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return true;
            }
        };
        debug.setRect(0.0f, 0.0f, title.imIcon.width(), title.imIcon.height);
        this.add((Gizmo)debug);
        if (info.challenges > 0) {
            this.GAP -= 2;
        }
        this.pos = title.bottom() + (float)this.GAP;
        if (info.challenges > 0) {
            RedButton btnChallenges = new RedButton(Messages.get((Object)this, "challenges", new Object[0])){

                @Override
                protected void onClick() {
                    Game.scene().add((Gizmo)new WndChallenges(info.challenges, false));
                }
            };
            btnChallenges.icon(Icons.get(Icons.CHALLENGE_ON));
            float btnW = btnChallenges.reqWidth() + 2.0f;
            btnChallenges.setRect((120.0f - btnW) / 2.0f, this.pos, btnW, 18.0f);
            this.add((Gizmo)btnChallenges);
            this.pos = btnChallenges.bottom() + (float)this.GAP;
        }
        this.pos += (float)this.GAP;
        int strBonus = info.strBonus;
        if (strBonus > 0) {
            this.statSlot(Messages.get((Object)this, "str", new Object[0]), info.str + " + " + strBonus);
        } else if (strBonus < 0) {
            this.statSlot(Messages.get((Object)this, "str", new Object[0]), info.str + " - " + -strBonus);
        } else {
            this.statSlot(Messages.get((Object)this, "str", new Object[0]), info.str);
        }
        if (info.shld > 0) {
            this.statSlot(Messages.get((Object)this, "health", new Object[0]), info.hp + "+" + info.shld + "/" + info.ht);
        } else {
            this.statSlot(Messages.get((Object)this, "health", new Object[0]), info.hp + "/" + info.ht);
        }
        this.statSlot(Messages.get((Object)this, "exp", new Object[0]), info.exp + "/" + Hero.maxExp(info.level));
        this.pos += (float)this.GAP;
        this.statSlot(Messages.get((Object)this, "gold", new Object[0]), info.goldCollected);
        this.statSlot(Messages.get((Object)this, "depth", new Object[0]), info.maxDepth);
        this.pos += (float)this.GAP;
        RedButton cont = new RedButton(Messages.get((Object)this, "continue", new Object[0])){

            @Override
            protected void onClick() {
                super.onClick();
                GamesInProgress.curSlot = slot;
                Dungeon.hero = null;
                ActionIndicator.action = null;
                InterlevelScene.mode = InterlevelScene.Mode.CONTINUE;
                ShatteredPixelDungeon.switchScene(InterlevelScene.class);
            }
        };
        RedButton erase = new RedButton(Messages.get((Object)this, "erase", new Object[0])){

            @Override
            protected void onClick() {
                super.onClick();
                ShatteredPixelDungeon.scene().add((Gizmo)new WndOptions(Icons.get(Icons.WARNING), Messages.get(WndGameInProgress.class, "erase_warn_title", new Object[0]), Messages.get(WndGameInProgress.class, "erase_warn_body", new Object[0]), new String[]{Messages.get(WndGameInProgress.class, "erase_warn_yes", new Object[0]), Messages.get(WndGameInProgress.class, "erase_warn_no", new Object[0])}){

                    @Override
                    protected void onSelect(int index) {
                        if (index == 0) {
                            Dungeon.deleteGame(slot, true);
                            ShatteredPixelDungeon.switchNoFade(StartScene.class);
                        }
                    }
                });
            }
        };
        cont.icon(Icons.get(Icons.ENTER));
        cont.setRect(0.0f, this.pos, 59.0f, 20.0f);
        this.add((Gizmo)cont);
        erase.icon(Icons.get(Icons.CLOSE));
        erase.setRect(61.0f, this.pos, 59.0f, 20.0f);
        this.add((Gizmo)erase);
        this.resize(120, (int)cont.bottom() + 1);
    }

    private void statSlot(String label, String value) {
        RenderedTextBlock txt = PixelScene.renderTextBlock(label, 8);
        txt.setPos(0.0f, this.pos);
        this.add((Gizmo)txt);
        txt = PixelScene.renderTextBlock(value, 8);
        txt.setPos(72.0f, this.pos);
        PixelScene.align(txt);
        this.add((Gizmo)txt);
        this.pos += (float)this.GAP + txt.height();
    }

    private void statSlot(String label, int value) {
        this.statSlot(label, Integer.toString(value));
    }
}

