/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.windows;

import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.CharSprite;
import com.shatteredpixel.shatteredpixeldungeon.ui.BuffIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.HealthBar;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndTitledMessage;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.ui.Component;

public class WndInfoMob
extends WndTitledMessage {
    public WndInfoMob(Mob mob) {
        super(new MobTitle(mob), mob.info());
    }

    private static class MobTitle
    extends Component {
        private static final int GAP = 2;
        private CharSprite image;
        private RenderedTextBlock name;
        private HealthBar health;
        private BuffIndicator buffs;

        public MobTitle(Mob mob) {
            this.name = PixelScene.renderTextBlock(Messages.titleCase(mob.name()), 9);
            this.name.hardlight(0xFFFF44);
            this.add((Gizmo)this.name);
            this.image = mob.sprite();
            this.add((Gizmo)this.image);
            this.health = new HealthBar();
            this.health.level(mob);
            this.add((Gizmo)this.health);
            this.buffs = new BuffIndicator(mob, false);
            this.add((Gizmo)this.buffs);
        }

        protected void layout() {
            this.image.x = 0.0f;
            this.image.y = Math.max(0.0f, this.name.height() + this.health.height() - this.image.height());
            float w = this.width - this.image.width() - 2.0f;
            this.name.maxWidth((int)w);
            this.name.setPos(this.x + this.image.width + 2.0f, this.image.height() > this.name.height() ? this.y + (this.image.height() - this.name.height()) / 2.0f : this.y);
            this.health.setRect(this.image.width() + 2.0f, this.name.bottom() + 2.0f, w, this.health.height());
            this.buffs.setPos(this.name.right() + 2.0f - 1.0f, this.name.bottom() - 7.0f - 2.0f);
            this.height = this.health.bottom();
        }
    }
}

