/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.windows;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.armor.ClassArmor;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.Potion;
import com.shatteredpixel.shatteredpixeldungeon.items.rings.Ring;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.Scroll;
import com.shatteredpixel.shatteredpixeldungeon.items.scrolls.ScrollOfIdentify;
import com.shatteredpixel.shatteredpixeldungeon.journal.Catalog;
import com.shatteredpixel.shatteredpixeldungeon.journal.Document;
import com.shatteredpixel.shatteredpixeldungeon.journal.Notes;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.QuickRecipe;
import com.shatteredpixel.shatteredpixeldungeon.ui.RedButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.ui.ScrollPane;
import com.shatteredpixel.shatteredpixeldungeon.windows.IconTitle;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndStory;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndTabbed;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndTitledMessage;
import com.watabou.noosa.BitmapText;
import com.watabou.noosa.ColorBlock;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.Image;
import com.watabou.noosa.Visual;
import com.watabou.noosa.ui.Component;
import com.watabou.utils.Reflection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class WndJournal
extends WndTabbed {
    public static final int WIDTH_P = 126;
    public static final int HEIGHT_P = 180;
    public static final int WIDTH_L = 200;
    public static final int HEIGHT_L = 130;
    private static final int ITEM_HEIGHT = 18;
    private GuideTab guideTab;
    private AlchemyTab alchemyTab;
    private NotesTab notesTab;
    private CatalogTab catalogTab;
    public static int last_index = 0;

    public WndJournal() {
        WndTabbed.Tab[] tabs;
        int width = PixelScene.landscape() ? 200 : 126;
        int height = PixelScene.landscape() ? 130 : 180;
        this.resize(width, height);
        this.guideTab = new GuideTab();
        this.add((Gizmo)this.guideTab);
        this.guideTab.setRect(0.0f, 0.0f, width, height);
        this.guideTab.updateList();
        this.alchemyTab = new AlchemyTab();
        this.add((Gizmo)this.alchemyTab);
        this.alchemyTab.setRect(0.0f, 0.0f, width, height);
        this.notesTab = new NotesTab();
        this.add((Gizmo)this.notesTab);
        this.notesTab.setRect(0.0f, 0.0f, width, height);
        this.notesTab.updateList();
        this.catalogTab = new CatalogTab();
        this.add((Gizmo)this.catalogTab);
        this.catalogTab.setRect(0.0f, 0.0f, width, height);
        this.catalogTab.updateList();
        for (WndTabbed.Tab tab : tabs = new WndTabbed.Tab[]{new WndTabbed.IconTab((Image)new ItemSprite(ItemSpriteSheet.GUIDE_PAGE, null)){

            @Override
            protected void select(boolean value) {
                super.select(value);
                ((WndJournal)WndJournal.this).guideTab.active = ((WndJournal)WndJournal.this).guideTab.visible = value;
                if (value) {
                    last_index = 0;
                }
            }
        }, new WndTabbed.IconTab((Image)new ItemSprite(ItemSpriteSheet.ALCH_PAGE, null)){

            @Override
            protected void select(boolean value) {
                super.select(value);
                ((WndJournal)WndJournal.this).alchemyTab.active = ((WndJournal)WndJournal.this).alchemyTab.visible = value;
                if (value) {
                    last_index = 1;
                }
            }
        }, new WndTabbed.IconTab(Icons.get(Icons.STAIRS)){

            @Override
            protected void select(boolean value) {
                super.select(value);
                ((WndJournal)WndJournal.this).notesTab.active = ((WndJournal)WndJournal.this).notesTab.visible = value;
                if (value) {
                    last_index = 2;
                }
            }
        }, new WndTabbed.IconTab((Image)new ItemSprite(ItemSpriteSheet.WEAPON_HOLDER, null)){

            @Override
            protected void select(boolean value) {
                super.select(value);
                ((WndJournal)WndJournal.this).catalogTab.active = ((WndJournal)WndJournal.this).catalogTab.visible = value;
                if (value) {
                    last_index = 3;
                }
            }
        }}) {
            this.add(tab);
        }
        this.layoutTabs();
        this.select(last_index);
    }

    @Override
    public void offset(int xOffset, int yOffset) {
        super.offset(xOffset, yOffset);
        this.guideTab.layout();
        this.alchemyTab.layout();
        this.catalogTab.layout();
        this.notesTab.layout();
    }

    private static class CatalogTab
    extends Component {
        private RedButton[] itemButtons;
        private static final int NUM_BUTTONS = 7;
        private static int currentItemIdx = 0;
        private static final int WEAPON_IDX = 0;
        private static final int ARMOR_IDX = 1;
        private static final int WAND_IDX = 2;
        private static final int RING_IDX = 3;
        private static final int ARTIF_IDX = 4;
        private static final int POTION_IDX = 5;
        private static final int SCROLL_IDX = 6;
        private static final int[] spriteIndexes = new int[]{1, 2, 4, 5, 6, 9, 11};
        private ScrollPane list;
        private ArrayList<CatalogItem> items = new ArrayList();

        private CatalogTab() {
        }

        protected void createChildren() {
            this.itemButtons = new RedButton[7];
            for (int i = 0; i < 7; ++i) {
                final int idx = i;
                this.itemButtons[i] = new RedButton(""){

                    @Override
                    protected void onClick() {
                        currentItemIdx = idx;
                        this.updateList();
                    }
                };
                this.itemButtons[i].icon((Image)new ItemSprite(ItemSpriteSheet.SOMETHING + spriteIndexes[i], null));
                this.add((Gizmo)this.itemButtons[i]);
            }
            this.list = new ScrollPane(new Component()){

                @Override
                public void onClick(float x, float y) {
                    int size = items.size();
                    for (int i = 0; i < size && !((CatalogItem)((Object)items.get(i))).onClick(x, y); ++i) {
                    }
                }
            };
            this.add((Gizmo)this.list);
        }

        protected void layout() {
            super.layout();
            int perRow = 7;
            float buttonWidth = this.width() / (float)perRow;
            for (int i = 0; i < 7; ++i) {
                this.itemButtons[i].setRect((float)(i % perRow) * buttonWidth, i / perRow * 18, buttonWidth, 18.0f);
                PixelScene.align(this.itemButtons[i]);
            }
            this.list.setRect(0.0f, this.itemButtons[6].bottom() + 1.0f, this.width, this.height - this.itemButtons[6].bottom() - 1.0f);
        }

        private void updateList() {
            ArrayList<Class<Item>> itemClasses;
            this.items.clear();
            for (int i = 0; i < 7; ++i) {
                if (i == currentItemIdx) {
                    this.itemButtons[i].icon().color(0xFFFF44);
                    continue;
                }
                this.itemButtons[i].icon().resetColor();
            }
            Component content = this.list.content();
            content.clear();
            this.list.scrollTo(0.0f, 0.0f);
            final HashMap<Class<? extends Item>, Boolean> known = new HashMap<Class<? extends Item>, Boolean>();
            if (currentItemIdx == 0) {
                itemClasses = new ArrayList<Class<? extends Item>>(Catalog.WEAPONS.items());
                for (Class<? extends Item> clazz : itemClasses) {
                    known.put(clazz, true);
                }
            } else if (currentItemIdx == 1) {
                itemClasses = new ArrayList<Class<? extends Item>>(Catalog.ARMOR.items());
                for (Class<? extends Item> clazz : itemClasses) {
                    known.put(clazz, true);
                }
            } else if (currentItemIdx == 2) {
                itemClasses = new ArrayList<Class<? extends Item>>(Catalog.WANDS.items());
                for (Class<? extends Item> clazz : itemClasses) {
                    known.put(clazz, true);
                }
            } else if (currentItemIdx == 3) {
                itemClasses = new ArrayList<Class<? extends Item>>(Catalog.RINGS.items());
                for (Class<? extends Item> clazz : itemClasses) {
                    known.put(clazz, Ring.getKnown().contains(clazz));
                }
            } else if (currentItemIdx == 4) {
                itemClasses = new ArrayList<Class<? extends Item>>(Catalog.ARTIFACTS.items());
                for (Class<? extends Item> clazz : itemClasses) {
                    known.put(clazz, true);
                }
            } else if (currentItemIdx == 5) {
                itemClasses = new ArrayList<Class<? extends Item>>(Catalog.POTIONS.items());
                for (Class<? extends Item> clazz : itemClasses) {
                    known.put(clazz, Potion.getKnown().contains(clazz));
                }
            } else if (currentItemIdx == 6) {
                itemClasses = new ArrayList<Class<? extends Item>>(Catalog.SCROLLS.items());
                for (Class<? extends Item> clazz : itemClasses) {
                    known.put(clazz, Scroll.getKnown().contains(clazz));
                }
            } else {
                itemClasses = new ArrayList();
            }
            Collections.sort(itemClasses, new Comparator<Class<? extends Item>>(){

                @Override
                public int compare(Class<? extends Item> a, Class<? extends Item> b) {
                    int result = 0;
                    if (((Boolean)known.get(a)).booleanValue() && Catalog.isSeen(a)) {
                        result -= 2;
                    }
                    if (((Boolean)known.get(b)).booleanValue() && Catalog.isSeen(b)) {
                        result += 2;
                    }
                    if (Catalog.isSeen(a)) {
                        --result;
                    }
                    if (Catalog.isSeen(b)) {
                        ++result;
                    }
                    return result;
                }
            });
            float pos = 0.0f;
            for (Class<Item> itemClass : itemClasses) {
                CatalogItem item = new CatalogItem((Item)Reflection.newInstance(itemClass), (Boolean)known.get(itemClass), Catalog.isSeen(itemClass));
                item.setRect(0.0f, pos, this.width, 18.0f);
                content.add((Gizmo)item);
                this.items.add(item);
                pos += item.height();
            }
            content.setSize(this.width, pos);
            this.list.setSize(this.list.width(), this.list.height());
        }

        private static class CatalogItem
        extends ListItem {
            private Item item;
            private boolean seen;

            public CatalogItem(Item item, boolean IDed, boolean seen) {
                super((Image)new ItemSprite(item), Messages.titleCase(item.trueName()));
                this.item = item;
                this.seen = seen;
                if (seen && !IDed) {
                    if (item instanceof Ring) {
                        ((Ring)item).anonymize();
                    } else if (item instanceof Potion) {
                        ((Potion)item).anonymize();
                    } else if (item instanceof Scroll) {
                        ((Scroll)item).anonymize();
                    }
                }
                if (!seen) {
                    this.icon.copy((Image)new ItemSprite(ItemSpriteSheet.SOMETHING + spriteIndexes[currentItemIdx], null));
                    this.label.text("???");
                    this.label.hardlight(0x999999);
                } else if (!IDed) {
                    this.icon.copy((Image)new ItemSprite(ItemSpriteSheet.SOMETHING + spriteIndexes[currentItemIdx], null));
                    this.label.hardlight(0xCCCCCC);
                }
            }

            public boolean onClick(float x, float y) {
                if (this.inside(x, y) && this.seen) {
                    if (this.item instanceof ClassArmor) {
                        GameScene.show(new WndTitledMessage(new Image(this.icon), Messages.titleCase(this.item.trueName()), this.item.desc()));
                    } else {
                        GameScene.show(new WndTitledMessage(new Image(this.icon), Messages.titleCase(this.item.trueName()), this.item.info()));
                    }
                    return true;
                }
                return false;
            }
        }
    }

    private static class NotesTab
    extends Component {
        private ScrollPane list;

        private NotesTab() {
        }

        protected void createChildren() {
            this.list = new ScrollPane(new Component());
            this.add((Gizmo)this.list);
        }

        protected void layout() {
            super.layout();
            this.list.setRect(0.0f, 0.0f, this.width, this.height);
        }

        private void updateList() {
            Component content = this.list.content();
            float pos = 0.0f;
            ArrayList<Notes.KeyRecord> keys = Notes.getRecords(Notes.KeyRecord.class);
            if (!keys.isEmpty()) {
                ColorBlock line = new ColorBlock(this.width(), 1.0f, -14540254);
                line.y = pos;
                content.add((Gizmo)line);
                RenderedTextBlock renderedTextBlock = PixelScene.renderTextBlock(Messages.get((Object)this, "keys", new Object[0]), 9);
                renderedTextBlock.hardlight(0xFFFF44);
                renderedTextBlock.maxWidth((int)this.width() - 2);
                renderedTextBlock.setPos((this.width() - renderedTextBlock.width()) / 2.0f, pos + 1.0f + (18.0f - renderedTextBlock.height()) / 2.0f);
                PixelScene.align(renderedTextBlock);
                content.add((Gizmo)renderedTextBlock);
                pos += Math.max(18.0f, renderedTextBlock.height());
            }
            for (Notes.Record record : keys) {
                ListItem listItem = new ListItem(Icons.get(Icons.STAIRS), Messages.titleCase(record.desc()), record.depth());
                listItem.setRect(0.0f, pos, this.width(), 18.0f);
                content.add((Gizmo)listItem);
                pos += listItem.height();
            }
            ArrayList<Notes.LandmarkRecord> landmarks = Notes.getRecords(Notes.LandmarkRecord.class);
            if (!landmarks.isEmpty()) {
                ColorBlock colorBlock = new ColorBlock(this.width(), 1.0f, -14540254);
                colorBlock.y = pos;
                content.add((Gizmo)colorBlock);
                RenderedTextBlock renderedTextBlock = PixelScene.renderTextBlock(Messages.get((Object)this, "landmarks", new Object[0]), 9);
                renderedTextBlock.hardlight(0xFFFF44);
                renderedTextBlock.maxWidth((int)this.width() - 2);
                renderedTextBlock.setPos((this.width() - renderedTextBlock.width()) / 2.0f, pos + 1.0f + (18.0f - renderedTextBlock.height()) / 2.0f);
                PixelScene.align(renderedTextBlock);
                content.add((Gizmo)renderedTextBlock);
                pos += Math.max(18.0f, renderedTextBlock.height());
            }
            for (Notes.Record record : landmarks) {
                ListItem item = new ListItem(Icons.get(Icons.STAIRS), Messages.titleCase(record.desc()), record.depth());
                item.setRect(0.0f, pos, this.width(), 18.0f);
                content.add((Gizmo)item);
                pos += item.height();
            }
            content.setSize(this.width(), pos);
            this.list.setSize(this.list.width(), this.list.height());
        }
    }

    public static class AlchemyTab
    extends Component {
        private RedButton[] pageButtons;
        private static final int NUM_BUTTONS = 10;
        private static final int[] spriteIndexes = new int[]{10, 12, 7, 9, 11, 8, 3, 13, 14, 15};
        public static int currentPageIdx = -1;
        private IconTitle title;
        private RenderedTextBlock body;
        private ScrollPane list;
        private ArrayList<QuickRecipe> recipes = new ArrayList();

        protected void createChildren() {
            this.pageButtons = new RedButton[10];
            for (int i = 0; i < 10; ++i) {
                final int idx = i;
                this.pageButtons[i] = new RedButton(""){

                    @Override
                    protected void onClick() {
                        currentPageIdx = idx;
                        this.updateList();
                    }
                };
                if (Document.ALCHEMY_GUIDE.isPageFound(i)) {
                    this.pageButtons[i].icon((Image)new ItemSprite(ItemSpriteSheet.SOMETHING + spriteIndexes[i], null));
                } else {
                    this.pageButtons[i].icon((Image)new ItemSprite(ItemSpriteSheet.SOMETHING, null));
                    this.pageButtons[i].enable(false);
                }
                this.add((Gizmo)this.pageButtons[i]);
            }
            this.title = new IconTitle();
            this.title.icon((Image)new ItemSprite(ItemSpriteSheet.ALCH_PAGE));
            this.title.visible = false;
            this.body = PixelScene.renderTextBlock(6);
            this.list = new ScrollPane(new Component());
            this.add((Gizmo)this.list);
        }

        protected void layout() {
            super.layout();
            if (PixelScene.landscape()) {
                float buttonWidth = this.width() / (float)this.pageButtons.length;
                for (int i = 0; i < 10; ++i) {
                    this.pageButtons[i].setRect((float)i * buttonWidth, 0.0f, buttonWidth, 18.0f);
                    PixelScene.align(this.pageButtons[i]);
                }
            } else {
                float buttonWidth = this.width() / 5.0f;
                float y = 0.0f;
                float x = 0.0f;
                for (int i = 0; i < 10; ++i) {
                    this.pageButtons[i].setRect(x, y, buttonWidth, 18.0f);
                    PixelScene.align(this.pageButtons[i]);
                    x += buttonWidth;
                    if (i != 4) continue;
                    y += 18.0f;
                    x = 0.0f;
                    buttonWidth = this.width() / 5.0f;
                }
            }
            this.list.setRect(0.0f, this.pageButtons[9].bottom() + 1.0f, this.width, this.height - this.pageButtons[9].bottom() - 1.0f);
            this.updateList();
        }

        private void updateList() {
            for (int i = 0; i < 10; ++i) {
                if (i == currentPageIdx) {
                    this.pageButtons[i].icon().color(0xFFFF44);
                    continue;
                }
                this.pageButtons[i].icon().resetColor();
            }
            if (currentPageIdx == -1) {
                return;
            }
            for (QuickRecipe r : this.recipes) {
                if (r == null) continue;
                r.killAndErase();
                r.destroy();
            }
            this.recipes.clear();
            Component content = this.list.content();
            content.clear();
            this.title.visible = true;
            this.title.label(Document.ALCHEMY_GUIDE.pageTitle(currentPageIdx));
            this.title.setRect(0.0f, 0.0f, this.width(), 10.0f);
            content.add((Gizmo)this.title);
            this.body.maxWidth((int)this.width());
            this.body.text(Document.ALCHEMY_GUIDE.pageBody(currentPageIdx));
            this.body.setPos(0.0f, this.title.bottom());
            content.add((Gizmo)this.body);
            Document.ALCHEMY_GUIDE.readPage(currentPageIdx);
            ArrayList<QuickRecipe> toAdd = QuickRecipe.getRecipes(currentPageIdx);
            float top = this.body.bottom() + 2.0f;
            ArrayList<QuickRecipe> toAddThisRow = new ArrayList<QuickRecipe>();
            while (!toAdd.isEmpty()) {
                float spacing;
                if (toAdd.get(0) == null) {
                    toAdd.remove(0);
                    top += 6.0f;
                }
                int w = 0;
                while (!toAdd.isEmpty() && toAdd.get(0) != null && (float)w + toAdd.get(0).width() <= this.width()) {
                    toAddThisRow.add(toAdd.remove(0));
                    w = (int)((float)w + ((QuickRecipe)((Object)toAddThisRow.get(0))).width());
                }
                float left = spacing = (this.width() - (float)w) / (float)(toAddThisRow.size() + 1);
                while (!toAddThisRow.isEmpty()) {
                    QuickRecipe r = (QuickRecipe)((Object)toAddThisRow.remove(0));
                    r.setPos(left, top);
                    left += r.width() + spacing;
                    if (!toAddThisRow.isEmpty()) {
                        ColorBlock spacer = new ColorBlock(1.0f, 16.0f, -14540254);
                        spacer.y = top;
                        spacer.x = left - spacing / 2.0f - 0.5f;
                        PixelScene.align((Visual)spacer);
                        content.add((Gizmo)spacer);
                    }
                    this.recipes.add(r);
                    content.add((Gizmo)r);
                }
                if (!toAdd.isEmpty() && toAdd.get(0) == null) {
                    toAdd.remove(0);
                }
                if (!toAdd.isEmpty() && toAdd.get(0) != null) {
                    ColorBlock spacer = new ColorBlock(this.width(), 1.0f, -14540254);
                    spacer.y = top + 16.0f;
                    spacer.x = 0.0f;
                    content.add((Gizmo)spacer);
                }
                top += 17.0f;
                toAddThisRow.clear();
            }
            content.setSize(this.width(), top -= 1.0f);
            this.list.setSize(this.list.width(), this.list.height());
            this.list.scrollTo(0.0f, 0.0f);
        }
    }

    public static class GuideTab
    extends Component {
        private ScrollPane list;
        private ArrayList<GuideItem> pages = new ArrayList();

        protected void createChildren() {
            this.list = new ScrollPane(new Component()){

                @Override
                public void onClick(float x, float y) {
                    int size = pages.size();
                    for (int i = 0; i < size && !((GuideItem)((Object)pages.get(i))).onClick(x, y); ++i) {
                    }
                }
            };
            this.add((Gizmo)this.list);
        }

        protected void layout() {
            super.layout();
            this.list.setRect(0.0f, 0.0f, this.width, this.height);
        }

        private void updateList() {
            Component content = this.list.content();
            float pos = 0.0f;
            ColorBlock line = new ColorBlock(this.width(), 1.0f, -14540254);
            line.y = pos;
            content.add((Gizmo)line);
            RenderedTextBlock title = PixelScene.renderTextBlock(Document.ADVENTURERS_GUIDE.title(), 9);
            title.hardlight(0xFFFF44);
            title.maxWidth((int)this.width() - 2);
            title.setPos((this.width() - title.width()) / 2.0f, pos + 1.0f + (18.0f - title.height()) / 2.0f);
            PixelScene.align(title);
            content.add((Gizmo)title);
            pos += Math.max(18.0f, title.height());
            for (String page : Document.ADVENTURERS_GUIDE.pageNames()) {
                GuideItem item = new GuideItem(page);
                item.setRect(0.0f, pos, this.width(), 18.0f);
                content.add((Gizmo)item);
                pos += item.height();
                this.pages.add(item);
            }
            content.setSize(this.width(), pos);
            this.list.setSize(this.list.width(), this.list.height());
        }

        public static Image iconForPage(String page) {
            if (!Document.ADVENTURERS_GUIDE.isPageFound(page)) {
                return new ItemSprite(ItemSpriteSheet.GUIDE_PAGE);
            }
            switch (page) {
                default: {
                    return new ItemSprite(ItemSpriteSheet.MASTERY);
                }
                case "Examining": {
                    return Icons.get(Icons.MAGNIFY);
                }
                case "Surprise_Attacks": {
                    return new ItemSprite(ItemSpriteSheet.ASSASSINS_BLADE);
                }
                case "Identifying": {
                    return new ItemSprite(new ScrollOfIdentify());
                }
                case "Food": {
                    return new ItemSprite(ItemSpriteSheet.PASTY);
                }
                case "Dieing": {
                    return new ItemSprite(ItemSpriteSheet.TOMB);
                }
                case "Searching": {
                    return Icons.get(Icons.MAGNIFY);
                }
                case "Strength": {
                    return new ItemSprite(ItemSpriteSheet.GREATAXE);
                }
                case "Upgrades": {
                    return new ItemSprite(ItemSpriteSheet.RING_EMERALD);
                }
                case "Looting": {
                    return new ItemSprite(ItemSpriteSheet.CRYSTAL_KEY);
                }
                case "Levelling": {
                    return Icons.get(Icons.TALENT);
                }
                case "Positioning": {
                    return new ItemSprite(ItemSpriteSheet.SPIRIT_BOW);
                }
                case "Magic": 
            }
            return new ItemSprite(ItemSpriteSheet.WAND_FIREBOLT);
        }

        private static class GuideItem
        extends ListItem {
            private boolean found = false;
            private String page;

            public GuideItem(String page) {
                super(GuideTab.iconForPage(page), Messages.titleCase(Document.ADVENTURERS_GUIDE.pageTitle(page)));
                this.page = page;
                this.found = Document.ADVENTURERS_GUIDE.isPageFound(page);
                if (!this.found) {
                    this.icon.hardlight(0.5f, 0.5f, 0.5f);
                    this.label.text(Messages.titleCase(Messages.get((Object)this, "missing", new Object[0])));
                    this.label.hardlight(0x999999);
                }
            }

            public boolean onClick(float x, float y) {
                if (this.inside(x, y) && this.found) {
                    GameScene.show(new WndStory(GuideTab.iconForPage(this.page), Document.ADVENTURERS_GUIDE.pageTitle(this.page), Document.ADVENTURERS_GUIDE.pageBody(this.page)));
                    Document.ADVENTURERS_GUIDE.readPage(this.page);
                    return true;
                }
                return false;
            }
        }
    }

    private static class ListItem
    extends Component {
        protected RenderedTextBlock label;
        protected BitmapText depth;
        protected ColorBlock line;
        protected Image icon;

        public ListItem(Image icon, String text) {
            this(icon, text, -1);
        }

        public ListItem(Image icon, String text, int d) {
            this.icon.copy(icon);
            this.label.text(text);
            if (d >= 0) {
                this.depth.text(Integer.toString(d));
                this.depth.measure();
                if (d == Dungeon.depth) {
                    this.label.hardlight(0xFFFF44);
                    this.depth.hardlight(0xFFFF44);
                }
            }
        }

        protected void createChildren() {
            this.label = PixelScene.renderTextBlock(7);
            this.add((Gizmo)this.label);
            this.icon = new Image();
            this.add((Gizmo)this.icon);
            this.depth = new BitmapText(PixelScene.pixelFont);
            this.add((Gizmo)this.depth);
            this.line = new ColorBlock(1.0f, 1.0f, -14540254);
            this.add((Gizmo)this.line);
        }

        protected void layout() {
            this.icon.y = this.y + 1.0f + (this.height() - 1.0f - this.icon.height()) / 2.0f;
            this.icon.x = this.x + (16.0f - this.icon.width()) / 2.0f;
            PixelScene.align((Visual)this.icon);
            this.depth.x = this.icon.x + (this.icon.width - this.depth.width()) / 2.0f;
            this.depth.y = this.icon.y + (this.icon.height - this.depth.height()) / 2.0f + 1.0f;
            PixelScene.align((Visual)this.depth);
            this.line.size(this.width, 1.0f);
            this.line.x = 0.0f;
            this.line.y = this.y;
            this.label.maxWidth((int)(this.width - 16.0f - 1.0f));
            this.label.setPos(17.0f, this.y + 1.0f + (this.height() - this.label.height()) / 2.0f);
            PixelScene.align(this.label);
        }
    }
}

