/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.windows;

import com.shatteredpixel.shatteredpixeldungeon.Chrome;
import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Languages;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.GameScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.services.analytics.Analytics;
import com.shatteredpixel.shatteredpixeldungeon.services.news.News;
import com.shatteredpixel.shatteredpixeldungeon.services.sync.Sync;
import com.shatteredpixel.shatteredpixeldungeon.services.updates.Updates;
import com.shatteredpixel.shatteredpixeldungeon.ui.CheckBox;
import com.shatteredpixel.shatteredpixeldungeon.ui.GameLog;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.OptionSlider;
import com.shatteredpixel.shatteredpixeldungeon.ui.RedButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.ui.Toolbar;
import com.shatteredpixel.shatteredpixeldungeon.ui.Window;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndAnalytics;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndGooglePlayGames;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndKeyBindings;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndOptions;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndTabbed;
import com.watabou.noosa.ColorBlock;
import com.watabou.noosa.Game;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.Visual;
import com.watabou.noosa.audio.Sample;
import com.watabou.noosa.ui.Component;
import com.watabou.utils.DeviceCompat;
import com.watabou.utils.Random;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class WndSettings
extends WndTabbed {
    private static final int WIDTH_P = 122;
    private static final int WIDTH_L = 223;
    private static final int SLIDER_HEIGHT = 24;
    private static final int BTN_HEIGHT = 18;
    private static final float GAP = 2.0f;
    private DisplayTab display;
    private UITab ui;
    private DataTab data;
    private AudioTab audio;
    private LangsTab langs;
    public static int last_index = 0;

    public WndSettings() {
        int width = PixelScene.landscape() ? 223 : 122;
        this.display = new DisplayTab();
        this.display.setSize(width, 0.0f);
        float height = this.display.height();
        this.add((Gizmo)this.display);
        this.add(new WndTabbed.IconTab(Icons.get(Icons.DISPLAY)){

            @Override
            protected void select(boolean value) {
                super.select(value);
                ((WndSettings)WndSettings.this).display.visible = ((WndSettings)WndSettings.this).display.active = value;
                if (value) {
                    last_index = 0;
                }
            }
        });
        this.ui = new UITab();
        this.ui.setSize(width, 0.0f);
        height = Math.max(height, this.ui.height());
        this.add((Gizmo)this.ui);
        this.add(new WndTabbed.IconTab(Icons.get(Icons.PREFS)){

            @Override
            protected void select(boolean value) {
                super.select(value);
                ((WndSettings)WndSettings.this).ui.visible = ((WndSettings)WndSettings.this).ui.active = value;
                if (value) {
                    last_index = 1;
                }
            }
        });
        this.data = new DataTab();
        this.data.setSize(width, 0.0f);
        height = Math.max(height, this.data.height());
        this.add((Gizmo)this.data);
        this.add(new WndTabbed.IconTab(Icons.get(Icons.DATA)){

            @Override
            protected void select(boolean value) {
                super.select(value);
                ((WndSettings)WndSettings.this).data.visible = ((WndSettings)WndSettings.this).data.active = value;
                if (value) {
                    last_index = 2;
                }
            }
        });
        this.audio = new AudioTab();
        this.audio.setSize(width, 0.0f);
        height = Math.max(height, this.audio.height());
        this.add((Gizmo)this.audio);
        this.add(new WndTabbed.IconTab(Icons.get(Icons.AUDIO)){

            @Override
            protected void select(boolean value) {
                super.select(value);
                ((WndSettings)WndSettings.this).audio.visible = ((WndSettings)WndSettings.this).audio.active = value;
                if (value) {
                    last_index = 3;
                }
            }
        });
        this.langs = new LangsTab();
        this.langs.setSize(width, 0.0f);
        height = Math.max(height, this.langs.height());
        this.add((Gizmo)this.langs);
        WndTabbed.IconTab langsTab = new WndTabbed.IconTab(Icons.get(Icons.LANGS)){

            @Override
            protected void select(boolean value) {
                super.select(value);
                ((WndSettings)WndSettings.this).langs.visible = ((WndSettings)WndSettings.this).langs.active = value;
                if (value) {
                    last_index = 4;
                }
            }

            @Override
            protected void createChildren() {
                super.createChildren();
                switch (Messages.lang().status()) {
                    case INCOMPLETE: {
                        this.icon.hardlight(1.5f, 0.0f, 0.0f);
                        break;
                    }
                    case UNREVIEWED: {
                        this.icon.hardlight(1.5f, 0.75f, 0.0f);
                    }
                }
            }
        };
        this.add(langsTab);
        this.resize(width, (int)Math.ceil(height));
        this.layoutTabs();
        this.select(last_index);
    }

    @Override
    public void hide() {
        super.hide();
        ShatteredPixelDungeon.seamlessResetScene(new Game.SceneChangeCallback(){

            public void beforeCreate() {
                Game.platform.resetGenerators();
            }

            public void afterCreate() {
            }
        });
    }

    private static class LangsTab
    extends Component {
        static final int COLS_P = 3;
        static final int COLS_L = 4;
        static final int BTN_HEIGHT = 11;
        RenderedTextBlock title;
        ColorBlock sep1;
        RenderedTextBlock txtLangName;
        RenderedTextBlock txtLangInfo;
        ColorBlock sep2;
        RedButton[] lanBtns;
        ColorBlock sep3;
        RenderedTextBlock txtTranifex;
        RedButton btnCredits;

        private LangsTab() {
        }

        protected void createChildren() {
            this.title = PixelScene.renderTextBlock(Messages.get((Object)this, "title", new Object[0]), 9);
            this.title.hardlight(0xFFFF44);
            this.add((Gizmo)this.title);
            this.sep1 = new ColorBlock(1.0f, 1.0f, -16777216);
            this.add((Gizmo)this.sep1);
            final ArrayList<Languages> langs = new ArrayList<Languages>(Arrays.asList(Languages.values()));
            Languages nativeLang = Languages.matchLocale(Locale.getDefault());
            langs.remove((Object)nativeLang);
            langs.add(0, nativeLang);
            final Languages currLang = Messages.lang();
            this.txtLangName = PixelScene.renderTextBlock(Messages.titleCase(currLang.nativeName()), 9);
            if (currLang.status() == Languages.Status.REVIEWED) {
                this.txtLangName.hardlight(0xFFFF44);
            } else if (currLang.status() == Languages.Status.UNREVIEWED) {
                this.txtLangName.hardlight(0xFF8800);
            } else if (currLang.status() == Languages.Status.INCOMPLETE) {
                this.txtLangName.hardlight(0xFF0000);
            }
            this.add((Gizmo)this.txtLangName);
            this.txtLangInfo = PixelScene.renderTextBlock(6);
            if (currLang == Languages.ENGLISH) {
                this.txtLangInfo.text("This is the source language, written by the developer.");
            } else if (currLang.status() == Languages.Status.REVIEWED) {
                this.txtLangInfo.text(Messages.get((Object)this, "completed", new Object[0]));
            } else if (currLang.status() == Languages.Status.UNREVIEWED) {
                this.txtLangInfo.text(Messages.get((Object)this, "unreviewed", new Object[0]));
            } else if (currLang.status() == Languages.Status.INCOMPLETE) {
                this.txtLangInfo.text(Messages.get((Object)this, "unfinished", new Object[0]));
            }
            if (currLang.status() == Languages.Status.UNREVIEWED) {
                this.txtLangInfo.setHightlighting(true, 0xFF8800);
            } else if (currLang.status() == Languages.Status.INCOMPLETE) {
                this.txtLangInfo.setHightlighting(true, 0xFF0000);
            }
            this.add((Gizmo)this.txtLangInfo);
            this.sep2 = new ColorBlock(1.0f, 1.0f, -16777216);
            this.add((Gizmo)this.sep2);
            this.lanBtns = new RedButton[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                final int langIndex = i;
                RedButton btn = new RedButton(Messages.titleCase(langs.get(i).nativeName()), 8){

                    @Override
                    protected void onClick() {
                        super.onClick();
                        Messages.setup((Languages)((Object)langs.get(langIndex)));
                        ShatteredPixelDungeon.seamlessResetScene(new Game.SceneChangeCallback(){

                            public void beforeCreate() {
                                SPDSettings.language((Languages)((Object)langs.get(langIndex)));
                                GameLog.wipe();
                                Game.platform.resetGenerators();
                            }

                            public void afterCreate() {
                            }
                        });
                    }
                };
                if (currLang == langs.get(i)) {
                    btn.textColor(0xFFFF44);
                } else {
                    switch (langs.get(i).status()) {
                        case INCOMPLETE: {
                            btn.textColor(0x888888);
                            break;
                        }
                        case UNREVIEWED: {
                            btn.textColor(0xBBBBBB);
                        }
                    }
                }
                this.lanBtns[i] = btn;
                this.add((Gizmo)btn);
            }
            this.sep3 = new ColorBlock(1.0f, 1.0f, -16777216);
            this.add((Gizmo)this.sep3);
            this.txtTranifex = PixelScene.renderTextBlock(6);
            this.txtTranifex.text(Messages.get((Object)this, "transifex", new Object[0]));
            this.add((Gizmo)this.txtTranifex);
            if (currLang != Languages.ENGLISH) {
                String credText;
                this.btnCredits = new RedButton(credText, (credText = Messages.titleCase(Messages.get((Object)this, "credits", new Object[0]))).length() > 9 ? 6 : 9){

                    @Override
                    protected void onClick() {
                        int w;
                        int i;
                        super.onClick();
                        String[] reviewers = currLang.reviewers();
                        String[] translators = currLang.translators();
                        int totalCredits = 2 * reviewers.length + translators.length;
                        int totalTokens = 2 * totalCredits;
                        if (reviewers.length > 0) {
                            totalTokens += 6;
                        }
                        String[] entries = new String[totalTokens += 4];
                        int index = 0;
                        if (reviewers.length > 0) {
                            entries[0] = "_";
                            entries[1] = Messages.titleCase(Messages.get((Object)this, "reviewers", new Object[0]));
                            entries[2] = "_";
                            entries[3] = "\n";
                            index = 4;
                            for (i = 0; i < reviewers.length; ++i) {
                                entries[index] = reviewers[i];
                                if (i < reviewers.length - 1) {
                                    int n = index;
                                    entries[n] = entries[n] + ", ";
                                }
                                entries[index + 1] = " ";
                                index += 2;
                            }
                            entries[index] = "\n";
                            entries[index + 1] = "\n";
                            index += 2;
                        }
                        entries[index] = "_";
                        entries[index + 1] = Messages.titleCase(Messages.get((Object)this, "translators", new Object[0]));
                        entries[index + 2] = "_";
                        entries[index + 3] = "\n";
                        index += 4;
                        for (i = 0; i < reviewers.length; ++i) {
                            entries[index] = reviewers[i];
                            if (i < reviewers.length - 1 || translators.length > 0) {
                                int n = index;
                                entries[n] = entries[n] + ", ";
                            }
                            entries[index + 1] = " ";
                            index += 2;
                        }
                        for (i = 0; i < translators.length; ++i) {
                            entries[index] = translators[i];
                            if (i < translators.length - 1) {
                                int n = index;
                                entries[n] = entries[n] + ", ";
                            }
                            entries[index + 1] = " ";
                            index += 2;
                        }
                        Window credits = new Window(0, 0, Chrome.get(Chrome.Type.TOAST));
                        int n = w = PixelScene.landscape() ? 120 : 80;
                        if (totalCredits >= 25) {
                            w = (int)((float)w * 1.5f);
                        }
                        RenderedTextBlock title = PixelScene.renderTextBlock(9);
                        title.text(Messages.titleCase(Messages.get((Object)this, "credits", new Object[0])), w);
                        title.hardlight(0xFFFF44);
                        title.setPos(((float)w - title.width()) / 2.0f, 0.0f);
                        credits.add((Gizmo)title);
                        RenderedTextBlock text = PixelScene.renderTextBlock(7);
                        text.maxWidth(w);
                        text.tokens(entries);
                        text.setPos(0.0f, title.bottom() + 4.0f);
                        credits.add((Gizmo)text);
                        credits.resize(w, (int)text.bottom() + 2);
                        ShatteredPixelDungeon.scene().addToFront((Gizmo)credits);
                    }
                };
                this.add((Gizmo)this.btnCredits);
            }
        }

        protected void layout() {
            this.title.setPos((this.width - this.title.width()) / 2.0f, this.y + 2.0f);
            this.sep1.size(this.width, 1.0f);
            this.sep1.y = this.title.bottom() + 4.0f;
            this.txtLangName.setPos((this.width - this.txtLangName.width()) / 2.0f, this.sep1.y + 1.0f + 2.0f);
            PixelScene.align(this.txtLangName);
            this.txtLangInfo.setPos(0.0f, this.txtLangName.bottom() + 4.0f);
            this.txtLangInfo.maxWidth((int)this.width);
            this.y = this.txtLangInfo.bottom() + 2.0f;
            int x = 0;
            this.sep2.size(this.width, 1.0f);
            this.sep2.y = this.y;
            this.y += 2.0f;
            int cols = PixelScene.landscape() ? 4 : 3;
            int btnWidth = (int)Math.floor((this.width - (float)(cols - 1)) / (float)cols);
            for (RedButton btn : this.lanBtns) {
                btn.setRect(x, this.y, btnWidth, 11.0f);
                btn.setPos(x, this.y);
                x += btnWidth + 1;
                if (!((float)(x + btnWidth) > this.width)) continue;
                x = 0;
                this.y += 12.0f;
            }
            if (x > 0) {
                this.y += 12.0f;
            }
            this.sep3.size(this.width, 1.0f);
            this.sep3.y = this.y;
            this.y += 2.0f;
            if (this.btnCredits != null) {
                this.btnCredits.setSize(this.btnCredits.reqWidth() + 2.0f, 16.0f);
                this.btnCredits.setPos(this.width - this.btnCredits.width(), this.y);
                this.txtTranifex.setPos(0.0f, this.y);
                this.txtTranifex.maxWidth((int)this.btnCredits.left());
                this.height = Math.max(this.btnCredits.bottom(), this.txtTranifex.bottom());
            } else {
                this.txtTranifex.setPos(0.0f, this.y);
                this.txtTranifex.maxWidth((int)this.width);
                this.height = this.txtTranifex.bottom();
            }
        }
    }

    private static class AudioTab
    extends Component {
        RenderedTextBlock title;
        ColorBlock sep1;
        OptionSlider optMusic;
        CheckBox chkMusicMute;
        ColorBlock sep2;
        OptionSlider optSFX;
        CheckBox chkMuteSFX;
        ColorBlock sep3;
        CheckBox chkIgnoreSilent;

        private AudioTab() {
        }

        protected void createChildren() {
            this.title = PixelScene.renderTextBlock(Messages.get((Object)this, "title", new Object[0]), 9);
            this.title.hardlight(0xFFFF44);
            this.add((Gizmo)this.title);
            this.sep1 = new ColorBlock(1.0f, 1.0f, -16777216);
            this.add((Gizmo)this.sep1);
            this.optMusic = new OptionSlider(Messages.get((Object)this, "music_vol", new Object[0]), "0", "10", 0, 10){

                @Override
                protected void onChange() {
                    SPDSettings.musicVol(this.getSelectedValue());
                }
            };
            this.optMusic.setSelectedValue(SPDSettings.musicVol());
            this.add((Gizmo)this.optMusic);
            this.chkMusicMute = new CheckBox(Messages.get((Object)this, "music_mute", new Object[0])){

                @Override
                protected void onClick() {
                    super.onClick();
                    SPDSettings.music(!this.checked());
                }
            };
            this.chkMusicMute.checked(!SPDSettings.music());
            this.add((Gizmo)this.chkMusicMute);
            this.sep2 = new ColorBlock(1.0f, 1.0f, -16777216);
            this.add((Gizmo)this.sep2);
            this.optSFX = new OptionSlider(Messages.get((Object)this, "sfx_vol", new Object[0]), "0", "10", 0, 10){

                @Override
                protected void onChange() {
                    SPDSettings.SFXVol(this.getSelectedValue());
                    if (Random.Int((int)100) == 0) {
                        Sample.INSTANCE.play((Object)"sounds/mimic.mp3");
                    } else {
                        Sample.INSTANCE.play(Random.oneOf((Object[])new String[]{"sounds/gold.mp3", "sounds/hit.mp3", "sounds/item.mp3", "sounds/shatter.mp3", "sounds/evoke.mp3", "sounds/secret.mp3"}));
                    }
                }
            };
            this.optSFX.setSelectedValue(SPDSettings.SFXVol());
            this.add((Gizmo)this.optSFX);
            this.chkMuteSFX = new CheckBox(Messages.get((Object)this, "sfx_mute", new Object[0])){

                @Override
                protected void onClick() {
                    super.onClick();
                    SPDSettings.soundFx(!this.checked());
                    Sample.INSTANCE.play((Object)"sounds/click.mp3");
                }
            };
            this.chkMuteSFX.checked(!SPDSettings.soundFx());
            this.add((Gizmo)this.chkMuteSFX);
            if (DeviceCompat.isiOS() && Messages.lang() == Languages.ENGLISH) {
                this.sep3 = new ColorBlock(1.0f, 1.0f, -16777216);
                this.add((Gizmo)this.sep3);
                this.chkIgnoreSilent = new CheckBox(Messages.get((Object)this, "ignore_silent", new Object[0])){

                    @Override
                    protected void onClick() {
                        super.onClick();
                        SPDSettings.ignoreSilentMode(this.checked());
                    }
                };
                this.chkIgnoreSilent.checked(SPDSettings.ignoreSilentMode());
                this.add((Gizmo)this.chkIgnoreSilent);
            }
        }

        protected void layout() {
            this.title.setPos((this.width - this.title.width()) / 2.0f, this.y + 2.0f);
            this.sep1.size(this.width, 1.0f);
            this.sep1.y = this.title.bottom() + 4.0f;
            if (this.width > 200.0f) {
                this.optMusic.setRect(0.0f, this.sep1.y + 1.0f + 2.0f, this.width / 2.0f - 1.0f, 24.0f);
                this.chkMusicMute.setRect(0.0f, this.optMusic.bottom() + 2.0f, this.width / 2.0f - 1.0f, 18.0f);
                this.sep2.size(this.width, 1.0f);
                this.sep2.y = this.sep1.y;
                this.optSFX.setRect(this.optMusic.right() + 2.0f, this.sep2.y + 1.0f + 2.0f, this.width / 2.0f - 1.0f, 24.0f);
                this.chkMuteSFX.setRect(this.chkMusicMute.right() + 2.0f, this.optSFX.bottom() + 2.0f, this.width / 2.0f - 1.0f, 18.0f);
            } else {
                this.optMusic.setRect(0.0f, this.sep1.y + 1.0f + 2.0f, this.width, 24.0f);
                this.chkMusicMute.setRect(0.0f, this.optMusic.bottom() + 2.0f, this.width, 18.0f);
                this.sep2.size(this.width, 1.0f);
                this.sep2.y = this.chkMusicMute.bottom() + 2.0f;
                this.optSFX.setRect(0.0f, this.sep2.y + 1.0f + 2.0f, this.width, 24.0f);
                this.chkMuteSFX.setRect(0.0f, this.optSFX.bottom() + 2.0f, this.width, 18.0f);
            }
            this.height = this.chkMuteSFX.bottom();
            if (this.chkIgnoreSilent != null) {
                this.sep3.size(this.width, 1.0f);
                this.sep3.y = this.chkMuteSFX.bottom() + 2.0f;
                this.chkIgnoreSilent.setRect(0.0f, this.sep3.y + 1.0f + 2.0f, this.width, 18.0f);
                this.height = this.chkIgnoreSilent.bottom();
            }
        }
    }

    private static class DataTab
    extends Component {
        RenderedTextBlock title;
        ColorBlock sep1;
        CheckBox chkNews;
        CheckBox chkUpdates;
        CheckBox chkBetas;
        CheckBox chkWifi;
        ColorBlock sep2;
        RedButton btnAnalytics;
        RedButton btnPlayGames;

        private DataTab() {
        }

        protected void createChildren() {
            this.title = PixelScene.renderTextBlock(Messages.get((Object)this, "title", new Object[0]), 9);
            this.title.hardlight(0xFFFF44);
            this.add((Gizmo)this.title);
            this.sep1 = new ColorBlock(1.0f, 1.0f, -16777216);
            this.add((Gizmo)this.sep1);
            this.chkNews = new CheckBox(Messages.get((Object)this, "news", new Object[0])){

                @Override
                protected void onClick() {
                    super.onClick();
                    SPDSettings.news(this.checked());
                    News.clearArticles();
                }
            };
            this.chkNews.checked(SPDSettings.news());
            this.add((Gizmo)this.chkNews);
            if (Updates.supportsUpdates() && Updates.isUpdateable()) {
                this.chkUpdates = new CheckBox(Messages.get((Object)this, "updates", new Object[0])){

                    @Override
                    protected void onClick() {
                        super.onClick();
                        SPDSettings.updates(this.checked());
                        Updates.clearUpdate();
                    }
                };
                this.chkUpdates.checked(SPDSettings.updates());
                this.add((Gizmo)this.chkUpdates);
                if (Updates.supportsBetaChannel()) {
                    this.chkBetas = new CheckBox(Messages.get((Object)this, "betas", new Object[0])){

                        @Override
                        protected void onClick() {
                            super.onClick();
                            SPDSettings.updates(this.checked());
                            Updates.clearUpdate();
                        }
                    };
                    this.chkBetas.checked(SPDSettings.betas());
                    this.add((Gizmo)this.chkBetas);
                }
            }
            if (!DeviceCompat.isDesktop()) {
                this.chkWifi = new CheckBox(Messages.get((Object)this, "wifi", new Object[0])){

                    @Override
                    protected void onClick() {
                        super.onClick();
                        SPDSettings.WiFi(this.checked());
                    }
                };
                this.chkWifi.checked(SPDSettings.WiFi());
                this.add((Gizmo)this.chkWifi);
            }
            if (Analytics.supportsAnalytics()) {
                this.sep2 = new ColorBlock(1.0f, 1.0f, -16777216);
                this.add((Gizmo)this.sep2);
                this.btnAnalytics = new RedButton(Messages.get((Object)this, "analytics", new Object[0])){

                    @Override
                    protected void onClick() {
                        ShatteredPixelDungeon.scene().addToFront((Gizmo)new WndAnalytics());
                    }
                };
                this.btnAnalytics.icon(Icons.get(Icons.STATS));
                if (SPDSettings.analytics()) {
                    this.btnAnalytics.icon().hardlight(1.0f, 1.5f, 0.67f);
                }
                this.add((Gizmo)this.btnAnalytics);
            }
            if (Sync.supportsSync() && !Sync.alwaysConnected()) {
                if (this.sep2 == null) {
                    this.sep2 = new ColorBlock(1.0f, 1.0f, -16777216);
                    this.add((Gizmo)this.sep2);
                }
                this.btnPlayGames = new RedButton(Messages.get((Object)this, "googleplaygames", new Object[0])){

                    @Override
                    protected void onClick() {
                        ShatteredPixelDungeon.scene().addToFront((Gizmo)new WndGooglePlayGames());
                    }
                };
                this.btnPlayGames.icon(Icons.get(Icons.CONTROLLER));
                if (SPDSettings.googlePlayGames()) {
                    this.btnPlayGames.icon().hardlight(1.0f, 1.5f, 0.67f);
                }
                this.add((Gizmo)this.btnPlayGames);
            }
        }

        protected void layout() {
            float pos;
            this.title.setPos((this.width - this.title.width()) / 2.0f, this.y + 2.0f);
            this.sep1.size(this.width, 1.0f);
            this.sep1.y = this.title.bottom() + 4.0f;
            if (this.width > 200.0f && this.chkUpdates != null) {
                this.chkNews.setRect(0.0f, this.sep1.y + 1.0f + 2.0f, this.width / 2.0f - 1.0f, 18.0f);
                this.chkUpdates.setRect(this.chkNews.right() + 2.0f, this.chkNews.top(), this.width / 2.0f - 1.0f, 18.0f);
                pos = this.chkUpdates.bottom();
            } else {
                this.chkNews.setRect(0.0f, this.sep1.y + 1.0f + 2.0f, this.width, 18.0f);
                pos = this.chkNews.bottom();
                if (this.chkUpdates != null) {
                    this.chkUpdates.setRect(0.0f, this.chkNews.bottom() + 2.0f, this.width, 18.0f);
                    pos = this.chkUpdates.bottom();
                }
            }
            if (this.chkBetas != null) {
                this.chkBetas.setRect(0.0f, pos + 2.0f, this.width, 18.0f);
                pos = this.chkBetas.bottom();
            }
            if (this.chkWifi != null) {
                this.chkWifi.setRect(0.0f, pos + 2.0f, this.width, 18.0f);
                pos = this.chkWifi.bottom();
            }
            if (this.sep2 != null) {
                this.sep2.size(this.width, 1.0f);
                this.sep2.y = pos + 2.0f;
                pos = this.sep2.y + 1.0f;
            }
            if (this.btnAnalytics != null) {
                this.btnAnalytics.setRect(0.0f, pos + 2.0f, this.width, 18.0f);
                pos = this.btnAnalytics.bottom();
            }
            if (this.btnPlayGames != null) {
                this.btnPlayGames.setRect(0.0f, pos + 2.0f, this.width, 18.0f);
                pos = this.btnPlayGames.bottom();
            }
            this.height = pos;
        }
    }

    private static class UITab
    extends Component {
        RenderedTextBlock title;
        ColorBlock sep1;
        OptionSlider optUISize;
        RenderedTextBlock barDesc;
        RedButton btnSplit;
        RedButton btnGrouped;
        RedButton btnCentered;
        CheckBox chkFlipToolbar;
        CheckBox chkFlipTags;
        ColorBlock sep2;
        CheckBox chkFont;
        ColorBlock sep3;
        RedButton btnKeyBindings;

        private UITab() {
        }

        protected void createChildren() {
            this.title = PixelScene.renderTextBlock(Messages.get((Object)this, "title", new Object[0]), 9);
            this.title.hardlight(0xFFFF44);
            this.add((Gizmo)this.title);
            this.sep1 = new ColorBlock(1.0f, 1.0f, -16777216);
            this.add((Gizmo)this.sep1);
            float wMin = (float)Game.width / 360.0f;
            float hMin = (float)Game.height / 200.0f;
            if (Math.min(wMin, hMin) >= 2.0f * Game.density) {
                this.optUISize = new OptionSlider(Messages.get((Object)this, "size", new Object[0]), Messages.get((Object)this, "mobile", new Object[0]), Messages.get((Object)this, "full", new Object[0]), 0, 2){

                    @Override
                    protected void onChange() {
                        SPDSettings.interfaceSize(this.getSelectedValue());
                        ShatteredPixelDungeon.seamlessResetScene();
                    }
                };
                this.optUISize.setSelectedValue(SPDSettings.interfaceSize());
                this.add((Gizmo)this.optUISize);
            }
            if (SPDSettings.interfaceSize() == 0) {
                this.barDesc = PixelScene.renderTextBlock(Messages.get((Object)this, "mode", new Object[0]), 9);
                this.add((Gizmo)this.barDesc);
                this.btnSplit = new RedButton(Messages.get((Object)this, "split", new Object[0])){

                    @Override
                    protected void onClick() {
                        this.textColor(0xFFFF44);
                        btnGrouped.textColor(0xFFFFFF);
                        btnCentered.textColor(0xFFFFFF);
                        SPDSettings.toolbarMode(Toolbar.Mode.SPLIT.name());
                        Toolbar.updateLayout();
                    }
                };
                if (SPDSettings.toolbarMode().equals(Toolbar.Mode.SPLIT.name())) {
                    this.btnSplit.textColor(0xFFFF44);
                }
                this.add((Gizmo)this.btnSplit);
                this.btnGrouped = new RedButton(Messages.get((Object)this, "group", new Object[0])){

                    @Override
                    protected void onClick() {
                        btnSplit.textColor(0xFFFFFF);
                        this.textColor(0xFFFF44);
                        btnCentered.textColor(0xFFFFFF);
                        SPDSettings.toolbarMode(Toolbar.Mode.GROUP.name());
                        Toolbar.updateLayout();
                    }
                };
                if (SPDSettings.toolbarMode().equals(Toolbar.Mode.GROUP.name())) {
                    this.btnGrouped.textColor(0xFFFF44);
                }
                this.add((Gizmo)this.btnGrouped);
                this.btnCentered = new RedButton(Messages.get((Object)this, "center", new Object[0])){

                    @Override
                    protected void onClick() {
                        btnSplit.textColor(0xFFFFFF);
                        btnGrouped.textColor(0xFFFFFF);
                        this.textColor(0xFFFF44);
                        SPDSettings.toolbarMode(Toolbar.Mode.CENTER.name());
                        Toolbar.updateLayout();
                    }
                };
                if (SPDSettings.toolbarMode().equals(Toolbar.Mode.CENTER.name())) {
                    this.btnCentered.textColor(0xFFFF44);
                }
                this.add((Gizmo)this.btnCentered);
                this.chkFlipToolbar = new CheckBox(Messages.get((Object)this, "flip_toolbar", new Object[0])){

                    @Override
                    protected void onClick() {
                        super.onClick();
                        SPDSettings.flipToolbar(this.checked());
                        Toolbar.updateLayout();
                    }
                };
                this.chkFlipToolbar.checked(SPDSettings.flipToolbar());
                this.add((Gizmo)this.chkFlipToolbar);
            }
            this.chkFlipTags = new CheckBox(Messages.get((Object)this, "flip_indicators", new Object[0])){

                @Override
                protected void onClick() {
                    super.onClick();
                    SPDSettings.flipTags(this.checked());
                    GameScene.layoutTags();
                }
            };
            this.chkFlipTags.checked(SPDSettings.flipTags());
            this.add((Gizmo)this.chkFlipTags);
            this.sep2 = new ColorBlock(1.0f, 1.0f, -16777216);
            this.add((Gizmo)this.sep2);
            this.chkFont = new CheckBox(Messages.get((Object)this, "system_font", new Object[0])){

                @Override
                protected void onClick() {
                    super.onClick();
                    ShatteredPixelDungeon.seamlessResetScene(new Game.SceneChangeCallback(){

                        public void beforeCreate() {
                            SPDSettings.systemFont(this.checked());
                        }

                        public void afterCreate() {
                        }
                    });
                }
            };
            this.chkFont.checked(SPDSettings.systemFont());
            this.add((Gizmo)this.chkFont);
            if (DeviceCompat.hasHardKeyboard()) {
                this.sep3 = new ColorBlock(1.0f, 1.0f, -16777216);
                this.add((Gizmo)this.sep3);
                this.btnKeyBindings = new RedButton(Messages.get((Object)this, "key_bindings", new Object[0])){

                    @Override
                    protected void onClick() {
                        super.onClick();
                        ShatteredPixelDungeon.scene().addToFront((Gizmo)new WndKeyBindings());
                    }
                };
                this.add((Gizmo)this.btnKeyBindings);
            }
        }

        protected void layout() {
            this.title.setPos((this.width - this.title.width()) / 2.0f, this.y + 2.0f);
            this.sep1.size(this.width, 1.0f);
            this.sep1.y = this.title.bottom() + 4.0f;
            this.height = this.sep1.y + 1.0f;
            if (this.optUISize != null) {
                this.optUISize.setRect(0.0f, this.height + 2.0f, this.width, 24.0f);
                this.height = this.optUISize.bottom();
            }
            if (this.barDesc != null) {
                this.barDesc.setPos((this.width - this.barDesc.width()) / 2.0f, this.height + 2.0f);
                PixelScene.align(this.barDesc);
                int btnWidth = (int)(this.width - 4.0f) / 3;
                this.btnSplit.setRect(0.0f, this.barDesc.bottom() + 2.0f, btnWidth, 16.0f);
                this.btnGrouped.setRect(this.btnSplit.right() + 2.0f, this.btnSplit.top(), btnWidth, 16.0f);
                this.btnCentered.setRect(this.btnGrouped.right() + 2.0f, this.btnSplit.top(), btnWidth, 16.0f);
                if (this.width > 200.0f) {
                    this.chkFlipToolbar.setRect(0.0f, this.btnGrouped.bottom() + 2.0f, this.width / 2.0f - 1.0f, 18.0f);
                    this.chkFlipTags.setRect(this.chkFlipToolbar.right() + 2.0f, this.chkFlipToolbar.top(), this.width / 2.0f - 1.0f, 18.0f);
                } else {
                    this.chkFlipToolbar.setRect(0.0f, this.btnGrouped.bottom() + 2.0f, this.width, 18.0f);
                    this.chkFlipTags.setRect(0.0f, this.chkFlipToolbar.bottom() + 2.0f, this.width, 18.0f);
                }
            } else {
                this.chkFlipTags.setRect(0.0f, this.height + 2.0f, this.width, 18.0f);
            }
            this.sep2.size(this.width, 1.0f);
            this.sep2.y = this.chkFlipTags.bottom() + 2.0f;
            this.chkFont.setRect(0.0f, this.sep2.y + 1.0f + 2.0f, this.width, 18.0f);
            if (this.btnKeyBindings != null) {
                if (this.width > 200.0f) {
                    this.chkFont.setSize(this.width / 2.0f - 1.0f, 18.0f);
                    this.sep3.size(1.0f, 22.0f);
                    this.sep3.x = this.chkFont.right() + 0.5f;
                    this.sep3.y = this.sep2.y + 1.0f;
                    PixelScene.align((Visual)this.sep3);
                    this.btnKeyBindings.setRect(this.chkFont.right() + 2.0f, this.chkFont.top(), this.width / 2.0f - 1.0f, 18.0f);
                } else {
                    this.sep3.size(this.width, 1.0f);
                    this.sep3.y = this.chkFont.bottom() + 2.0f;
                    this.btnKeyBindings.setRect(0.0f, this.sep3.y + 1.0f + 2.0f, this.width, 18.0f);
                }
                this.height = this.btnKeyBindings.bottom();
            } else {
                this.height = this.chkFont.bottom();
            }
        }
    }

    private static class DisplayTab
    extends Component {
        RenderedTextBlock title;
        ColorBlock sep1;
        CheckBox chkFullscreen;
        OptionSlider optScale;
        CheckBox chkSaver;
        RedButton btnOrientation;
        ColorBlock sep2;
        OptionSlider optBrightness;
        OptionSlider optVisGrid;

        private DisplayTab() {
        }

        protected void createChildren() {
            this.title = PixelScene.renderTextBlock(Messages.get((Object)this, "title", new Object[0]), 9);
            this.title.hardlight(0xFFFF44);
            this.add((Gizmo)this.title);
            this.sep1 = new ColorBlock(1.0f, 1.0f, -16777216);
            this.add((Gizmo)this.sep1);
            this.chkFullscreen = new CheckBox(Messages.get((Object)this, "fullscreen", new Object[0])){

                @Override
                protected void onClick() {
                    super.onClick();
                    SPDSettings.fullscreen(this.checked());
                }
            };
            if (DeviceCompat.supportsFullScreen()) {
                this.chkFullscreen.checked(SPDSettings.fullscreen());
            } else {
                this.chkFullscreen.checked(true);
                this.chkFullscreen.enable(false);
            }
            this.add((Gizmo)this.chkFullscreen);
            if ((int)Math.ceil(2.0f * Game.density) < PixelScene.maxDefaultZoom) {
                this.optScale = new OptionSlider(Messages.get((Object)this, "scale", new Object[0]), (int)Math.ceil(2.0f * Game.density) + "X", PixelScene.maxDefaultZoom + "X", (int)Math.ceil(2.0f * Game.density), PixelScene.maxDefaultZoom){

                    @Override
                    protected void onChange() {
                        if (this.getSelectedValue() != SPDSettings.scale()) {
                            SPDSettings.scale(this.getSelectedValue());
                            ShatteredPixelDungeon.seamlessResetScene();
                        }
                    }
                };
                this.optScale.setSelectedValue(PixelScene.defaultZoom);
                this.add((Gizmo)this.optScale);
            }
            if (DeviceCompat.isAndroid() && PixelScene.maxScreenZoom >= 2) {
                this.chkSaver = new CheckBox(Messages.get((Object)this, "saver", new Object[0])){

                    @Override
                    protected void onClick() {
                        super.onClick();
                        if (this.checked()) {
                            this.checked(!this.checked());
                            ShatteredPixelDungeon.scene().add((Gizmo)new WndOptions(Icons.get(Icons.DISPLAY), Messages.get(DisplayTab.class, "saver", new Object[0]), Messages.get(DisplayTab.class, "saver_desc", new Object[0]), new String[]{Messages.get(DisplayTab.class, "okay", new Object[0]), Messages.get(DisplayTab.class, "cancel", new Object[0])}){

                                @Override
                                protected void onSelect(int index) {
                                    if (index == 0) {
                                        this.checked(!this.checked());
                                        SPDSettings.powerSaver(this.checked());
                                    }
                                }
                            });
                        } else {
                            SPDSettings.powerSaver(this.checked());
                        }
                    }
                };
                this.chkSaver.checked(SPDSettings.powerSaver());
                this.add((Gizmo)this.chkSaver);
            }
            if (DeviceCompat.isAndroid()) {
                Boolean finalLandscape;
                Boolean landscape = SPDSettings.landscape();
                if (landscape == null) {
                    landscape = Game.width > Game.height;
                }
                this.btnOrientation = new RedButton((finalLandscape = landscape) != false ? Messages.get((Object)this, "portrait", new Object[0]) : Messages.get((Object)this, "landscape", new Object[0])){

                    @Override
                    protected void onClick() {
                        SPDSettings.landscape(finalLandscape == false);
                    }
                };
                this.add((Gizmo)this.btnOrientation);
            }
            this.sep2 = new ColorBlock(1.0f, 1.0f, -16777216);
            this.add((Gizmo)this.sep2);
            this.optBrightness = new OptionSlider(Messages.get((Object)this, "brightness", new Object[0]), Messages.get((Object)this, "dark", new Object[0]), Messages.get((Object)this, "bright", new Object[0]), -1, 1){

                @Override
                protected void onChange() {
                    SPDSettings.brightness(this.getSelectedValue());
                }
            };
            this.optBrightness.setSelectedValue(SPDSettings.brightness());
            this.add((Gizmo)this.optBrightness);
            this.optVisGrid = new OptionSlider(Messages.get((Object)this, "visual_grid", new Object[0]), Messages.get((Object)this, "off", new Object[0]), Messages.get((Object)this, "high", new Object[0]), -1, 2){

                @Override
                protected void onChange() {
                    SPDSettings.visualGrid(this.getSelectedValue());
                }
            };
            this.optVisGrid.setSelectedValue(SPDSettings.visualGrid());
            this.add((Gizmo)this.optVisGrid);
        }

        protected void layout() {
            float bottom = this.y;
            this.title.setPos((this.width - this.title.width()) / 2.0f, bottom + 2.0f);
            this.sep1.size(this.width, 1.0f);
            this.sep1.y = this.title.bottom() + 4.0f;
            bottom = this.sep1.y + 1.0f;
            if (this.width > 200.0f && this.chkSaver != null) {
                this.chkFullscreen.setRect(0.0f, bottom + 2.0f, this.width / 2.0f - 1.0f, 18.0f);
                this.chkSaver.setRect(this.chkFullscreen.right() + 2.0f, bottom + 2.0f, this.width / 2.0f - 1.0f, 18.0f);
                bottom = this.chkFullscreen.bottom();
            } else {
                this.chkFullscreen.setRect(0.0f, bottom + 2.0f, this.width, 18.0f);
                bottom = this.chkFullscreen.bottom();
                if (this.chkSaver != null) {
                    this.chkSaver.setRect(0.0f, bottom + 2.0f, this.width, 18.0f);
                    bottom = this.chkSaver.bottom();
                }
            }
            if (this.btnOrientation != null) {
                this.btnOrientation.setRect(0.0f, bottom + 2.0f, this.width, 18.0f);
                bottom = this.btnOrientation.bottom();
            }
            if (this.optScale != null) {
                this.optScale.setRect(0.0f, bottom + 2.0f, this.width, 24.0f);
                bottom = this.optScale.bottom();
            }
            this.sep2.size(this.width, 1.0f);
            this.sep2.y = bottom + 2.0f;
            bottom = this.sep2.y + 1.0f;
            if (this.width > 200.0f) {
                this.optBrightness.setRect(0.0f, bottom + 2.0f, this.width / 2.0f - 1.0f, 24.0f);
                this.optVisGrid.setRect(this.optBrightness.right() + 2.0f, this.optBrightness.top(), this.width / 2.0f - 1.0f, 24.0f);
            } else {
                this.optBrightness.setRect(0.0f, bottom + 2.0f, this.width, 24.0f);
                this.optVisGrid.setRect(0.0f, this.optBrightness.bottom() + 2.0f, this.width, 24.0f);
            }
            this.height = this.optVisGrid.bottom();
        }
    }
}

