/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.windows;

import com.shatteredpixel.shatteredpixeldungeon.Badges;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.GamesInProgress;
import com.shatteredpixel.shatteredpixeldungeon.SPDSettings;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroClass;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroSubClass;
import com.shatteredpixel.shatteredpixeldungeon.journal.Journal;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.InterlevelScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.IntroScene;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.services.payment.Payment;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.ui.ActionIndicator;
import com.shatteredpixel.shatteredpixeldungeon.ui.Button;
import com.shatteredpixel.shatteredpixeldungeon.ui.IconButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.Icons;
import com.shatteredpixel.shatteredpixeldungeon.ui.RedButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenameButton;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.ui.Window;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndChallenges;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndMessage;
import com.watabou.noosa.ColorBlock;
import com.watabou.noosa.Game;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.Image;
import com.watabou.noosa.Visual;
import com.watabou.noosa.ui.Component;
import com.watabou.utils.DeviceCompat;

public class WndStartGame
extends Window {
    private static final int WIDTH = 120;
    private static final int HEIGHT = 140;

    public WndStartGame(final int slot) {
        float heroBtnSpacing;
        Badges.loadGlobal();
        Journal.loadGlobal();
        RenderedTextBlock title = PixelScene.renderTextBlock(Messages.get((Object)this, "title", new Object[0]), 12);
        title.hardlight(0xFFFF44);
        title.setPos((120.0f - title.width()) / 2.0f, 3.0f);
        PixelScene.align(title);
        this.add((Gizmo)title);
        float curX = heroBtnSpacing = 4.8f;
        for (HeroClass cl : HeroClass.values()) {
            HeroBtn button = new HeroBtn(cl);
            button.setRect(curX, title.height() + 7.0f, 24.0f, 16.0f);
            curX += 24.0f + heroBtnSpacing;
            this.add((Gizmo)button);
        }
        ColorBlock separator = new ColorBlock(1.0f, 1.0f, -14540254);
        separator.size(120.0f, 1.0f);
        separator.x = 0.0f;
        separator.y = title.bottom() + 6.0f + 16.0f;
        this.add((Gizmo)separator);
        HeroPane ava = new HeroPane();
        ava.setRect(20.0f, separator.y + 2.0f, 90.0f, 80.0f);
        this.add((Gizmo)ava);
        RedButton start = new RedButton(Messages.get((Object)this, "start", new Object[0])){

            @Override
            protected void onClick() {
                if (GamesInProgress.selectedClass == null) {
                    return;
                }
                super.onClick();
                GamesInProgress.curSlot = slot;
                Dungeon.hero = null;
                ActionIndicator.action = null;
                InterlevelScene.mode = InterlevelScene.Mode.DESCEND;
                if (SPDSettings.intro()) {
                    SPDSettings.intro(false);
                    Game.switchScene(IntroScene.class);
                } else {
                    Game.switchScene(InterlevelScene.class);
                }
            }

            @Override
            public void update() {
                if (!this.visible && GamesInProgress.selectedClass != null) {
                    this.visible = true;
                }
                super.update();
            }
        };
        start.visible = false;
        start.setRect(0.0f, 120.0f, 120.0f, 20.0f);
        this.add((Gizmo)start);
        if (DeviceCompat.isDebug() || Badges.isUnlocked(Badges.Badge.VICTORY)) {
            IconButton challengeButton = new IconButton(Icons.get(SPDSettings.challenges() > 0 ? Icons.CHALLENGE_ON : Icons.CHALLENGE_OFF)){

                @Override
                protected void onClick() {
                    ShatteredPixelDungeon.scene().addToFront((Gizmo)new WndChallenges(SPDSettings.challenges(), true){

                        @Override
                        public void onBackPressed() {
                            super.onBackPressed();
                            if (this.parent != null) {
                                this.icon(Icons.get(SPDSettings.challenges() > 0 ? Icons.CHALLENGE_ON : Icons.CHALLENGE_OFF));
                            }
                        }
                    });
                }

                @Override
                public void update() {
                    if (!this.visible && GamesInProgress.selectedClass != null) {
                        this.visible = true;
                    }
                    super.update();
                }
            };
            challengeButton.setRect(100.0f, 120.0f, 20.0f, 20.0f);
            challengeButton.visible = false;
            this.add((Gizmo)challengeButton);
        } else {
            Dungeon.challenges = 0;
            SPDSettings.challenges(0);
        }
        if (Payment.isTierUnlocked(2)) {
            RenameButton rename = new RenameButton(){

                @Override
                public void update() {
                    super.update();
                    if (!this.visible && GamesInProgress.selectedClass != null) {
                        this.visible = true;
                    }
                }
            };
            rename.setRect(0.0f, 120.0f, 20.0f, 20.0f);
            this.add((Gizmo)rename);
            rename.visible = false;
        }
        this.resize(120, 140);
    }

    private class HeroPane
    extends Component {
        private HeroClass cl;
        private Image avatar;
        private IconButton heroItem;
        private IconButton heroLoadout;
        private IconButton heroMisc;
        private IconButton heroSubclass;
        private RenderedTextBlock name;
        private static final int BTN_SIZE = 20;

        private HeroPane() {
        }

        protected void createChildren() {
            super.createChildren();
            this.avatar = new Image((Object)"sprites/avatars.png");
            this.avatar.scale.set(2.0f);
            this.add((Gizmo)this.avatar);
            this.heroItem = new IconButton(){

                @Override
                protected void onClick() {
                    if (HeroPane.this.cl == null) {
                        return;
                    }
                    ShatteredPixelDungeon.scene().addToFront((Gizmo)new WndMessage(Messages.get((Object)HeroPane.this.cl, HeroPane.this.cl.name() + "_desc_item", new Object[0])));
                }
            };
            this.heroItem.setSize(20.0f, 20.0f);
            this.add((Gizmo)this.heroItem);
            this.heroLoadout = new IconButton(){

                @Override
                protected void onClick() {
                    if (HeroPane.this.cl == null) {
                        return;
                    }
                    ShatteredPixelDungeon.scene().addToFront((Gizmo)new WndMessage(Messages.get((Object)HeroPane.this.cl, HeroPane.this.cl.name() + "_desc_loadout", new Object[0])));
                }
            };
            this.heroLoadout.setSize(20.0f, 20.0f);
            this.add((Gizmo)this.heroLoadout);
            this.heroMisc = new IconButton(){

                @Override
                protected void onClick() {
                    if (HeroPane.this.cl == null) {
                        return;
                    }
                    ShatteredPixelDungeon.scene().addToFront((Gizmo)new WndMessage(Messages.get((Object)HeroPane.this.cl, HeroPane.this.cl.name() + "_desc_misc", new Object[0])));
                }
            };
            this.heroMisc.setSize(20.0f, 20.0f);
            this.add((Gizmo)this.heroMisc);
            this.heroSubclass = new IconButton((Image)new ItemSprite(ItemSpriteSheet.MASTERY, null)){

                @Override
                protected void onClick() {
                    if (HeroPane.this.cl == null) {
                        return;
                    }
                    String msg = Messages.get((Object)HeroPane.this.cl, HeroPane.this.cl.name() + "_desc_subclasses", new Object[0]);
                    for (HeroSubClass sub : HeroPane.this.cl.subClasses()) {
                        msg = msg + "\n\n" + sub.shortDesc();
                    }
                    ShatteredPixelDungeon.scene().addToFront((Gizmo)new WndMessage(msg));
                }
            };
            this.heroSubclass.setSize(20.0f, 20.0f);
            this.add((Gizmo)this.heroSubclass);
            this.name = PixelScene.renderTextBlock(12);
            this.add((Gizmo)this.name);
            this.visible = false;
        }

        protected void layout() {
            super.layout();
            this.avatar.x = this.x;
            this.avatar.y = this.y + (this.height - this.avatar.height() - this.name.height() - 4.0f) / 2.0f;
            PixelScene.align((Visual)this.avatar);
            this.name.setPos(this.x + (this.avatar.width() - this.name.width()) / 2.0f, this.avatar.y + this.avatar.height() + 3.0f);
            PixelScene.align(this.name);
            this.heroItem.setPos(this.x + this.width - 20.0f, this.y);
            this.heroLoadout.setPos(this.x + this.width - 20.0f, this.heroItem.bottom());
            this.heroMisc.setPos(this.x + this.width - 20.0f, this.heroLoadout.bottom());
            this.heroSubclass.setPos(this.x + this.width - 20.0f, this.heroMisc.bottom());
        }

        public synchronized void update() {
            super.update();
            if (GamesInProgress.selectedClass != this.cl) {
                this.cl = GamesInProgress.selectedClass;
                if (this.cl != null) {
                    this.avatar.frame(this.cl.ordinal() * 24, 0, 24, 32);
                    this.name.text(Messages.capitalize(this.cl.title()));
                    switch (this.cl) {
                        case WARRIOR: {
                            this.heroItem.icon((Image)new ItemSprite(ItemSpriteSheet.SEAL, null));
                            this.heroLoadout.icon((Image)new ItemSprite(ItemSpriteSheet.WORN_SHORTSWORD, null));
                            this.heroMisc.icon((Image)new ItemSprite(ItemSpriteSheet.RATION, null));
                            break;
                        }
                        case MAGE: {
                            this.heroItem.icon((Image)new ItemSprite(ItemSpriteSheet.MAGES_STAFF, null));
                            this.heroLoadout.icon((Image)new ItemSprite(ItemSpriteSheet.HOLDER, null));
                            this.heroMisc.icon((Image)new ItemSprite(ItemSpriteSheet.WAND_MAGIC_MISSILE, null));
                            break;
                        }
                        case ROGUE: {
                            this.heroItem.icon((Image)new ItemSprite(ItemSpriteSheet.ARTIFACT_CLOAK, null));
                            this.heroLoadout.icon((Image)new ItemSprite(ItemSpriteSheet.DAGGER, null));
                            this.heroMisc.icon(Icons.get(Icons.STAIRS));
                            break;
                        }
                        case HUNTRESS: {
                            this.heroItem.icon((Image)new ItemSprite(ItemSpriteSheet.SPIRIT_BOW, null));
                            this.heroLoadout.icon((Image)new ItemSprite(ItemSpriteSheet.GLOVES, null));
                            this.heroMisc.icon(new Image((Object)"environment/tiles_sewers.png", 112, 96, 16, 16));
                        }
                    }
                    this.layout();
                    this.visible = true;
                } else {
                    this.visible = false;
                }
            }
        }
    }

    private static class HeroBtn
    extends Button {
        private HeroClass cl;
        private Image hero;
        private static final int WIDTH = 24;
        private static final int HEIGHT = 16;

        HeroBtn(HeroClass cl) {
            this.cl = cl;
            this.hero = new Image((Object)cl.spritesheet(), 0, 90, 12, 15);
            this.add((Gizmo)this.hero);
        }

        @Override
        protected void layout() {
            super.layout();
            if (this.hero != null) {
                this.hero.x = this.x + (this.width - this.hero.width()) / 2.0f;
                this.hero.y = this.y + (this.height - this.hero.height()) / 2.0f;
                PixelScene.align((Visual)this.hero);
            }
        }

        @Override
        public void update() {
            super.update();
            if (this.cl != GamesInProgress.selectedClass) {
                if (!this.cl.isUnlocked()) {
                    this.hero.brightness(0.3f);
                } else {
                    this.hero.brightness(0.6f);
                }
            } else {
                this.hero.brightness(1.0f);
            }
        }

        @Override
        protected void onClick() {
            super.onClick();
            if (!this.cl.isUnlocked()) {
                ShatteredPixelDungeon.scene().addToFront((Gizmo)new WndMessage(this.cl.unlockMsg()));
            } else {
                GamesInProgress.selectedClass = this.cl;
            }
        }
    }
}

