/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.windows;

import com.shatteredpixel.shatteredpixeldungeon.Chrome;
import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.ui.RenderedTextBlock;
import com.shatteredpixel.shatteredpixeldungeon.ui.Window;
import com.shatteredpixel.shatteredpixeldungeon.windows.IconTitle;
import com.watabou.input.PointerEvent;
import com.watabou.noosa.Game;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.Image;
import com.watabou.noosa.PointerArea;
import com.watabou.utils.SparseArray;

public class WndStory
extends Window {
    private static final int WIDTH_P = 125;
    private static final int WIDTH_L = 160;
    private static final int MARGIN = 2;
    private static final float bgR = 0.77f;
    private static final float bgG = 0.73f;
    private static final float bgB = 0.62f;
    public static final int ID_SEWERS = 0;
    public static final int ID_PRISON = 1;
    public static final int ID_CAVES = 2;
    public static final int ID_CITY = 3;
    public static final int ID_HALLS = 4;
    private static final SparseArray<String> CHAPTERS = new SparseArray();
    private IconTitle ttl;
    private RenderedTextBlock tf;
    private float delay;

    public WndStory(String text) {
        this(null, null, text);
    }

    public WndStory(Image icon, String title, String text) {
        super(0, 0, Chrome.get(Chrome.Type.SCROLL));
        int width = PixelScene.landscape() ? 156 : 121;
        float y = 2.0f;
        if (icon != null && title != null) {
            this.ttl = new IconTitle(icon, title);
            this.ttl.setRect(2.0f, y, width - 4, 0.0f);
            y = this.ttl.bottom() + 2.0f;
            this.add((Gizmo)this.ttl);
            this.ttl.tfLabel.invert();
        }
        this.tf = PixelScene.renderTextBlock(text, 6);
        this.tf.maxWidth(width);
        this.tf.invert();
        this.tf.setPos(2.0f, y);
        this.add((Gizmo)this.tf);
        PointerArea blocker = new PointerArea(0.0f, 0.0f, PixelScene.uiCamera.width, PixelScene.uiCamera.height){

            protected void onClick(PointerEvent event) {
                WndStory.this.onBackPressed();
            }
        };
        blocker.camera = PixelScene.uiCamera;
        this.add((Gizmo)blocker);
        this.resize((int)(this.tf.width() + 4.0f), (int)Math.min(this.tf.bottom() + 2.0f, 180.0f));
    }

    public void update() {
        super.update();
        if (this.delay > 0.0f) {
            float f;
            this.delay -= Game.elapsed;
            if (f <= 0.0f) {
                this.tf.visible = true;
                this.chrome.visible = true;
                this.shadow.visible = true;
                if (this.ttl != null) {
                    this.ttl.visible = true;
                }
            }
        }
    }

    public static void showChapter(int id) {
        if (Dungeon.chapters.contains(id)) {
            return;
        }
        String text = Messages.get(WndStory.class, (String)CHAPTERS.get(id), new Object[0]);
        if (text != null) {
            WndStory wnd = new WndStory(text);
            wnd.delay = 0.6f;
            if (0.6f > 0.0f) {
                wnd.tf.visible = false;
                wnd.chrome.visible = false;
                wnd.shadow.visible = false;
                if (wnd.ttl != null) {
                    wnd.ttl.visible = false;
                }
            }
            Game.scene().add((Gizmo)wnd);
            Dungeon.chapters.add(id);
        }
    }

    static {
        CHAPTERS.put(0, (Object)"sewers");
        CHAPTERS.put(1, (Object)"prison");
        CHAPTERS.put(2, (Object)"caves");
        CHAPTERS.put(3, (Object)"city");
        CHAPTERS.put(4, (Object)"halls");
    }
}

