/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon.windows;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.Mob;
import com.shatteredpixel.shatteredpixeldungeon.actors.mobs.npcs.Shopkeeper;
import com.shatteredpixel.shatteredpixeldungeon.items.EquipableItem;
import com.shatteredpixel.shatteredpixeldungeon.items.Gold;
import com.shatteredpixel.shatteredpixeldungeon.items.Heap;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.MasterThievesArmband;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSprite;
import com.shatteredpixel.shatteredpixeldungeon.sprites.ItemSpriteSheet;
import com.shatteredpixel.shatteredpixeldungeon.ui.RedButton;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndBag;
import com.shatteredpixel.shatteredpixeldungeon.windows.WndInfoItem;
import com.watabou.noosa.Gizmo;
import com.watabou.noosa.Image;

public class WndTradeItem
extends WndInfoItem {
    private static final float GAP = 2.0f;
    private static final int BTN_HEIGHT = 18;
    private WndBag owner;
    private boolean selling = false;

    public WndTradeItem(final Item item, WndBag owner) {
        super(item);
        this.selling = true;
        this.owner = owner;
        float pos = this.height;
        if (item.quantity() == 1) {
            RedButton btnSell = new RedButton(Messages.get((Object)this, "sell", item.value())){

                @Override
                protected void onClick() {
                    WndTradeItem.sell(item);
                    WndTradeItem.this.hide();
                }
            };
            btnSell.setRect(0.0f, pos + 2.0f, this.width, 18.0f);
            btnSell.icon((Image)new ItemSprite(ItemSpriteSheet.GOLD));
            this.add((Gizmo)btnSell);
            pos = btnSell.bottom();
        } else {
            int priceAll = item.value();
            RedButton btnSell1 = new RedButton(Messages.get((Object)this, "sell_1", priceAll / item.quantity())){

                @Override
                protected void onClick() {
                    WndTradeItem.sellOne(item);
                    WndTradeItem.this.hide();
                }
            };
            btnSell1.setRect(0.0f, pos + 2.0f, this.width, 18.0f);
            btnSell1.icon((Image)new ItemSprite(ItemSpriteSheet.GOLD));
            this.add((Gizmo)btnSell1);
            RedButton btnSellAll = new RedButton(Messages.get((Object)this, "sell_all", priceAll)){

                @Override
                protected void onClick() {
                    WndTradeItem.sell(item);
                    WndTradeItem.this.hide();
                }
            };
            btnSellAll.setRect(0.0f, btnSell1.bottom() + 1.0f, this.width, 18.0f);
            btnSellAll.icon((Image)new ItemSprite(ItemSpriteSheet.GOLD));
            this.add((Gizmo)btnSellAll);
            pos = btnSellAll.bottom();
        }
        this.resize(this.width, (int)pos);
    }

    public WndTradeItem(final Heap heap) {
        super(heap);
        this.selling = false;
        final Item item = heap.peek();
        float pos = this.height;
        int price = Shopkeeper.sellPrice(item);
        RedButton btnBuy = new RedButton(Messages.get((Object)this, "buy", price)){

            @Override
            protected void onClick() {
                WndTradeItem.this.hide();
                WndTradeItem.this.buy(heap);
            }
        };
        btnBuy.setRect(0.0f, pos + 2.0f, this.width, 18.0f);
        btnBuy.icon((Image)new ItemSprite(ItemSpriteSheet.GOLD));
        btnBuy.enable(price <= Dungeon.gold);
        this.add((Gizmo)btnBuy);
        pos = btnBuy.bottom();
        final MasterThievesArmband.Thievery thievery = Dungeon.hero.buff(MasterThievesArmband.Thievery.class);
        if (thievery != null && !thievery.isCursed() && thievery.chargesToUse(item) > 0) {
            float chance = thievery.stealChance(item);
            int chargesToUse = thievery.chargesToUse(item);
            RedButton btnSteal = new RedButton(Messages.get((Object)this, "steal", Math.min(100, (int)(chance * 100.0f)), chargesToUse), 6){

                @Override
                protected void onClick() {
                    if (thievery.steal(item)) {
                        Hero hero = Dungeon.hero;
                        Item item2 = heap.pickUp();
                        WndTradeItem.this.hide();
                        if (!item2.doPickUp(hero)) {
                            Dungeon.level.drop((Item)item2, (int)heap.pos).sprite.drop();
                        }
                    } else {
                        for (Mob mob : Dungeon.level.mobs) {
                            if (!(mob instanceof Shopkeeper)) continue;
                            mob.yell(Messages.get(mob, "thief", new Object[0]));
                            ((Shopkeeper)mob).flee();
                            break;
                        }
                        WndTradeItem.this.hide();
                    }
                }
            };
            btnSteal.setRect(0.0f, pos + 1.0f, this.width, 18.0f);
            btnSteal.icon((Image)new ItemSprite(ItemSpriteSheet.ARTIFACT_ARMBAND));
            this.add((Gizmo)btnSteal);
            pos = btnSteal.bottom();
        }
        this.resize(this.width, (int)pos);
    }

    @Override
    public void hide() {
        super.hide();
        if (this.owner != null) {
            this.owner.hide();
        }
        if (this.selling) {
            Shopkeeper.sell();
        }
    }

    public static void sell(Item item) {
        Hero hero = Dungeon.hero;
        if (item.isEquipped(hero) && !((EquipableItem)item).doUnequip(hero, false)) {
            return;
        }
        item.detachAll(hero.belongings.backpack);
        hero.spend(-hero.cooldown());
        new Gold(item.value()).doPickUp(hero);
    }

    public static void sellOne(Item item) {
        if (item.quantity() <= 1) {
            WndTradeItem.sell(item);
        } else {
            Hero hero = Dungeon.hero;
            item = item.detach(hero.belongings.backpack);
            hero.spend(-hero.cooldown());
            new Gold(item.value()).doPickUp(hero);
        }
    }

    private void buy(Heap heap) {
        Item item = heap.pickUp();
        if (item == null) {
            return;
        }
        int price = Shopkeeper.sellPrice(item);
        Dungeon.gold -= price;
        if (!item.doPickUp(Dungeon.hero)) {
            Dungeon.level.drop((Item)item, (int)heap.pos).sprite.drop();
        }
    }
}

