/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.input;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.ControllerMapping;
import com.watabou.input.KeyEvent;
import com.watabou.utils.DeviceCompat;
import com.watabou.utils.PointF;

public class ControllerHandler
implements ControllerListener {
    public static ControllerType lastUsedType = ControllerType.OTHER;
    public static PointF leftStickPosition = new PointF();
    public static PointF rightStickPosition = new PointF();
    private float L2Trigger = 0.0f;
    private float R2Trigger = 0.0f;
    private static boolean controllerPointerActive = false;

    private static void setControllerType(Controller controller) {
        lastUsedType = controller.getName().contains("Xbox") ? ControllerType.XBOX : (controller.getName().contains("PS") ? ControllerType.PLAYSTATION : (controller.getName().contains("Nintendo") ? ControllerType.NINTENDO : ControllerType.OTHER));
    }

    public static boolean controllersSupported() {
        return !DeviceCompat.isAndroid() || Gdx.app.getVersion() >= 16;
    }

    public void connected(Controller controller) {
        ControllerHandler.setControllerType(controller);
    }

    public void disconnected(Controller controller) {
    }

    public boolean buttonDown(Controller controller, int buttonCode) {
        ControllerHandler.setControllerType(controller);
        int keyCode = ControllerHandler.buttonToKey(controller, buttonCode);
        if (keyCode != 0) {
            KeyEvent.addKeyEvent(new KeyEvent(keyCode, true));
            return true;
        }
        return false;
    }

    public boolean buttonUp(Controller controller, int buttonCode) {
        ControllerHandler.setControllerType(controller);
        int keyCode = ControllerHandler.buttonToKey(controller, buttonCode);
        if (keyCode != 0) {
            KeyEvent.addKeyEvent(new KeyEvent(keyCode, false));
            return true;
        }
        return false;
    }

    public boolean axisMoved(Controller controller, int axisCode, float value) {
        ControllerHandler.setControllerType(controller);
        ControllerMapping mapping = controller.getMapping();
        if (mapping.axisRightX == axisCode) {
            ControllerHandler.rightStickPosition.x = value;
        } else if (mapping.axisRightY == axisCode) {
            ControllerHandler.rightStickPosition.y = value;
        } else if (mapping.axisLeftX == axisCode) {
            ControllerHandler.leftStickPosition.x = value;
        } else if (mapping.axisLeftY == axisCode) {
            ControllerHandler.leftStickPosition.y = value;
        } else if (axisCode == 4) {
            if (this.L2Trigger < 0.5f && value >= 0.5f) {
                KeyEvent.addKeyEvent(new KeyEvent(104, true));
            } else if (this.L2Trigger >= 0.5f && value < 0.5f) {
                KeyEvent.addKeyEvent(new KeyEvent(104, false));
            }
            this.L2Trigger = value;
        } else if (axisCode == 5) {
            if (this.R2Trigger < 0.5f && value >= 0.5f) {
                KeyEvent.addKeyEvent(new KeyEvent(105, true));
            } else if (this.R2Trigger >= 0.5f && value < 0.5f) {
                KeyEvent.addKeyEvent(new KeyEvent(105, false));
            }
            this.R2Trigger = value;
        }
        return true;
    }

    public static void setControllerPointer(boolean active) {
        Gdx.input.setCursorCatched(active);
        controllerPointerActive = active;
    }

    public static boolean controllerPointerActive() {
        return controllerPointerActive;
    }

    public static int buttonToKey(Controller controller, int btnCode) {
        ControllerMapping mapping = controller.getMapping();
        if (btnCode == mapping.buttonA) {
            return 96;
        }
        if (btnCode == mapping.buttonB) {
            return 97;
        }
        if (btnCode == mapping.buttonX) {
            return 99;
        }
        if (btnCode == mapping.buttonY) {
            return 100;
        }
        if (btnCode == mapping.buttonBack) {
            return 109;
        }
        if (btnCode == mapping.buttonStart) {
            return 108;
        }
        if (btnCode == mapping.buttonL1) {
            return 102;
        }
        if (btnCode == mapping.buttonL2) {
            return 104;
        }
        if (btnCode == mapping.buttonR1) {
            return 103;
        }
        if (btnCode == mapping.buttonR2) {
            return 105;
        }
        if (btnCode == mapping.buttonDpadUp) {
            return 19;
        }
        if (btnCode == mapping.buttonDpadLeft) {
            return 21;
        }
        if (btnCode == mapping.buttonDpadDown) {
            return 20;
        }
        if (btnCode == mapping.buttonDpadRight) {
            return 22;
        }
        if (btnCode == mapping.buttonLeftStick) {
            return 106;
        }
        if (btnCode == mapping.buttonRightStick) {
            return 107;
        }
        return 0;
    }

    public static boolean icControllerKey(int keyCode) {
        if (keyCode >= 96 && keyCode <= 110) {
            return true;
        }
        return keyCode >= 19 && keyCode <= 21;
    }

    public static String customButtonName(int keyCode) {
        if (lastUsedType == ControllerType.PLAYSTATION) {
            if (keyCode == 96) {
                return "Circle Button";
            }
            if (keyCode == 97) {
                return "Cross Button";
            }
            if (keyCode == 99) {
                return "Square Button";
            }
            if (keyCode == 100) {
                return "Triangle Button";
            }
        }
        return null;
    }

    public static enum ControllerType {
        XBOX,
        PLAYSTATION,
        NINTENDO,
        OTHER;

    }
}

