/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.noosa;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.EventListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextArea;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.watabou.glscripts.Script;
import com.watabou.glwrap.Blending;
import com.watabou.glwrap.Quad;
import com.watabou.glwrap.Texture;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Game;
import com.watabou.noosa.NinePatch;
import com.watabou.noosa.ui.Component;
import com.watabou.utils.FileUtils;
import com.watabou.utils.Point;

public class TextInput
extends Component {
    private Stage stage;
    private Container container;
    private TextField textField;
    private Skin skin;
    private NinePatch bg;

    public TextInput(NinePatch bg, boolean multiline, final int size) {
        this.bg = bg;
        this.add(bg);
        Viewport viewport = new Viewport(){};
        viewport.setWorldSize((float)Game.width, (float)Game.height);
        viewport.setScreenBounds(0, Game.bottomInset, Game.width, Game.height);
        viewport.setCamera((com.badlogic.gdx.graphics.Camera)new OrthographicCamera());
        this.stage = new Stage(viewport);
        Game.inputHandler.addInputProcessor((InputProcessor)this.stage);
        this.container = new Container();
        this.stage.addActor((Actor)this.container);
        this.container.setTransform(true);
        this.skin = new Skin(FileUtils.getFileHandle(Files.FileType.Internal, "gdx/textfield.json"));
        TextField.TextFieldStyle style = (TextField.TextFieldStyle)this.skin.get(TextField.TextFieldStyle.class);
        style.font = Game.platform.getFont(size, "", false, false);
        style.background = null;
        this.textField = multiline ? new TextArea("", style) : new TextField("", style);
        this.textField.setProgrammaticChangeEvents(true);
        if (!multiline) {
            this.textField.setAlignment(1);
        }
        this.textField.addListener((EventListener)new ChangeListener(){

            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                BitmapFont f = Game.platform.getFont(size, TextInput.this.textField.getText(), false, false);
                TextField.TextFieldStyle style = TextInput.this.textField.getStyle();
                if (f != style.font) {
                    style.font = f;
                    TextInput.this.textField.setStyle(style);
                }
            }
        });
        if (!multiline) {
            this.textField.setTextFieldListener(new TextField.TextFieldListener(){

                public void keyTyped(TextField textField, char c) {
                    if (c == '\r' || c == '\n') {
                        TextInput.this.enterPressed();
                    }
                }
            });
        }
        this.container.setActor((Actor)this.textField);
        this.stage.setKeyboardFocus((Actor)this.textField);
        Gdx.input.setOnscreenKeyboardVisible(true);
    }

    public void enterPressed() {
    }

    public void setText(String text) {
        this.textField.setText(text);
        this.textField.setCursorPosition(this.textField.getText().length());
    }

    public void setMaxLength(int maxLength) {
        this.textField.setMaxLength(maxLength);
    }

    public String getText() {
        return this.textField.getText();
    }

    @Override
    protected void layout() {
        super.layout();
        float contX = this.x;
        float contY = this.y;
        float contW = this.width;
        float contH = this.height;
        if (this.bg != null) {
            this.bg.x = this.x;
            this.bg.y = this.y;
            this.bg.size(this.width, this.height);
            contX += (float)this.bg.marginLeft();
            contY += (float)this.bg.marginTop();
            contW -= (float)this.bg.marginHor();
            contH -= (float)this.bg.marginVer();
        }
        float zoom = Camera.main.zoom;
        Camera c = this.camera();
        if (c != null) {
            zoom = c.zoom;
            Point p = c.cameraToScreen(contX, contY);
            contX = (float)p.x / zoom;
            contY = (float)p.y / zoom;
        }
        this.container.align(10);
        this.container.setPosition(contX * zoom, (float)Game.height - contY * zoom);
        this.container.size(contW * zoom, contH * zoom);
    }

    @Override
    public void update() {
        super.update();
        this.stage.act(Game.elapsed);
    }

    @Override
    public void draw() {
        super.draw();
        Quad.releaseIndices();
        Script.unuse();
        Texture.clear();
        this.stage.draw();
        Quad.bindIndices();
        Blending.useDefault();
    }

    @Override
    public synchronized void destroy() {
        super.destroy();
        if (this.stage != null) {
            this.stage.dispose();
            this.skin.dispose();
            Game.inputHandler.removeInputProcessor((InputProcessor)this.stage);
            Gdx.input.setOnscreenKeyboardVisible(false);
            Game.platform.updateSystemUI();
        }
    }
}

