/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Highlighter {
    private static final Pattern HIGHLIGHTER = Pattern.compile("_(.*?)_");
    private static final Pattern STRIPPER = Pattern.compile("[ \n]");
    public String text;
    public boolean[] mask;

    public Highlighter(String text) {
        String stripped = STRIPPER.matcher(text).replaceAll("");
        this.mask = new boolean[stripped.length()];
        Matcher m = HIGHLIGHTER.matcher(stripped);
        int pos = 0;
        int lastMatch = 0;
        while (m.find()) {
            int groupLen = m.group(1).length();
            for (int i = pos += m.start() - lastMatch; i < pos + groupLen; ++i) {
                this.mask[i] = true;
            }
            pos += groupLen;
            lastMatch = m.end();
        }
        m.reset(text);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, m.group(1));
        }
        m.appendTail(sb);
        this.text = sb.toString();
    }

    public boolean[] inverted() {
        boolean[] result = new boolean[this.mask.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = !this.mask[i];
        }
        return result;
    }

    public boolean isHighlighted() {
        for (int i = 0; i < this.mask.length; ++i) {
            if (!this.mask[i]) continue;
            return true;
        }
        return false;
    }
}

