/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.Rankings;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.Statistics;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.Artifact;
import com.shatteredpixel.shatteredpixeldungeon.items.bags.MagicalHolster;
import com.shatteredpixel.shatteredpixeldungeon.items.bags.PotionBandolier;
import com.shatteredpixel.shatteredpixeldungeon.items.bags.ScrollHolder;
import com.shatteredpixel.shatteredpixeldungeon.items.bags.VelvetPouch;
import com.shatteredpixel.shatteredpixeldungeon.journal.Catalog;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.scenes.PixelScene;
import com.shatteredpixel.shatteredpixeldungeon.services.sync.Sync;
import com.shatteredpixel.shatteredpixeldungeon.utils.GLog;
import com.watabou.utils.Bundle;
import com.watabou.utils.FileUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class Badges {
    private static HashSet<Badge> global;
    private static HashSet<Badge> local;
    private static boolean saveNeeded;
    public static final String BADGES_FILE = "badges.dat";
    private static final String BADGES = "badges";
    private static final HashSet<String> removedBadges;
    private static final HashMap<String, String> renamedBadges;
    private static final Badge[][] tierBadgeReplacements;
    private static final Badge[][] metaBadgeReplacements;

    public static void reset() {
        local.clear();
        Badges.loadGlobal();
    }

    public static HashSet<Badge> restore(Bundle bundle) {
        HashSet<Badge> badges = new HashSet<Badge>();
        if (bundle == null) {
            return badges;
        }
        String[] names = bundle.getStringArray(BADGES);
        for (int i = 0; i < names.length; ++i) {
            try {
                if (renamedBadges.containsKey(names[i])) {
                    names[i] = renamedBadges.get(names[i]);
                }
                if (removedBadges.contains(names[i])) continue;
                badges.add(Badge.valueOf(names[i]));
                continue;
            }
            catch (Exception e) {
                ShatteredPixelDungeon.reportException(e);
            }
        }
        Badges.addReplacedBadges(badges);
        return badges;
    }

    public static void store(Bundle bundle, HashSet<Badge> badges) {
        Badges.addReplacedBadges(badges);
        int count = 0;
        String[] names = new String[badges.size()];
        for (Badge badge : badges) {
            names[count++] = badge.toString();
        }
        bundle.put(BADGES, names);
    }

    public static void loadLocal(Bundle bundle) {
        local = Badges.restore(bundle);
    }

    public static void saveLocal(Bundle bundle) {
        Badges.store(bundle, local);
    }

    public static void loadGlobal() {
        if (global == null) {
            try {
                Bundle bundle = FileUtils.bundleFromFile(BADGES_FILE);
                global = Badges.restore(bundle);
            }
            catch (IOException e) {
                global = new HashSet();
            }
        }
    }

    public static void saveGlobal() {
        if (saveNeeded) {
            Bundle bundle = new Bundle();
            Badges.store(bundle, global);
            try {
                FileUtils.bundleToFile(BADGES_FILE, bundle);
                saveNeeded = false;
            }
            catch (IOException e) {
                ShatteredPixelDungeon.reportException(e);
            }
            Sync.syncBadges();
        }
    }

    public static int unlocked(boolean global) {
        if (global) {
            return Badges.global.size();
        }
        return local.size();
    }

    public static void validateMonstersSlain() {
        Badge badge = null;
        if (!local.contains((Object)Badge.MONSTERS_SLAIN_1) && Statistics.enemiesSlain >= 10) {
            badge = Badge.MONSTERS_SLAIN_1;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.MONSTERS_SLAIN_2) && Statistics.enemiesSlain >= 50) {
            badge = Badge.MONSTERS_SLAIN_2;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.MONSTERS_SLAIN_3) && Statistics.enemiesSlain >= 100) {
            badge = Badge.MONSTERS_SLAIN_3;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.MONSTERS_SLAIN_4) && Statistics.enemiesSlain >= 200) {
            badge = Badge.MONSTERS_SLAIN_4;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.MONSTERS_SLAIN_5) && Statistics.enemiesSlain >= 300) {
            badge = Badge.MONSTERS_SLAIN_5;
            local.add(badge);
        }
        Badges.displayBadge(badge);
    }

    public static void validateGoldCollected() {
        Badge badge = null;
        if (!local.contains((Object)Badge.GOLD_COLLECTED_1) && Statistics.goldCollected >= 250) {
            badge = Badge.GOLD_COLLECTED_1;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.GOLD_COLLECTED_2) && Statistics.goldCollected >= 1000) {
            badge = Badge.GOLD_COLLECTED_2;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.GOLD_COLLECTED_3) && Statistics.goldCollected >= 2500) {
            badge = Badge.GOLD_COLLECTED_3;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.GOLD_COLLECTED_4) && Statistics.goldCollected >= 5000) {
            badge = Badge.GOLD_COLLECTED_4;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.GOLD_COLLECTED_5) && Statistics.goldCollected >= 10000) {
            badge = Badge.GOLD_COLLECTED_5;
            local.add(badge);
        }
        Badges.displayBadge(badge);
    }

    public static void validateLevelReached() {
        Badge badge = null;
        if (!local.contains((Object)Badge.LEVEL_REACHED_1) && Dungeon.hero.lvl >= 6) {
            badge = Badge.LEVEL_REACHED_1;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.LEVEL_REACHED_2) && Dungeon.hero.lvl >= 12) {
            badge = Badge.LEVEL_REACHED_2;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.LEVEL_REACHED_3) && Dungeon.hero.lvl >= 18) {
            badge = Badge.LEVEL_REACHED_3;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.LEVEL_REACHED_4) && Dungeon.hero.lvl >= 24) {
            badge = Badge.LEVEL_REACHED_4;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.LEVEL_REACHED_5) && Dungeon.hero.lvl >= 30) {
            badge = Badge.LEVEL_REACHED_5;
            local.add(badge);
        }
        Badges.displayBadge(badge);
    }

    public static void validateStrengthAttained() {
        Badge badge = null;
        if (!local.contains((Object)Badge.STRENGTH_ATTAINED_1) && Dungeon.hero.STR >= 12) {
            badge = Badge.STRENGTH_ATTAINED_1;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.STRENGTH_ATTAINED_2) && Dungeon.hero.STR >= 14) {
            badge = Badge.STRENGTH_ATTAINED_2;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.STRENGTH_ATTAINED_3) && Dungeon.hero.STR >= 16) {
            badge = Badge.STRENGTH_ATTAINED_3;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.STRENGTH_ATTAINED_4) && Dungeon.hero.STR >= 18) {
            badge = Badge.STRENGTH_ATTAINED_4;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.STRENGTH_ATTAINED_5) && Dungeon.hero.STR >= 20) {
            badge = Badge.STRENGTH_ATTAINED_5;
            local.add(badge);
        }
        Badges.displayBadge(badge);
    }

    public static void validateFoodEaten() {
        Badge badge = null;
        if (!local.contains((Object)Badge.FOOD_EATEN_1) && Statistics.foodEaten >= 10) {
            badge = Badge.FOOD_EATEN_1;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.FOOD_EATEN_2) && Statistics.foodEaten >= 20) {
            badge = Badge.FOOD_EATEN_2;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.FOOD_EATEN_3) && Statistics.foodEaten >= 30) {
            badge = Badge.FOOD_EATEN_3;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.FOOD_EATEN_4) && Statistics.foodEaten >= 40) {
            badge = Badge.FOOD_EATEN_4;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.FOOD_EATEN_5) && Statistics.foodEaten >= 50) {
            badge = Badge.FOOD_EATEN_5;
            local.add(badge);
        }
        Badges.displayBadge(badge);
    }

    public static void validateItemsCrafted() {
        Badge badge = null;
        if (!local.contains((Object)Badge.ITEMS_CRAFTED_1) && Statistics.itemsCrafted >= 5) {
            badge = Badge.ITEMS_CRAFTED_1;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.ITEMS_CRAFTED_2) && Statistics.itemsCrafted >= 10) {
            badge = Badge.ITEMS_CRAFTED_2;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.ITEMS_CRAFTED_3) && Statistics.itemsCrafted >= 15) {
            badge = Badge.ITEMS_CRAFTED_3;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.ITEMS_CRAFTED_4) && Statistics.itemsCrafted >= 20) {
            badge = Badge.ITEMS_CRAFTED_4;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.ITEMS_CRAFTED_5) && Statistics.itemsCrafted >= 25) {
            badge = Badge.ITEMS_CRAFTED_5;
            local.add(badge);
        }
        Badges.displayBadge(badge);
    }

    public static void validatePiranhasKilled() {
        Badge badge = null;
        if (!local.contains((Object)Badge.PIRANHAS) && Statistics.piranhasKilled >= 6) {
            badge = Badge.PIRANHAS;
            local.add(badge);
        }
        Badges.displayBadge(badge);
    }

    public static void validateItemLevelAquired(Item item) {
        if (!item.levelKnown || item instanceof Artifact) {
            return;
        }
        Badge badge = null;
        if (!local.contains((Object)Badge.ITEM_LEVEL_1) && item.level() >= 3) {
            badge = Badge.ITEM_LEVEL_1;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.ITEM_LEVEL_2) && item.level() >= 6) {
            badge = Badge.ITEM_LEVEL_2;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.ITEM_LEVEL_3) && item.level() >= 9) {
            badge = Badge.ITEM_LEVEL_3;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.ITEM_LEVEL_4) && item.level() >= 12) {
            badge = Badge.ITEM_LEVEL_4;
            local.add(badge);
        }
        if (!local.contains((Object)Badge.ITEM_LEVEL_5) && item.level() >= 15) {
            badge = Badge.ITEM_LEVEL_5;
            local.add(badge);
        }
        Badges.displayBadge(badge);
    }

    public static void validateAllBagsBought(Item bag) {
        Badge badge = null;
        if (bag instanceof VelvetPouch) {
            badge = Badge.BAG_BOUGHT_VELVET_POUCH;
        } else if (bag instanceof ScrollHolder) {
            badge = Badge.BAG_BOUGHT_SCROLL_HOLDER;
        } else if (bag instanceof PotionBandolier) {
            badge = Badge.BAG_BOUGHT_POTION_BANDOLIER;
        } else if (bag instanceof MagicalHolster) {
            badge = Badge.BAG_BOUGHT_MAGICAL_HOLSTER;
        }
        if (badge != null) {
            local.add(badge);
            if (!local.contains((Object)Badge.ALL_BAGS_BOUGHT) && local.contains((Object)Badge.BAG_BOUGHT_VELVET_POUCH) && local.contains((Object)Badge.BAG_BOUGHT_SCROLL_HOLDER) && local.contains((Object)Badge.BAG_BOUGHT_POTION_BANDOLIER) && local.contains((Object)Badge.BAG_BOUGHT_MAGICAL_HOLSTER)) {
                badge = Badge.ALL_BAGS_BOUGHT;
                local.add(badge);
                Badges.displayBadge(badge);
            }
        }
    }

    public static void validateItemsIdentified() {
        for (Catalog cat : Catalog.values()) {
            Badge b;
            if (!cat.allSeen() || global.contains((Object)(b = Catalog.catalogBadges.get((Object)cat)))) continue;
            Badges.displayBadge(b);
        }
        if (!global.contains((Object)Badge.ALL_ITEMS_IDENTIFIED) && global.contains((Object)Badge.ALL_WEAPONS_IDENTIFIED) && global.contains((Object)Badge.ALL_ARMOR_IDENTIFIED) && global.contains((Object)Badge.ALL_WANDS_IDENTIFIED) && global.contains((Object)Badge.ALL_RINGS_IDENTIFIED) && global.contains((Object)Badge.ALL_ARTIFACTS_IDENTIFIED) && global.contains((Object)Badge.ALL_POTIONS_IDENTIFIED) && global.contains((Object)Badge.ALL_SCROLLS_IDENTIFIED)) {
            Badges.displayBadge(Badge.ALL_ITEMS_IDENTIFIED);
        }
    }

    public static void validateDeathFromFire() {
        Badge badge = Badge.DEATH_FROM_FIRE;
        local.add(badge);
        Badges.displayBadge(badge);
        Badges.validateYASD();
    }

    public static void validateDeathFromPoison() {
        Badge badge = Badge.DEATH_FROM_POISON;
        local.add(badge);
        Badges.displayBadge(badge);
        Badges.validateYASD();
    }

    public static void validateDeathFromGas() {
        Badge badge = Badge.DEATH_FROM_GAS;
        local.add(badge);
        Badges.displayBadge(badge);
        Badges.validateYASD();
    }

    public static void validateDeathFromHunger() {
        Badge badge = Badge.DEATH_FROM_HUNGER;
        local.add(badge);
        Badges.displayBadge(badge);
        Badges.validateYASD();
    }

    public static void validateDeathFromGlyph() {
        Badge badge = Badge.DEATH_FROM_GLYPH;
        local.add(badge);
        Badges.displayBadge(badge);
        Badges.validateYASD();
    }

    public static void validateDeathFromFalling() {
        Badge badge = Badge.DEATH_FROM_FALLING;
        local.add(badge);
        Badges.displayBadge(badge);
        Badges.validateYASD();
    }

    private static void validateYASD() {
        if (global.contains((Object)Badge.DEATH_FROM_FIRE) && global.contains((Object)Badge.DEATH_FROM_POISON) && global.contains((Object)Badge.DEATH_FROM_GAS) && global.contains((Object)Badge.DEATH_FROM_HUNGER) && global.contains((Object)Badge.DEATH_FROM_GLYPH) && global.contains((Object)Badge.DEATH_FROM_FALLING)) {
            Badge badge = Badge.YASD;
            Badges.displayBadge(badge);
        }
    }

    public static void validateBossSlain() {
        Badge badge = null;
        switch (Dungeon.depth) {
            case 5: {
                badge = Badge.BOSS_SLAIN_1;
                break;
            }
            case 10: {
                badge = Badge.BOSS_SLAIN_2;
                break;
            }
            case 15: {
                badge = Badge.BOSS_SLAIN_3;
                break;
            }
            case 20: {
                badge = Badge.BOSS_SLAIN_4;
            }
        }
        if (badge != null) {
            local.add(badge);
            Badges.displayBadge(badge);
            if (badge == Badge.BOSS_SLAIN_1) {
                switch (Dungeon.hero.heroClass) {
                    case WARRIOR: {
                        badge = Badge.BOSS_SLAIN_1_WARRIOR;
                        break;
                    }
                    case MAGE: {
                        badge = Badge.BOSS_SLAIN_1_MAGE;
                        break;
                    }
                    case ROGUE: {
                        badge = Badge.BOSS_SLAIN_1_ROGUE;
                        break;
                    }
                    case HUNTRESS: {
                        badge = Badge.BOSS_SLAIN_1_HUNTRESS;
                    }
                }
                local.add(badge);
                if (!global.contains((Object)badge)) {
                    global.add(badge);
                    saveNeeded = true;
                }
                if (global.contains((Object)Badge.BOSS_SLAIN_1_WARRIOR) && global.contains((Object)Badge.BOSS_SLAIN_1_MAGE) && global.contains((Object)Badge.BOSS_SLAIN_1_ROGUE) && global.contains((Object)Badge.BOSS_SLAIN_1_HUNTRESS) && !global.contains((Object)(badge = Badge.BOSS_SLAIN_1_ALL_CLASSES))) {
                    Badges.displayBadge(badge);
                    global.add(badge);
                    saveNeeded = true;
                }
            } else if (badge == Badge.BOSS_SLAIN_3) {
                switch (Dungeon.hero.subClass) {
                    case GLADIATOR: {
                        badge = Badge.BOSS_SLAIN_3_GLADIATOR;
                        break;
                    }
                    case BERSERKER: {
                        badge = Badge.BOSS_SLAIN_3_BERSERKER;
                        break;
                    }
                    case WARLOCK: {
                        badge = Badge.BOSS_SLAIN_3_WARLOCK;
                        break;
                    }
                    case BATTLEMAGE: {
                        badge = Badge.BOSS_SLAIN_3_BATTLEMAGE;
                        break;
                    }
                    case FREERUNNER: {
                        badge = Badge.BOSS_SLAIN_3_FREERUNNER;
                        break;
                    }
                    case ASSASSIN: {
                        badge = Badge.BOSS_SLAIN_3_ASSASSIN;
                        break;
                    }
                    case SNIPER: {
                        badge = Badge.BOSS_SLAIN_3_SNIPER;
                        break;
                    }
                    case WARDEN: {
                        badge = Badge.BOSS_SLAIN_3_WARDEN;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                local.add(badge);
                if (!global.contains((Object)badge)) {
                    global.add(badge);
                    saveNeeded = true;
                }
                if (global.contains((Object)Badge.BOSS_SLAIN_3_GLADIATOR) && global.contains((Object)Badge.BOSS_SLAIN_3_BERSERKER) && global.contains((Object)Badge.BOSS_SLAIN_3_WARLOCK) && global.contains((Object)Badge.BOSS_SLAIN_3_BATTLEMAGE) && global.contains((Object)Badge.BOSS_SLAIN_3_FREERUNNER) && global.contains((Object)Badge.BOSS_SLAIN_3_ASSASSIN) && global.contains((Object)Badge.BOSS_SLAIN_3_SNIPER) && global.contains((Object)Badge.BOSS_SLAIN_3_WARDEN) && !global.contains((Object)(badge = Badge.BOSS_SLAIN_3_ALL_SUBCLASSES))) {
                    Badges.displayBadge(badge);
                    global.add(badge);
                    saveNeeded = true;
                }
            }
        }
    }

    public static void validateMastery() {
        Badge badge = null;
        switch (Dungeon.hero.heroClass) {
            case WARRIOR: {
                badge = Badge.MASTERY_WARRIOR;
                break;
            }
            case MAGE: {
                badge = Badge.MASTERY_MAGE;
                break;
            }
            case ROGUE: {
                badge = Badge.MASTERY_ROGUE;
                break;
            }
            case HUNTRESS: {
                badge = Badge.MASTERY_HUNTRESS;
            }
        }
        if (!global.contains((Object)badge)) {
            global.add(badge);
            saveNeeded = true;
        }
    }

    public static void validateRatmogrify() {
        if (!global.contains((Object)Badge.FOUND_RATMOGRIFY)) {
            global.add(Badge.FOUND_RATMOGRIFY);
            saveNeeded = true;
        }
    }

    public static void validateMageUnlock() {
        if (Statistics.upgradesUsed >= 1 && !global.contains((Object)Badge.UNLOCK_MAGE)) {
            Badges.displayBadge(Badge.UNLOCK_MAGE);
        }
    }

    public static void validateRogueUnlock() {
        if (Statistics.sneakAttacks >= 10 && !global.contains((Object)Badge.UNLOCK_ROGUE)) {
            Badges.displayBadge(Badge.UNLOCK_ROGUE);
        }
    }

    public static void validateHuntressUnlock() {
        if (Statistics.thrownAssists >= 15 && !global.contains((Object)Badge.UNLOCK_HUNTRESS)) {
            Badges.displayBadge(Badge.UNLOCK_HUNTRESS);
        }
    }

    public static void validateMasteryCombo(int n) {
        if (!local.contains((Object)Badge.MASTERY_COMBO) && n == 10) {
            Badge badge = Badge.MASTERY_COMBO;
            local.add(badge);
            Badges.displayBadge(badge);
        }
    }

    public static void validateVictory() {
        Badge badge = Badge.VICTORY;
        Badges.displayBadge(badge);
        switch (Dungeon.hero.heroClass) {
            case WARRIOR: {
                badge = Badge.VICTORY_WARRIOR;
                break;
            }
            case MAGE: {
                badge = Badge.VICTORY_MAGE;
                break;
            }
            case ROGUE: {
                badge = Badge.VICTORY_ROGUE;
                break;
            }
            case HUNTRESS: {
                badge = Badge.VICTORY_HUNTRESS;
            }
        }
        local.add(badge);
        if (!global.contains((Object)badge)) {
            global.add(badge);
            saveNeeded = true;
        }
        if (global.contains((Object)Badge.VICTORY_WARRIOR) && global.contains((Object)Badge.VICTORY_MAGE) && global.contains((Object)Badge.VICTORY_ROGUE) && global.contains((Object)Badge.VICTORY_HUNTRESS)) {
            badge = Badge.VICTORY_ALL_CLASSES;
            Badges.displayBadge(badge);
        }
    }

    public static void validateNoKilling() {
        if (!local.contains((Object)Badge.NO_MONSTERS_SLAIN) && Statistics.completedWithNoKilling) {
            Badge badge = Badge.NO_MONSTERS_SLAIN;
            local.add(badge);
            Badges.displayBadge(badge);
        }
    }

    public static void validateGrimWeapon() {
        if (!local.contains((Object)Badge.GRIM_WEAPON)) {
            Badge badge = Badge.GRIM_WEAPON;
            local.add(badge);
            Badges.displayBadge(badge);
        }
    }

    public static void validateGamesPlayed() {
        Badge badge = null;
        if (Rankings.INSTANCE.totalNumber >= 10 || Rankings.INSTANCE.wonNumber >= 1) {
            badge = Badge.GAMES_PLAYED_1;
        }
        if (Rankings.INSTANCE.totalNumber >= 50 || Rankings.INSTANCE.wonNumber >= 5) {
            badge = Badge.GAMES_PLAYED_2;
        }
        if (Rankings.INSTANCE.totalNumber >= 100 || Rankings.INSTANCE.wonNumber >= 10) {
            badge = Badge.GAMES_PLAYED_3;
        }
        if (Rankings.INSTANCE.totalNumber >= 250 || Rankings.INSTANCE.wonNumber >= 25) {
            badge = Badge.GAMES_PLAYED_4;
        }
        if (Rankings.INSTANCE.totalNumber >= 1000 || Rankings.INSTANCE.wonNumber >= 100) {
            badge = Badge.GAMES_PLAYED_5;
        }
        Badges.displayBadge(badge);
    }

    public static void silentValidateHappyEnd() {
        if (!local.contains((Object)Badge.HAPPY_END)) {
            local.add(Badge.HAPPY_END);
        }
    }

    public static void validateHappyEnd() {
        Badges.displayBadge(Badge.HAPPY_END);
    }

    public static void validateChampion(int challenges) {
        if (challenges == 0) {
            return;
        }
        Badge badge = null;
        if (challenges >= 1) {
            badge = Badge.CHAMPION_1;
        }
        if (challenges >= 3) {
            if (!global.contains((Object)badge)) {
                global.add(badge);
                saveNeeded = true;
            }
            badge = Badge.CHAMPION_2;
        }
        if (challenges >= 6) {
            if (!global.contains((Object)badge)) {
                global.add(badge);
                saveNeeded = true;
            }
            badge = Badge.CHAMPION_3;
        }
        local.add(badge);
        Badges.displayBadge(badge);
    }

    private static void displayBadge(Badge badge) {
        if (badge == null) {
            return;
        }
        if (global.contains((Object)badge)) {
            if (!badge.meta) {
                GLog.h(Messages.get(Badges.class, "endorsed", badge.title()), new Object[0]);
                GLog.newLine();
            }
        } else {
            global.add(badge);
            saveNeeded = true;
            GLog.h(Messages.get(Badges.class, "new", badge.title() + " (" + badge.desc() + ")"), new Object[0]);
            GLog.newLine();
            PixelScene.showBadge(badge);
        }
    }

    public static boolean isUnlocked(Badge badge) {
        return global.contains((Object)badge);
    }

    public static HashSet<Badge> allUnlocked() {
        Badges.loadGlobal();
        return new HashSet<Badge>(global);
    }

    public static void disown(Badge badge) {
        Badges.loadGlobal();
        global.remove((Object)badge);
        saveNeeded = true;
    }

    public static void addGlobal(Badge badge) {
        if (!global.contains((Object)badge)) {
            global.add(badge);
            saveNeeded = true;
        }
    }

    public static List<Badge> filterReplacedBadges(boolean global) {
        ArrayList<Badge> badges = new ArrayList<Badge>(global ? Badges.global : local);
        Iterator<Badge> iterator = badges.iterator();
        while (iterator.hasNext()) {
            Badge badge = iterator.next();
            if ((global || !badge.meta) && badge.image != -1) continue;
            iterator.remove();
        }
        Collections.sort(badges);
        return Badges.filterReplacedBadges(badges);
    }

    public static List<Badge> filterReplacedBadges(List<Badge> badges) {
        for (Badge[] tierReplace : tierBadgeReplacements) {
            Badges.leaveBest(badges, tierReplace);
        }
        for (Badge[] metaReplace : metaBadgeReplacements) {
            Badges.leaveBest(badges, metaReplace);
        }
        return badges;
    }

    private static void leaveBest(Collection<Badge> list, Badge ... badges) {
        for (int i = badges.length - 1; i > 0; --i) {
            if (!list.contains((Object)badges[i])) continue;
            for (int j = 0; j < i; ++j) {
                list.remove((Object)badges[j]);
            }
            break;
        }
    }

    public static List<Badge> filterHigherIncrementalBadges(List<Badge> badges) {
        for (Badge[] tierReplace : tierBadgeReplacements) {
            Badges.leaveWorst(badges, tierReplace);
        }
        Collections.sort(badges);
        return badges;
    }

    private static void leaveWorst(Collection<Badge> list, Badge ... badges) {
        for (int i = 0; i < badges.length; ++i) {
            if (!list.contains((Object)badges[i])) continue;
            for (int j = i + 1; j < badges.length; ++j) {
                list.remove((Object)badges[j]);
            }
            break;
        }
    }

    public static Collection<Badge> addReplacedBadges(Collection<Badge> badges) {
        for (Badge[] tierReplace : tierBadgeReplacements) {
            Badges.addLower(badges, tierReplace);
        }
        for (Badge[] metaReplace : metaBadgeReplacements) {
            Badges.addLower(badges, metaReplace);
        }
        return badges;
    }

    private static void addLower(Collection<Badge> list, Badge ... badges) {
        for (int i = badges.length - 1; i > 0; --i) {
            if (!list.contains((Object)badges[i])) continue;
            for (int j = 0; j < i; ++j) {
                list.add(badges[j]);
            }
            break;
        }
    }

    static {
        local = new HashSet();
        saveNeeded = false;
        removedBadges = new HashSet();
        renamedBadges = new HashMap();
        renamedBadges.put("BAG_BOUGHT_SEED_POUCH", "BAG_BOUGHT_VELVET_POUCH");
        renamedBadges.put("BAG_BOUGHT_WAND_HOLSTER", "BAG_BOUGHT_MAGICAL_HOLSTER");
        renamedBadges.put("POTIONS_COOKED_1", "ITEMS_CRAFTED_1");
        renamedBadges.put("POTIONS_COOKED_2", "ITEMS_CRAFTED_2");
        renamedBadges.put("POTIONS_COOKED_3", "ITEMS_CRAFTED_3");
        renamedBadges.put("POTIONS_COOKED_4", "ITEMS_CRAFTED_4");
        tierBadgeReplacements = new Badge[][]{{Badge.MONSTERS_SLAIN_1, Badge.MONSTERS_SLAIN_2, Badge.MONSTERS_SLAIN_3, Badge.MONSTERS_SLAIN_4, Badge.MONSTERS_SLAIN_5}, {Badge.GOLD_COLLECTED_1, Badge.GOLD_COLLECTED_2, Badge.GOLD_COLLECTED_3, Badge.GOLD_COLLECTED_4, Badge.GOLD_COLLECTED_5}, {Badge.ITEM_LEVEL_1, Badge.ITEM_LEVEL_2, Badge.ITEM_LEVEL_3, Badge.ITEM_LEVEL_4, Badge.ITEM_LEVEL_5}, {Badge.LEVEL_REACHED_1, Badge.LEVEL_REACHED_2, Badge.LEVEL_REACHED_3, Badge.LEVEL_REACHED_4, Badge.LEVEL_REACHED_5}, {Badge.STRENGTH_ATTAINED_1, Badge.STRENGTH_ATTAINED_2, Badge.STRENGTH_ATTAINED_3, Badge.STRENGTH_ATTAINED_4, Badge.STRENGTH_ATTAINED_5}, {Badge.FOOD_EATEN_1, Badge.FOOD_EATEN_2, Badge.FOOD_EATEN_3, Badge.FOOD_EATEN_4, Badge.FOOD_EATEN_5}, {Badge.ITEMS_CRAFTED_1, Badge.ITEMS_CRAFTED_2, Badge.ITEMS_CRAFTED_3, Badge.ITEMS_CRAFTED_4, Badge.ITEMS_CRAFTED_5}, {Badge.BOSS_SLAIN_1, Badge.BOSS_SLAIN_2, Badge.BOSS_SLAIN_3, Badge.BOSS_SLAIN_4}, {Badge.GAMES_PLAYED_1, Badge.GAMES_PLAYED_2, Badge.GAMES_PLAYED_3, Badge.GAMES_PLAYED_4, Badge.GAMES_PLAYED_5}, {Badge.CHAMPION_1, Badge.CHAMPION_2, Badge.CHAMPION_3}};
        metaBadgeReplacements = new Badge[][]{{Badge.DEATH_FROM_FIRE, Badge.YASD}, {Badge.DEATH_FROM_GAS, Badge.YASD}, {Badge.DEATH_FROM_HUNGER, Badge.YASD}, {Badge.DEATH_FROM_POISON, Badge.YASD}, {Badge.DEATH_FROM_GLYPH, Badge.YASD}, {Badge.DEATH_FROM_FALLING, Badge.YASD}, {Badge.ALL_WEAPONS_IDENTIFIED, Badge.ALL_ITEMS_IDENTIFIED}, {Badge.ALL_ARMOR_IDENTIFIED, Badge.ALL_ITEMS_IDENTIFIED}, {Badge.ALL_WANDS_IDENTIFIED, Badge.ALL_ITEMS_IDENTIFIED}, {Badge.ALL_RINGS_IDENTIFIED, Badge.ALL_ITEMS_IDENTIFIED}, {Badge.ALL_ARTIFACTS_IDENTIFIED, Badge.ALL_ITEMS_IDENTIFIED}, {Badge.ALL_POTIONS_IDENTIFIED, Badge.ALL_ITEMS_IDENTIFIED}, {Badge.ALL_SCROLLS_IDENTIFIED, Badge.ALL_ITEMS_IDENTIFIED}};
    }

    public static enum Badge {
        MASTERY_WARRIOR,
        MASTERY_MAGE,
        MASTERY_ROGUE,
        MASTERY_HUNTRESS,
        FOUND_RATMOGRIFY,
        UNLOCK_MAGE(1),
        UNLOCK_ROGUE(2),
        UNLOCK_HUNTRESS(3),
        MONSTERS_SLAIN_1(4),
        MONSTERS_SLAIN_2(5),
        GOLD_COLLECTED_1(6),
        GOLD_COLLECTED_2(7),
        ITEM_LEVEL_1(8),
        LEVEL_REACHED_1(9),
        STRENGTH_ATTAINED_1(10),
        FOOD_EATEN_1(11),
        ITEMS_CRAFTED_1(12),
        BOSS_SLAIN_1(13),
        DEATH_FROM_FIRE(14),
        DEATH_FROM_POISON(15),
        DEATH_FROM_GAS(16),
        DEATH_FROM_HUNGER(17),
        DEATH_FROM_FALLING(18),
        GAMES_PLAYED_1(19, true),
        NO_MONSTERS_SLAIN(32),
        GRIM_WEAPON(33),
        MONSTERS_SLAIN_3(34),
        MONSTERS_SLAIN_4(35),
        GOLD_COLLECTED_3(36),
        GOLD_COLLECTED_4(37),
        ITEM_LEVEL_2(38),
        ITEM_LEVEL_3(39),
        LEVEL_REACHED_2(40),
        LEVEL_REACHED_3(41),
        STRENGTH_ATTAINED_2(42),
        STRENGTH_ATTAINED_3(43),
        FOOD_EATEN_2(44),
        FOOD_EATEN_3(45),
        ITEMS_CRAFTED_2(46),
        ITEMS_CRAFTED_3(47),
        BOSS_SLAIN_2(48),
        BOSS_SLAIN_3(49),
        ALL_POTIONS_IDENTIFIED(50),
        ALL_SCROLLS_IDENTIFIED(51),
        DEATH_FROM_GLYPH(52),
        BOSS_SLAIN_1_WARRIOR,
        BOSS_SLAIN_1_MAGE,
        BOSS_SLAIN_1_ROGUE,
        BOSS_SLAIN_1_HUNTRESS,
        BOSS_SLAIN_1_ALL_CLASSES(53, true),
        GAMES_PLAYED_2(54, true),
        PIRANHAS(64),
        BAG_BOUGHT_VELVET_POUCH,
        BAG_BOUGHT_SCROLL_HOLDER,
        BAG_BOUGHT_POTION_BANDOLIER,
        BAG_BOUGHT_MAGICAL_HOLSTER,
        ALL_BAGS_BOUGHT(65),
        MASTERY_COMBO(66),
        MONSTERS_SLAIN_5(67),
        GOLD_COLLECTED_5(68),
        ITEM_LEVEL_4(69),
        ITEM_LEVEL_5(70),
        LEVEL_REACHED_4(71),
        LEVEL_REACHED_5(72),
        STRENGTH_ATTAINED_4(73),
        STRENGTH_ATTAINED_5(74),
        FOOD_EATEN_4(75),
        FOOD_EATEN_5(76),
        ITEMS_CRAFTED_4(77),
        ITEMS_CRAFTED_5(78),
        BOSS_SLAIN_4(79),
        ALL_WEAPONS_IDENTIFIED(80),
        ALL_ARMOR_IDENTIFIED(81),
        ALL_WANDS_IDENTIFIED(82),
        ALL_RINGS_IDENTIFIED(83),
        ALL_ARTIFACTS_IDENTIFIED(84),
        VICTORY(85),
        YASD(86, true),
        BOSS_SLAIN_3_GLADIATOR,
        BOSS_SLAIN_3_BERSERKER,
        BOSS_SLAIN_3_WARLOCK,
        BOSS_SLAIN_3_BATTLEMAGE,
        BOSS_SLAIN_3_FREERUNNER,
        BOSS_SLAIN_3_ASSASSIN,
        BOSS_SLAIN_3_SNIPER,
        BOSS_SLAIN_3_WARDEN,
        BOSS_SLAIN_3_ALL_SUBCLASSES(87, true),
        GAMES_PLAYED_3(88, true),
        HAPPY_END(96),
        ALL_ITEMS_IDENTIFIED(97, true),
        VICTORY_WARRIOR,
        VICTORY_MAGE,
        VICTORY_ROGUE,
        VICTORY_HUNTRESS,
        VICTORY_ALL_CLASSES(98, true),
        GAMES_PLAYED_4(99, true),
        CHAMPION_1(100),
        GAMES_PLAYED_5(112, true),
        CHAMPION_2(113),
        CHAMPION_3(114);

        public boolean meta;
        public int image;

        private Badge(int image) {
            this(image, false);
        }

        private Badge(int image, boolean meta) {
            this.image = image;
            this.meta = meta;
        }

        public String title() {
            return Messages.get((Object)this, this.name() + ".title", new Object[0]);
        }

        public String desc() {
            return Messages.get((Object)this, this.name() + ".desc", new Object[0]);
        }

        private Badge() {
            this(-1);
        }
    }
}

