/*
 * Decompiled with CFR 0.152.
 */
package com.shatteredpixel.shatteredpixeldungeon;

import com.shatteredpixel.shatteredpixeldungeon.Dungeon;
import com.shatteredpixel.shatteredpixeldungeon.ShatteredPixelDungeon;
import com.shatteredpixel.shatteredpixeldungeon.Statistics;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.Hero;
import com.shatteredpixel.shatteredpixeldungeon.actors.hero.HeroClass;
import com.shatteredpixel.shatteredpixeldungeon.items.Generator;
import com.shatteredpixel.shatteredpixeldungeon.items.Gold;
import com.shatteredpixel.shatteredpixeldungeon.items.Item;
import com.shatteredpixel.shatteredpixeldungeon.items.Waterskin;
import com.shatteredpixel.shatteredpixeldungeon.items.artifacts.Artifact;
import com.shatteredpixel.shatteredpixeldungeon.items.potions.PotionOfHealing;
import com.shatteredpixel.shatteredpixeldungeon.items.weapon.missiles.MissileWeapon;
import com.shatteredpixel.shatteredpixeldungeon.messages.Messages;
import com.shatteredpixel.shatteredpixeldungeon.services.payment.Payment;
import com.watabou.utils.Bundle;
import com.watabou.utils.FileUtils;
import com.watabou.utils.Random;
import com.watabou.utils.Reflection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class Bones {
    private static final String BONES_FILE = "bones.dat";
    private static final String LEVEL = "level";
    private static final String ITEM = "item";
    private static final String NAME = "hero_name";
    private static final String CLASS = "class_name";
    private static final String KILLED = "enemies_slain";
    private static final String HEALING = "available_healing";
    private static String name;
    private static HeroClass heroClass;
    private static int killed;
    private static int healing;
    private static int depth;
    private static Item item;

    public static void leave() {
        depth = Dungeon.depth;
        if (Statistics.amuletObtained || Statistics.deepestFloor - 5 >= depth || Dungeon.challenges > 0) {
            depth = -1;
            return;
        }
        item = Bones.pickItem(Dungeon.hero);
        Bundle bundle = new Bundle();
        bundle.put(LEVEL, depth);
        bundle.put(ITEM, item);
        if (Payment.isTierUnlocked(1)) {
            Bones.setEpitaphProps(bundle);
        }
        try {
            FileUtils.bundleToFile(BONES_FILE, bundle);
        }
        catch (IOException e) {
            ShatteredPixelDungeon.reportException(e);
        }
    }

    private static Item pickItem(Hero hero) {
        Item item = null;
        if (Random.Int(3) != 0) {
            switch (Random.Int(7)) {
                case 0: {
                    item = hero.belongings.weapon;
                    break;
                }
                case 1: {
                    item = hero.belongings.armor;
                    break;
                }
                case 2: {
                    item = hero.belongings.artifact;
                    break;
                }
                case 3: {
                    item = hero.belongings.misc;
                    break;
                }
                case 4: {
                    item = hero.belongings.ring;
                    break;
                }
                case 5: 
                case 6: {
                    item = Dungeon.quickslot.randomNonePlaceholder();
                }
            }
            if (item == null || !item.bones) {
                return Bones.pickItem(hero);
            }
        } else {
            Iterator<Item> iterator = hero.belongings.backpack.iterator();
            ArrayList<Item> items = new ArrayList<Item>();
            while (iterator.hasNext()) {
                Item curItem = iterator.next();
                if (!curItem.bones) continue;
                items.add(curItem);
            }
            if (Random.Int(3) < items.size()) {
                item = (Item)Random.element(items);
                if (item.stackable) {
                    item.quantity(Random.NormalIntRange(1, (item.quantity() + 1) / 2));
                }
            } else {
                item = Dungeon.gold > 100 ? new Gold(Random.NormalIntRange(50, Dungeon.gold / 2)) : new Gold(50);
            }
        }
        return item;
    }

    public static Item get() {
        if (depth == -1) {
            try {
                Bundle bundle = FileUtils.bundleFromFile(BONES_FILE);
                depth = bundle.getInt(LEVEL);
                if (depth > 0) {
                    item = (Item)bundle.get(ITEM);
                    Bones.loadEpitaphProps(bundle);
                }
                return Bones.get();
            }
            catch (IOException e) {
                return null;
            }
        }
        if (depth == Dungeon.depth && Dungeon.challenges == 0) {
            Bundle emptyBones = new Bundle();
            emptyBones.put(LEVEL, 0);
            try {
                FileUtils.bundleToFile(BONES_FILE, emptyBones);
            }
            catch (IOException e) {
                ShatteredPixelDungeon.reportException(e);
            }
            depth = 0;
            if (item == null) {
                return null;
            }
            if (item instanceof Artifact) {
                if (Generator.removeArtifact(((Artifact)item).getClass())) {
                    Artifact artifact = (Artifact)Reflection.newInstance(((Artifact)item).getClass());
                    if (artifact == null) {
                        return new Gold(item.value());
                    }
                    artifact.cursed = true;
                    artifact.cursedKnown = true;
                    return artifact;
                }
                return new Gold(item.value());
            }
            if (item.isUpgradable() && !(item instanceof MissileWeapon)) {
                Bones.item.cursed = true;
                Bones.item.cursedKnown = true;
            }
            if (item.isUpgradable()) {
                if (item.level() > 3) {
                    item.degrade(item.level() - 3);
                }
                Bones.item.levelKnown = item instanceof MissileWeapon;
            }
            item.reset();
            return item;
        }
        return null;
    }

    private static void setEpitaphProps(Bundle bundle) {
        name = Dungeon.hero.name().equals(Dungeon.hero.className()) ? "" : Dungeon.hero.name();
        heroClass = Dungeon.hero.heroClass;
        killed = Statistics.enemiesSlain;
        healing = 0;
        Waterskin waterskin = Dungeon.hero.belongings.getItem(Waterskin.class);
        if (waterskin != null && waterskin.isFull()) {
            healing = 2;
        } else if (Dungeon.hero.belongings.getItem(PotionOfHealing.class) != null) {
            healing = 1;
        }
        bundle.put(NAME, name);
        bundle.put(CLASS, heroClass);
        bundle.put(KILLED, killed);
        bundle.put(HEALING, healing);
    }

    private static void loadEpitaphProps(Bundle bundle) {
        if (bundle.contains(CLASS)) {
            name = bundle.getString(NAME);
            heroClass = bundle.getEnum(CLASS, HeroClass.class);
            healing = bundle.getInt(HEALING);
            killed = bundle.getInt(KILLED);
        }
    }

    public static String getEpitaph() {
        if (!Payment.isTierUnlocked(1)) {
            return null;
        }
        if (heroClass == null) {
            return null;
        }
        String result = "";
        result = name.equals("") ? result + Messages.get(Bones.class, "here_lies_nameless", heroClass.title()) : result + Messages.get(Bones.class, "here_lies_named", name, heroClass.title());
        result = result + "\n\n";
        result = killed == 0 ? result + Messages.get(Bones.class, "pacifist", new Object[0]) : (depth < 4 ? result + Messages.get(Bones.class, "rats", killed) : (depth < 7 ? result + Messages.get(Bones.class, "crabs", killed) : (depth < 9 ? result + Messages.get(Bones.class, "undead", killed) : (depth < 11 ? result + Messages.get(Bones.class, "thieves", killed) : (depth < 14 ? result + Messages.get(Bones.class, "bats", killed) : (depth < 17 ? result + Messages.get(Bones.class, "brutes", killed) : (depth < 19 ? result + Messages.get(Bones.class, "monks", killed) : (depth < 21 ? result + Messages.get(Bones.class, "golems", killed) : (depth < 25 ? result + Messages.get(Bones.class, "demons", killed) : result + Messages.get(Bones.class, "yog", killed))))))))));
        if (healing == 1) {
            result = result + "\n\n" + Messages.get(Bones.class, "forgot_waterskin", new Object[0]);
        } else if (healing == 2) {
            result = result + "\n\n" + Messages.get(Bones.class, "forgot_potion", new Object[0]);
        }
        result = result + "\n\n" + Messages.get(Bones.class, "rest_in_peace", new Object[0]);
        heroClass = null;
        return result;
    }

    static {
        depth = -1;
    }
}

